/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bundle.blacklist.internal;

import com.liferay.portal.bundle.blacklist.BundleBlacklistManager;
import com.liferay.portal.bundle.blacklist.internal.BundleBlacklist;
import com.liferay.portal.bundle.blacklist.internal.configuration.BundleBlacklistConfiguration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BundleBlacklistManager.class})
public class BundleBlacklistManagerImpl
implements BundleBlacklistManager {
    private static final Log _log = LogFactoryUtil.getLog(BundleBlacklistManagerImpl.class);
    @Reference
    private BundleBlacklist _bundleBlacklist;
    @Reference
    private ConfigurationAdmin _configurationAdmin;

    public void addToBlacklistAndUninstall(String ... bundleSymbolicNames) throws IOException {
        this._updateProperties(blacklistBundleSymbolicNames -> {
            if (blacklistBundleSymbolicNames == null) {
                return bundleSymbolicNames;
            }
            Set blacklistBundleSymbolicNamesSet = SetUtil.fromArray((Object[])blacklistBundleSymbolicNames);
            Collections.addAll(blacklistBundleSymbolicNamesSet, bundleSymbolicNames);
            return blacklistBundleSymbolicNamesSet.toArray(new String[0]);
        });
    }

    public Collection<String> getBlacklistBundleSymbolicNames() {
        return this._bundleBlacklist.getBlacklistBundleSymbolicNames();
    }

    public void removeFromBlacklistAndInstall(String ... bundleSymbolicNames) throws IOException {
        this._updateProperties(blacklistBundleSymbolicNames -> {
            if (blacklistBundleSymbolicNames == null) {
                return null;
            }
            Set blacklistBundleSymbolicNamesSet = SetUtil.fromArray((Object[])blacklistBundleSymbolicNames);
            for (String bundleSymbolicName : bundleSymbolicNames) {
                blacklistBundleSymbolicNamesSet.remove(bundleSymbolicName);
            }
            return blacklistBundleSymbolicNamesSet.toArray(new String[0]);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateConfiguration(Configuration configuration, Dictionary<String, Object> properties) throws IOException {
        Bundle bundle = FrameworkUtil.getBundle(BundleBlacklistManager.class);
        final BundleContext bundleContext = bundle.getBundleContext();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        ServiceListener serviceListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent serviceEvent) {
                if (serviceEvent.getType() != 2) {
                    return;
                }
                ServiceReference serviceReference = serviceEvent.getServiceReference();
                Object service = bundleContext.getService(serviceReference);
                if (BundleBlacklistManagerImpl.this._bundleBlacklist == service) {
                    countDownLatch.countDown();
                }
                bundleContext.ungetService(serviceReference);
            }
        };
        bundleContext.addServiceListener(serviceListener);
        try {
            configuration.update(properties);
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)interruptedException);
            }
        }
        finally {
            bundleContext.removeServiceListener(serviceListener);
        }
    }

    private void _updateProperties(Function<String[], String[]> updateFunction) throws IOException {
        Configuration configuration = this._configurationAdmin.getConfiguration(BundleBlacklistConfiguration.class.getName(), "?");
        Dictionary properties = configuration.getProperties();
        String[] blacklistBundleSymbolicNames = null;
        if (properties == null) {
            properties = new HashMapDictionary();
        } else {
            Object value = properties.get("blacklistBundleSymbolicNames");
            blacklistBundleSymbolicNames = value instanceof String ? StringUtil.split((String)((String)value)) : (String[])properties.get("blacklistBundleSymbolicNames");
        }
        blacklistBundleSymbolicNames = updateFunction.apply(blacklistBundleSymbolicNames);
        if (blacklistBundleSymbolicNames == null) {
            return;
        }
        if (blacklistBundleSymbolicNames.length == 0) {
            properties.remove("blacklistBundleSymbolicNames");
        } else {
            properties.put("blacklistBundleSymbolicNames", blacklistBundleSymbolicNames);
        }
        this._updateConfiguration(configuration, properties);
    }
}

