/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bundle.blacklist.internal;

import com.liferay.osgi.util.BundleUtil;
import com.liferay.osgi.util.bundle.BundleStartLevelUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.bundle.blacklist.internal.UninstalledBundleData;
import com.liferay.portal.lpkg.deployer.LPKGDeployer;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class SelfMonitorBundleListener
implements BundleListener {
    private final Bundle _bundle;
    private final LPKGDeployer _lpkgDeployer;
    private final BundleContext _systemBundleContext;
    private final Map<String, UninstalledBundleData> _uninstalledBundles;

    public SelfMonitorBundleListener(Bundle bundle, BundleContext systemBundleContext, LPKGDeployer lpkgDeployer, Map<String, UninstalledBundleData> uninstalledBundles) {
        this._bundle = bundle;
        this._systemBundleContext = systemBundleContext;
        this._lpkgDeployer = lpkgDeployer;
        this._uninstalledBundles = uninstalledBundles;
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle = bundleEvent.getBundle();
        if (!bundle.equals(this._bundle)) {
            return;
        }
        if (bundleEvent.getType() == 2) {
            this._systemBundleContext.removeBundleListener((BundleListener)this);
            return;
        }
        if (bundleEvent.getType() != 16) {
            return;
        }
        for (UninstalledBundleData uninstalledBundleData : this._uninstalledBundles.values()) {
            try {
                BundleUtil.installBundle((BundleContext)this._systemBundleContext, (LPKGDeployer)this._lpkgDeployer, (String)uninstalledBundleData.getLocation(), (int)uninstalledBundleData.getStartLevel());
            }
            catch (Throwable throwable) {
                ReflectionUtil.throwException((Throwable)throwable);
            }
        }
        this._systemBundleContext.removeBundleListener((BundleListener)this);
    }

    static {
        ClassLoader classLoader = SelfMonitorBundleListener.class.getClassLoader();
        try {
            classLoader.loadClass(BundleStartLevelUtil.class.getName());
            classLoader.loadClass(BundleUtil.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException);
        }
    }
}

