/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.cache.AggregatedPortalCacheManagerListener;
import com.liferay.portal.cache.LowLevelCache;
import com.liferay.portal.cache.MVCCPortalCache;
import com.liferay.portal.cache.PortalCacheListenerFactory;
import com.liferay.portal.cache.PortalCacheManagerListenerFactory;
import com.liferay.portal.cache.TransactionalPortalCache;
import com.liferay.portal.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class BasePortalCacheManager<K extends Serializable, V>
implements PortalCacheManager<K, V> {
    protected final AggregatedPortalCacheManagerListener aggregatedPortalCacheManagerListener = new AggregatedPortalCacheManagerListener();
    protected PortalCacheListenerFactory portalCacheListenerFactory;
    protected PortalCacheManagerListenerFactory<PortalCacheManager<K, V>> portalCacheManagerListenerFactory;
    private boolean _clusterAware;
    private PortalCacheManagerConfiguration _portalCacheManagerConfiguration;
    private String _portalCacheManagerName;
    private final ConcurrentMap<String, PortalCache<K, V>> _portalCaches = new ConcurrentHashMap<String, PortalCache<K, V>>();
    private boolean _transactionalPortalCacheEnabled;
    private String[] _transactionalPortalCacheNames = StringPool.EMPTY_ARRAY;

    public void clearAll() throws PortalCacheException {
        this.doClearAll();
    }

    public void destroy() {
        this._portalCaches.clear();
        this.doDestroy();
    }

    public PortalCache<K, V> fetchPortalCache(String portalCacheName) {
        return (PortalCache)this._portalCaches.get(portalCacheName);
    }

    public PortalCache<K, V> getPortalCache(String portalCacheName) throws PortalCacheException {
        return this.getPortalCache(portalCacheName, false);
    }

    public PortalCache<K, V> getPortalCache(String portalCacheName, boolean mvcc) throws PortalCacheException {
        return this.getPortalCache(portalCacheName, mvcc, false);
    }

    public PortalCache<K, V> getPortalCache(String portalCacheName, boolean mvcc, boolean sharded) throws PortalCacheException {
        return this._portalCaches.compute(portalCacheName, (key, value) -> {
            if (value != null) {
                this._verifyMVCCPortalCache((PortalCache<K, V>)value, mvcc);
                this._verifyShardedPortalCache((PortalCache<K, V>)value, sharded);
                return value;
            }
            PortalCacheConfiguration portalCacheConfiguration = this._portalCacheManagerConfiguration.getPortalCacheConfiguration(portalCacheName);
            value = this.createPortalCache(portalCacheConfiguration, sharded);
            this._initPortalCacheListeners((PortalCache<K, V>)value, portalCacheConfiguration);
            if (mvcc) {
                value = new MVCCPortalCache((LowLevelCache)value);
            }
            if (this.isTransactionalPortalCacheEnabled() && this.isTransactionalPortalCache(portalCacheName)) {
                value = new TransactionalPortalCache<K, V>(value, mvcc);
            }
            return value;
        });
    }

    public Set<PortalCacheManagerListener> getPortalCacheManagerListeners() {
        return this.aggregatedPortalCacheManagerListener.getPortalCacheManagerListeners();
    }

    public String getPortalCacheManagerName() {
        return this._portalCacheManagerName;
    }

    public String[] getTransactionalPortalCacheNames() {
        return this._transactionalPortalCacheNames;
    }

    public boolean isClusterAware() {
        return this._clusterAware;
    }

    public boolean isTransactionalPortalCacheEnabled() {
        return this._transactionalPortalCacheEnabled;
    }

    public boolean registerPortalCacheManagerListener(PortalCacheManagerListener portalCacheManagerListener) {
        return this.aggregatedPortalCacheManagerListener.addPortalCacheListener(portalCacheManagerListener);
    }

    public void removePortalCache(String portalCacheName) {
        this.doRemovePortalCache((PortalCache)this._portalCaches.remove(portalCacheName));
    }

    public void removePortalCaches(long companyId) {
        HashSet<PortalCache<K, V>> shardedPortalCaches = new HashSet<PortalCache<K, V>>();
        for (PortalCache portalCache : this._portalCaches.values()) {
            if (!portalCache.isSharded()) continue;
            shardedPortalCaches.add(portalCache);
        }
        if (shardedPortalCaches.isEmpty()) {
            return;
        }
        this.doRemoveShardedPortalCache(companyId, shardedPortalCaches);
    }

    public void setClusterAware(boolean clusterAware) {
        this._clusterAware = clusterAware;
    }

    public void setPortalCacheManagerName(String portalCacheManagerName) {
        this._portalCacheManagerName = portalCacheManagerName;
    }

    public void setTransactionalPortalCacheEnabled(boolean transactionalPortalCacheEnabled) {
        this._transactionalPortalCacheEnabled = transactionalPortalCacheEnabled;
    }

    public void setTransactionalPortalCacheNames(String[] transactionalPortalCacheNames) {
        this._transactionalPortalCacheNames = transactionalPortalCacheNames;
    }

    public boolean unregisterPortalCacheManagerListener(PortalCacheManagerListener portalCacheManagerListener) {
        return this.aggregatedPortalCacheManagerListener.removePortalCacheListener(portalCacheManagerListener);
    }

    public void unregisterPortalCacheManagerListeners() {
        this.aggregatedPortalCacheManagerListener.clearAll();
    }

    protected abstract PortalCache<K, V> createPortalCache(PortalCacheConfiguration var1, boolean var2);

    protected abstract void doClearAll();

    protected abstract void doDestroy();

    protected abstract void doRemovePortalCache(PortalCache<K, V> var1);

    protected abstract void doRemoveShardedPortalCache(long var1, Set<PortalCache<K, V>> var3);

    protected abstract PortalCacheManagerConfiguration getPortalCacheManagerConfiguration();

    protected void initialize() {
        if (this._portalCacheManagerConfiguration != null) {
            return;
        }
        if (Validator.isNull((String)this._portalCacheManagerName)) {
            throw new IllegalArgumentException("Portal cache manager name is not specified");
        }
        this.initPortalCacheManager();
        this._portalCacheManagerConfiguration = this.getPortalCacheManagerConfiguration();
        for (Properties properties : this._portalCacheManagerConfiguration.getPortalCacheManagerListenerPropertiesSet()) {
            PortalCacheManagerListener portalCacheManagerListener = this.portalCacheManagerListenerFactory.create(this, properties);
            if (portalCacheManagerListener == null) continue;
            this.registerPortalCacheManagerListener(portalCacheManagerListener);
        }
    }

    protected abstract void initPortalCacheManager();

    protected boolean isTransactionalPortalCache(String portalCacheName) {
        for (String namePattern : this.getTransactionalPortalCacheNames()) {
            if (!StringUtil.wildcardMatches((String)portalCacheName, (String)namePattern, (char)'?', (char)'*', (char)'%', (boolean)true)) continue;
            return true;
        }
        return false;
    }

    protected void reconfigPortalCache(PortalCacheManagerConfiguration portalCacheManagerConfiguration) {
        for (String portalCacheName : portalCacheManagerConfiguration.getPortalCacheNames()) {
            PortalCacheConfiguration portalCacheConfiguration = portalCacheManagerConfiguration.getPortalCacheConfiguration(portalCacheName);
            this._portalCacheManagerConfiguration.putPortalCacheConfiguration(portalCacheName, portalCacheConfiguration);
            PortalCache portalCache = (PortalCache)this._portalCaches.get(portalCacheName);
            if (portalCache == null) continue;
            this.removeConfigurableEhcachePortalCacheListeners(portalCache);
            this._initPortalCacheListeners(portalCache, portalCacheConfiguration);
        }
    }

    protected abstract void removeConfigurableEhcachePortalCacheListeners(PortalCache<K, V> var1);

    private void _initPortalCacheListeners(PortalCache<K, V> portalCache, PortalCacheConfiguration portalCacheConfiguration) {
        if (portalCacheConfiguration == null) {
            return;
        }
        for (Properties properties : portalCacheConfiguration.getPortalCacheListenerPropertiesSet()) {
            PortalCacheListener portalCacheListener = this.portalCacheListenerFactory.create(properties);
            if (portalCacheListener == null) continue;
            PortalCacheListenerScope portalCacheListenerScope = (PortalCacheListenerScope)properties.remove("PORTAL_CACHE_LISTENER_PROPERTIES_KEY_SCOPE");
            if (portalCacheListenerScope == null) {
                portalCacheListenerScope = PortalCacheListenerScope.ALL;
            }
            portalCache.registerPortalCacheListener(portalCacheListener, portalCacheListenerScope);
        }
    }

    private void _verifyMVCCPortalCache(PortalCache<K, V> portalCache, boolean mvcc) {
        if (mvcc == portalCache.isMVCC()) {
            return;
        }
        StringBundler sb = new StringBundler(9);
        sb.append("Unable to get portal cache ");
        sb.append(portalCache.getPortalCacheName());
        sb.append(" from portal cache manager ");
        sb.append(this._portalCacheManagerName);
        sb.append(" as a ");
        if (mvcc) {
            sb.append("MVCC ");
        } else {
            sb.append("non-MVCC ");
        }
        sb.append("portal cache, cause a ");
        if (portalCache.isMVCC()) {
            sb.append("MVCC ");
        } else {
            sb.append("non-MVCC ");
        }
        sb.append("portal cache with same name exists.");
        throw new IllegalStateException(sb.toString());
    }

    private void _verifyShardedPortalCache(PortalCache<K, V> portalCache, boolean sharded) {
        if (sharded == portalCache.isSharded()) {
            return;
        }
        StringBundler sb = new StringBundler(9);
        sb.append("Unable to get portal cache ");
        sb.append(portalCache.getPortalCacheName());
        sb.append(" from portal cache manager ");
        sb.append(this._portalCacheManagerName);
        sb.append(" as a ");
        if (sharded) {
            sb.append("sharded ");
        } else {
            sb.append("nonsharded ");
        }
        sb.append("portal cache, cause a ");
        if (portalCache.isSharded()) {
            sb.append("sharded ");
        } else {
            sb.append("nonsharded ");
        }
        sb.append("portal cache with same name exists.");
        throw new IllegalStateException(sb.toString());
    }
}

