/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.portal.cache.LowLevelCache;
import com.liferay.portal.cache.PortalCacheWrapper;
import com.liferay.portal.kernel.model.MVCCModel;
import java.io.Serializable;

public class MVCCPortalCache<K extends Serializable, V extends MVCCModel>
extends PortalCacheWrapper<K, V> {
    private final LowLevelCache<K, V> _lowLevelCache;

    public MVCCPortalCache(LowLevelCache<K, V> lowLevelCache) {
        super(lowLevelCache);
        this._lowLevelCache = lowLevelCache;
    }

    @Override
    public boolean isMVCC() {
        return true;
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, 0);
    }

    @Override
    public void put(K key, V value, int timeToLive) {
        MVCCModel oldValue;
        do {
            if ((oldValue = (MVCCModel)this._lowLevelCache.get((Serializable)key)) == null && (oldValue = (MVCCModel)this._lowLevelCache.putIfAbsent(key, value, timeToLive)) == null) {
                return;
            }
            if (value.getMvccVersion() >= oldValue.getMvccVersion()) continue;
            return;
        } while (!this._lowLevelCache.replace(key, oldValue, (MVCCModel)value, timeToLive));
    }
}

