/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.configuration;

import com.liferay.portal.cache.configuration.PortalCacheConfiguration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PortalCacheManagerConfiguration {
    private final PortalCacheConfiguration _defaultPortalCacheConfiguration;
    private final Map<String, PortalCacheConfiguration> _portalCacheConfigurations = new ConcurrentHashMap<String, PortalCacheConfiguration>();
    private final Set<Properties> _portalCacheManagerListenerPropertiesSet;

    public PortalCacheManagerConfiguration(Set<Properties> portalCacheManagerListenerPropertiesSet, PortalCacheConfiguration defaultPortalCacheConfiguration, Set<PortalCacheConfiguration> portalCacheConfigurations) {
        this._portalCacheManagerListenerPropertiesSet = portalCacheManagerListenerPropertiesSet == null ? Collections.emptySet() : new HashSet<Properties>(portalCacheManagerListenerPropertiesSet);
        this._defaultPortalCacheConfiguration = defaultPortalCacheConfiguration;
        if (portalCacheConfigurations != null) {
            for (PortalCacheConfiguration portalCacheConfiguration : portalCacheConfigurations) {
                this._portalCacheConfigurations.put(portalCacheConfiguration.getPortalCacheName(), portalCacheConfiguration);
            }
        }
    }

    public PortalCacheConfiguration getDefaultPortalCacheConfiguration() {
        return this._defaultPortalCacheConfiguration;
    }

    public PortalCacheConfiguration getPortalCacheConfiguration(String portalCacheName) {
        return this._portalCacheConfigurations.get(portalCacheName);
    }

    public Set<Properties> getPortalCacheManagerListenerPropertiesSet() {
        return Collections.unmodifiableSet(this._portalCacheManagerListenerPropertiesSet);
    }

    public Set<String> getPortalCacheNames() {
        return Collections.unmodifiableSet(this._portalCacheConfigurations.keySet());
    }

    public PortalCacheConfiguration putPortalCacheConfiguration(String portalCacheName, PortalCacheConfiguration portalCacheConfiguration) {
        return this._portalCacheConfigurations.put(portalCacheName, portalCacheConfiguration);
    }
}

