/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal;

import com.liferay.portal.cache.BasePortalCacheManager;
import com.liferay.portal.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCache;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCacheConfiguration;
import com.liferay.portal.cache.ehcache.internal.EhcacheUnwrapUtil;
import com.liferay.portal.cache.ehcache.internal.SerializableEhcachePortalCache;
import com.liferay.portal.cache.ehcache.internal.configurator.BaseEhcachePortalCacheManagerConfigurator;
import com.liferay.portal.cache.ehcache.internal.event.ConfigurableEhcachePortalCacheListener;
import com.liferay.portal.cache.ehcache.internal.event.PortalCacheManagerEventListener;
import com.liferay.portal.cache.ehcache.internal.management.ManagementService;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import javax.management.MBeanServer;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class EhcachePortalCacheManager<K extends Serializable, V>
extends BasePortalCacheManager<K, V> {
    protected BaseEhcachePortalCacheManagerConfigurator baseEhcachePortalCacheManagerConfigurator;
    protected BundleContext bundleContext;
    protected volatile Props props;
    private static final Log _log = LogFactoryUtil.getLog(EhcachePortalCacheManager.class);
    private CacheManager _cacheManager;
    private String _configFile;
    private ServiceTracker<?, ?> _configuratorSettingsServiceTracker;
    private String _defaultConfigFile;
    private ServiceTracker<MBeanServer, ManagementService> _mBeanServerServiceTracker;
    private PortalCacheManagerConfiguration _portalCacheManagerConfiguration;
    private boolean _usingDefault;

    public CacheManager getEhcacheManager() {
        return this._cacheManager;
    }

    @Deprecated
    public void reconfigurePortalCaches(URL configurationURL) {
        this.reconfigurePortalCaches(configurationURL, null);
    }

    public void reconfigurePortalCaches(URL configurationURL, ClassLoader classLoader) {
        ObjectValuePair<Configuration, PortalCacheManagerConfiguration> configurationObjectValuePair = this.baseEhcachePortalCacheManagerConfigurator.getConfigurationObjectValuePair(this.getPortalCacheManagerName(), configurationURL, classLoader, this._usingDefault);
        this.reconfigEhcache((Configuration)configurationObjectValuePair.getKey());
        this.reconfigPortalCache((PortalCacheManagerConfiguration)configurationObjectValuePair.getValue());
    }

    public void setConfigFile(String configFile) {
        this._configFile = configFile;
    }

    public void setDefaultConfigFile(String defaultConfigFile) {
        this._defaultConfigFile = defaultConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortalCache<K, V> createPortalCache(PortalCacheConfiguration portalCacheConfiguration) {
        String portalCacheName = portalCacheConfiguration.getPortalCacheName();
        CacheManager cacheManager = this._cacheManager;
        synchronized (cacheManager) {
            if (!this._cacheManager.cacheExists(portalCacheName)) {
                this._cacheManager.addCache(portalCacheName);
            }
        }
        Cache cache = this._cacheManager.getCache(portalCacheName);
        EhcachePortalCacheConfiguration ehcachePortalCacheConfiguration = (EhcachePortalCacheConfiguration)portalCacheConfiguration;
        if (ehcachePortalCacheConfiguration.isRequireSerialization()) {
            return new SerializableEhcachePortalCache(this, (Ehcache)cache);
        }
        return new EhcachePortalCache(this, (Ehcache)cache);
    }

    protected void doClearAll() {
        for (String cacheName : this._cacheManager.getCacheNames()) {
            Cache cache = this._cacheManager.getCache(cacheName);
            if (cache == null) continue;
            cache.removeAll();
        }
    }

    protected void doDestroy() {
        this._cacheManager.shutdown();
        if (this._configuratorSettingsServiceTracker != null) {
            this._configuratorSettingsServiceTracker.close();
            this._configuratorSettingsServiceTracker = null;
        }
        if (this._mBeanServerServiceTracker != null) {
            this._mBeanServerServiceTracker.close();
        }
    }

    protected void doRemovePortalCache(String portalCacheName) {
        this._cacheManager.removeCache(portalCacheName);
    }

    protected PortalCacheManagerConfiguration getPortalCacheManagerConfiguration() {
        return this._portalCacheManagerConfiguration;
    }

    protected void initPortalCacheManager() {
        ClassLoader classLoader;
        URL configFileURL;
        this.setTransactionalPortalCacheEnabled(GetterUtil.getBoolean((String)this.props.get("transactional.cache.enable")));
        this.setTransactionalPortalCacheNames(GetterUtil.getStringValues((String[])this.props.getArray("transactional.cache.names")));
        if (Validator.isNull((String)this._configFile)) {
            this._configFile = this._defaultConfigFile;
        }
        if ((configFileURL = (classLoader = BaseEhcachePortalCacheManagerConfigurator.class.getClassLoader()).getResource(this._configFile)) == null) {
            classLoader = PortalClassLoaderUtil.getClassLoader();
            configFileURL = classLoader.getResource(this._configFile);
        }
        this._usingDefault = this._configFile.equals(this._defaultConfigFile);
        ObjectValuePair<Configuration, PortalCacheManagerConfiguration> configurationObjectValuePair = this.baseEhcachePortalCacheManagerConfigurator.getConfigurationObjectValuePair(this.getPortalCacheManagerName(), configFileURL, classLoader, this._usingDefault);
        this._cacheManager = new CacheManager((Configuration)configurationObjectValuePair.getKey());
        this._portalCacheManagerConfiguration = (PortalCacheManagerConfiguration)configurationObjectValuePair.getValue();
        CacheManagerEventListenerRegistry cacheManagerEventListenerRegistry = this._cacheManager.getCacheManagerEventListenerRegistry();
        cacheManagerEventListenerRegistry.registerListener((CacheManagerEventListener)new PortalCacheManagerEventListener((PortalCacheManagerListener)this.aggregatedPortalCacheManagerListener));
        if (!GetterUtil.getBoolean((String)this.props.get("ehcache.portal.cache.manager.jmx.enabled"))) {
            return;
        }
        this._mBeanServerServiceTracker = new ServiceTracker<MBeanServer, ManagementService>(this.bundleContext, MBeanServer.class, null){

            public ManagementService addingService(ServiceReference<MBeanServer> serviceReference) {
                MBeanServer mBeanServer = (MBeanServer)EhcachePortalCacheManager.this.bundleContext.getService(serviceReference);
                ManagementService managementService = new ManagementService(EhcachePortalCacheManager.this._cacheManager, mBeanServer);
                managementService.init();
                return managementService;
            }

            public void removedService(ServiceReference<MBeanServer> serviceReference, ManagementService managementService) {
                managementService.dispose();
                EhcachePortalCacheManager.this.bundleContext.ungetService(serviceReference);
            }
        };
        this._mBeanServerServiceTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconfigEhcache(Configuration configuration) {
        Map cacheConfigurations = configuration.getCacheConfigurations();
        for (CacheConfiguration cacheConfiguration : cacheConfigurations.values()) {
            String portalCacheName = cacheConfiguration.getName();
            CacheManager cacheManager = this._cacheManager;
            synchronized (cacheManager) {
                if (this._cacheManager.cacheExists(portalCacheName)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Overriding existing cache " + portalCacheName));
                    }
                    this._cacheManager.removeCache(portalCacheName);
                }
                Cache ehcache = new Cache(cacheConfiguration);
                this._cacheManager.addCache((Ehcache)ehcache);
                PortalCache portalCache = (PortalCache)this.portalCaches.get(portalCacheName);
                if (portalCache != null) {
                    EhcachePortalCache ehcachePortalCache = (EhcachePortalCache)EhcacheUnwrapUtil.getWrappedPortalCache(portalCache);
                    if (ehcachePortalCache != null) {
                        ehcachePortalCache.reconfigEhcache((Ehcache)ehcache);
                    } else {
                        _log.error((Object)("Unable to reconfigure cache with name " + portalCacheName));
                    }
                }
            }
        }
    }

    protected void removeConfigurableEhcachePortalCacheListeners(PortalCache<K, V> portalCache) {
        EhcachePortalCache ehcachePortalCache = (EhcachePortalCache)EhcacheUnwrapUtil.getWrappedPortalCache(portalCache);
        Map portalCacheListeners = ehcachePortalCache.getPortalCacheListeners();
        for (PortalCacheListener portalCacheListener : portalCacheListeners.keySet()) {
            if (!(portalCacheListener instanceof ConfigurableEhcachePortalCacheListener)) continue;
            portalCache.unregisterPortalCacheListener(portalCacheListener);
        }
    }
}

