/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal.event;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cache.AggregatedPortalCacheListener;
import com.liferay.portal.cache.ehcache.internal.SerializableEhcachePortalCache;
import com.liferay.portal.cache.io.SerializableObjectWrapper;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class PortalCacheCacheEventListener<K extends Serializable, V>
implements CacheEventListener {
    private final AggregatedPortalCacheListener<K, V> _aggregatedPortalCacheListener;
    private final Log _log;
    private final PortalCache<K, V> _portalCache;
    private final boolean _requireSerialization;

    public PortalCacheCacheEventListener(AggregatedPortalCacheListener<K, V> aggregatedPortalCacheListener, PortalCache<K, V> portalCache) {
        this._aggregatedPortalCacheListener = aggregatedPortalCacheListener;
        this._portalCache = portalCache;
        boolean requireSerialization = false;
        if (this._portalCache instanceof SerializableEhcachePortalCache) {
            requireSerialization = true;
        }
        this._requireSerialization = requireSerialization;
        this._log = LogFactoryUtil.getLog((String)(PortalCacheCacheEventListener.class.getName() + "." + portalCache.getPortalCacheName()));
    }

    public Object clone() {
        return new PortalCacheCacheEventListener<K, V>(this._aggregatedPortalCacheListener, this._portalCache);
    }

    public void dispose() {
        if (this._aggregatedPortalCacheListener.isEmpty()) {
            return;
        }
        this._aggregatedPortalCacheListener.dispose();
    }

    public PortalCacheListener<K, V> getCacheListener() {
        return this._aggregatedPortalCacheListener;
    }

    public PortalCache<K, V> getPortalCache() {
        return this._portalCache;
    }

    public void notifyElementEvicted(Ehcache ehcache, Element element) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)StringBundler.concat((Object[])new Object[]{"Evicted ", this.getKey(element), " from ", ehcache.getName()}));
        }
        if (this._aggregatedPortalCacheListener.isEmpty()) {
            return;
        }
        this._aggregatedPortalCacheListener.notifyEntryEvicted(this._portalCache, this.getKey(element), this.getValue(element), element.getTimeToLive());
    }

    public void notifyElementExpired(Ehcache ehcache, Element element) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)StringBundler.concat((Object[])new Object[]{"Expired ", this.getKey(element), " from ", ehcache.getName()}));
        }
        if (this._aggregatedPortalCacheListener.isEmpty()) {
            return;
        }
        this._aggregatedPortalCacheListener.notifyEntryExpired(this._portalCache, this.getKey(element), this.getValue(element), element.getTimeToLive());
    }

    public void notifyElementPut(Ehcache ehcache, Element element) throws CacheException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)StringBundler.concat((Object[])new Object[]{"Put ", this.getKey(element), " into ", ehcache.getName()}));
        }
        if (this._aggregatedPortalCacheListener.isEmpty()) {
            return;
        }
        this._aggregatedPortalCacheListener.notifyEntryPut(this._portalCache, this.getKey(element), this.getValue(element), element.getTimeToLive());
    }

    public void notifyElementRemoved(Ehcache ehcache, Element element) throws CacheException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)StringBundler.concat((Object[])new Object[]{"Removed ", this.getKey(element), " from ", ehcache.getName()}));
        }
        if (this._aggregatedPortalCacheListener.isEmpty()) {
            return;
        }
        this._aggregatedPortalCacheListener.notifyEntryRemoved(this._portalCache, this.getKey(element), this.getValue(element), element.getTimeToLive());
    }

    public void notifyElementUpdated(Ehcache ehcache, Element element) throws CacheException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)StringBundler.concat((Object[])new Object[]{"Updated ", this.getKey(element), " in ", ehcache.getName()}));
        }
        if (this._aggregatedPortalCacheListener.isEmpty()) {
            return;
        }
        this._aggregatedPortalCacheListener.notifyEntryUpdated(this._portalCache, this.getKey(element), this.getValue(element), element.getTimeToLive());
    }

    public void notifyRemoveAll(Ehcache ehcache) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Cleared " + ehcache.getName()));
        }
        if (this._aggregatedPortalCacheListener.isEmpty()) {
            return;
        }
        this._aggregatedPortalCacheListener.notifyRemoveAll(this._portalCache);
    }

    protected K getKey(Element element) {
        if (this._requireSerialization) {
            return (K)((Serializable)SerializableObjectWrapper.unwrap((Object)element.getObjectKey()));
        }
        return (K)((Serializable)element.getObjectKey());
    }

    protected V getValue(Element element) {
        if (this._requireSerialization) {
            return (V)SerializableObjectWrapper.unwrap((Object)element.getObjectValue());
        }
        return (V)element.getObjectValue();
    }
}

