/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.change.tracking.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.io.Deserializer;
import com.liferay.petra.io.Serializer;
import com.liferay.petra.io.unsync.UnsyncStringReader;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.change.tracking.registry.CTModelRegistration;
import com.liferay.portal.change.tracking.registry.CTModelRegistry;
import com.liferay.portal.change.tracking.sql.CTSQLTransformer;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.sql.CTSQLModeThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.AllComparisonExpression;
import net.sf.jsqlparser.expression.AnalyticExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.CollateExpression;
import net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.IntervalExpression;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.JsonExpression;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.MySQLGroupConcat;
import net.sf.jsqlparser.expression.NextValExpression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.NumericBind;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.ValueListExpression;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import net.sf.jsqlparser.expression.operators.relational.SimilarToExpression;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.parser.JSqlParser;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Block;
import net.sf.jsqlparser.statement.Commit;
import net.sf.jsqlparser.statement.DescribeStatement;
import net.sf.jsqlparser.statement.ExplainStatement;
import net.sf.jsqlparser.statement.SetStatement;
import net.sf.jsqlparser.statement.ShowColumnsStatement;
import net.sf.jsqlparser.statement.ShowStatement;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.UseStatement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.comment.Comment;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.view.AlterView;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.execute.Execute;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.replace.Replace;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.UnionOp;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.statement.values.ValuesStatement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class CTSQLTransformerImpl
implements CTSQLTransformer {
    private static final String _CT_TRANSFORMED_SQLS_PORTAL_CACHE_NAME = CTSQLTransformerImpl.class.getName() + "._ctTransformedSQLsPortalCache";
    private static final String _PRODUCTION_TRANSFORMED_SQLS_PORTAL_CACHE_NAME = CTSQLTransformerImpl.class.getName() + "._productionTransformedSQLsPortalCache";
    private static final String _TRANSFORMED_SQLS_FILE_NAME = "transformedSQLsFile";
    private static final Log _log = LogFactoryUtil.getLog(CTSQLTransformerImpl.class);
    private static final JSqlParser _jSqlParser = new CCJSqlParserManager();
    private BundleContext _bundleContext;
    private ServiceTrackerMap<Class<?>, CTService<?>> _ctServiceServiceTrackerMap;
    private PortalCache<String, String> _ctTransformedSQLsPortalCache;
    private PortalCache<String, String> _productionTransformedSQLsPortalCache;
    private ServiceTracker<?, ?> _releaseServiceTracker;

    public void activate(BundleContext bundleContext) throws Exception {
        this._bundleContext = bundleContext;
        this._ctTransformedSQLsPortalCache = PortalCacheHelperUtil.getPortalCache((String)"SINGLE_VM_PORTAL_CACHE_MANAGER", (String)_CT_TRANSFORMED_SQLS_PORTAL_CACHE_NAME);
        this._productionTransformedSQLsPortalCache = PortalCacheHelperUtil.getPortalCache((String)"SINGLE_VM_PORTAL_CACHE_MANAGER", (String)_PRODUCTION_TRANSFORMED_SQLS_PORTAL_CACHE_NAME);
        this._readTransformedSQLsFile();
        this._ctServiceServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, CTService.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.createFromFunction((BundleContext)this._bundleContext, CTService::getModelClass));
        this._releaseServiceTracker = new ServiceTracker(this._bundleContext, this._bundleContext.createFilter(StringBundler.concat((String[])new String[]{"(&(objectClass=", Release.class.getName(), ")(release.bundle.symbolic.name=", "com.liferay.change.tracking.service)", "(release.schema.version>=2.1.0))"})), null);
        this._releaseServiceTracker.open();
    }

    public void deactivate() {
        this._writeTransformedSQLsFile();
        this._ctServiceServiceTrackerMap.close();
        this._releaseServiceTracker.close();
    }

    public String transform(String sql) {
        if (CTSQLModeThreadLocal.getCTSQLMode() == CTSQLModeThreadLocal.CTSQLMode.CT_ALL) {
            return sql;
        }
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        String transformedSQL = null;
        String key = this._getTransformedSQLKey(ctCollectionId, sql);
        transformedSQL = ctCollectionId == 0L ? (String)this._productionTransformedSQLsPortalCache.get((Serializable)((Object)key)) : (String)this._ctTransformedSQLsPortalCache.get((Serializable)((Object)key));
        if (transformedSQL != null) {
            return transformedSQL;
        }
        boolean foundTable = false;
        for (String tableName : CTModelRegistry.getTableNames()) {
            if (!sql.contains(tableName)) continue;
            foundTable = true;
            break;
        }
        if (!foundTable) {
            this._productionTransformedSQLsPortalCache.put((Serializable)((Object)key), (Object)sql);
            return sql;
        }
        try {
            Statement statement = _jSqlParser.parse((Reader)new UnsyncStringReader(this._escape(sql)));
            transformedSQL = sql;
            if (statement instanceof Select) {
                statement.accept((StatementVisitor)new SelectStatementVisitor(ctCollectionId, CTSQLModeThreadLocal.getCTSQLMode()));
                transformedSQL = this._unescape(statement.toString());
            } else if (statement instanceof Delete || statement instanceof Update) {
                statement.accept((StatementVisitor)new DeleteAndUpdateStatementVisitor(ctCollectionId));
                transformedSQL = this._unescape(statement.toString());
            }
            if (ctCollectionId == 0L) {
                this._productionTransformedSQLsPortalCache.put((Serializable)((Object)key), (Object)transformedSQL);
            } else {
                this._ctTransformedSQLsPortalCache.put((Serializable)((Object)key), (Object)transformedSQL);
            }
            return transformedSQL;
        }
        catch (JSQLParserException jsqlParserException) {
            throw new RuntimeException("Unable to parse SQL for " + sql, jsqlParserException);
        }
    }

    private String _escape(String sql) {
        return StringUtil.replace((String)sql, (String)"LIKE ? ESCAPE '\\'", (String)"LIKE '[$LFR_LIKE_ESCAPE_STRING$]'");
    }

    private String _getTransformedSQLKey(long ctCollectionId, String sql) {
        if (ctCollectionId == 0L) {
            return sql;
        }
        return StringBundler.concat((Object[])new Object[]{ctCollectionId, "#", sql});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _readTransformedSQLsFile() {
        File transformedSQLsFile = this._bundleContext.getDataFile(_TRANSFORMED_SQLS_FILE_NAME);
        if (!transformedSQLsFile.exists()) {
            return;
        }
        try {
            Deserializer deserializer = new Deserializer(ByteBuffer.wrap(FileUtil.getBytes((File)transformedSQLsFile)));
            Bundle bundle = this._bundleContext.getBundle();
            if (deserializer.readLong() != bundle.getLastModified()) {
                return;
            }
            int size = deserializer.readInt();
            for (int i = 0; i < size; ++i) {
                this._productionTransformedSQLsPortalCache.put((Serializable)((Object)deserializer.readString()), (Object)deserializer.readString());
            }
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to load transformedSQLsFile", (Throwable)ioException);
        }
        finally {
            transformedSQLsFile.delete();
        }
    }

    private String _unescape(String sql) {
        return StringUtil.replace((String)sql, (String)"LIKE '[$LFR_LIKE_ESCAPE_STRING$]'", (String)"LIKE ? ESCAPE '\\'");
    }

    private void _writeTransformedSQLsFile() {
        List transformedSQLKeys = this._productionTransformedSQLsPortalCache.getKeys();
        if (transformedSQLKeys.isEmpty()) {
            return;
        }
        Bundle bundle = this._bundleContext.getBundle();
        Serializer serializer = new Serializer();
        serializer.writeLong(bundle.getLastModified());
        serializer.writeInt(transformedSQLKeys.size());
        for (String key : transformedSQLKeys) {
            serializer.writeString(key);
            serializer.writeString((String)this._productionTransformedSQLsPortalCache.get((Serializable)((Object)key)));
        }
        File transformedSQLsFile = this._bundleContext.getDataFile(_TRANSFORMED_SQLS_FILE_NAME);
        try (FileOutputStream outputStream = new FileOutputStream(transformedSQLsFile);){
            serializer.writeTo((OutputStream)outputStream);
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to write transformedSQLsFile", (Throwable)ioException);
            transformedSQLsFile.delete();
        }
    }

    private class SelectStatementVisitor
    extends BaseStatementVisitor {
        private final CTSQLModeThreadLocal.CTSQLMode _ctSQLMode;

        @Override
        protected Expression getWhereExpression(Table table, CTModelRegistration ctModelRegistration) {
            Expression expression = this._getWhereExpression(table, ctModelRegistration);
            if (this.allowNull) {
                IsNullExpression isNullExpression = new IsNullExpression();
                isNullExpression.setLeftExpression((Expression)new Column(table, "ctCollectionId"));
                expression = new Parenthesis((Expression)new OrExpression(expression, (Expression)isNullExpression));
            }
            return expression;
        }

        @Override
        protected SelectStatementVisitor newInstance() {
            return new SelectStatementVisitor(this.ctCollectionId, this._ctSQLMode);
        }

        private SelectStatementVisitor(long ctCollectionId, CTSQLModeThreadLocal.CTSQLMode ctSQLMode) {
            super(ctCollectionId);
            this._ctSQLMode = ctSQLMode;
        }

        private Expression _getWhereExpression(Table table, CTModelRegistration ctModelRegistration) {
            if (CTSQLModeThreadLocal.CTSQLMode.CT_ONLY == this._ctSQLMode) {
                return SelectStatementVisitor.equalsTo((Expression)new Column(table, "ctCollectionId"), (Expression)new LongValue(this.ctCollectionId));
            }
            if (this.ctCollectionId == 0L || CTSQLTransformerImpl.this._releaseServiceTracker.getService() == null) {
                return SelectStatementVisitor.equalsTo((Expression)new Column(table, "ctCollectionId"), (Expression)new LongValue("0"));
            }
            Table ctEntryTable = new Table("CTEntry");
            PlainSelect ctEntryPlainSelect = new PlainSelect();
            ctEntryPlainSelect.setSelectItems(Collections.singletonList(new SelectExpressionItem((Expression)new Column(ctEntryTable, "modelClassPK"))));
            ctEntryPlainSelect.setFromItem((FromItem)ctEntryTable);
            ctEntryPlainSelect.setWhere((Expression)new AndExpression((Expression)SelectStatementVisitor.equalsTo((Expression)new Column(ctEntryTable, "ctCollectionId"), (Expression)new LongValue(this.ctCollectionId)), (Expression)SelectStatementVisitor.equalsTo((Expression)new Column(ctEntryTable, "modelClassNameId"), (Expression)new LongValue(ClassNameLocalServiceUtil.getClassNameId((Class)ctModelRegistration.getModelClass())))));
            PlainSelect selectBody = ctEntryPlainSelect;
            CTService ctService = (CTService)CTSQLTransformerImpl.this._ctServiceServiceTrackerMap.getService((Object)ctModelRegistration.getModelClass());
            List uniqueIndexColumnNames = Collections.emptyList();
            if (ctService == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No change tracking service found for model class " + ctModelRegistration.getModelClass()));
                }
            } else {
                CTPersistence ctPersistence = ctService.getCTPersistence();
                uniqueIndexColumnNames = ctPersistence.getUniqueIndexColumnNames();
            }
            String primaryKeyName = ctModelRegistration.getPrimaryColumnName();
            if (!uniqueIndexColumnNames.isEmpty()) {
                ArrayList<PlainSelect> selectBodies = new ArrayList<PlainSelect>(uniqueIndexColumnNames.size() + 1);
                selectBodies.add(selectBody);
                ArrayList<Boolean> brackets = new ArrayList<Boolean>(uniqueIndexColumnNames.size() + 1);
                brackets.add(Boolean.FALSE);
                ArrayList<UnionOp> setOperations = new ArrayList<UnionOp>(uniqueIndexColumnNames.size());
                for (String[] columnNames : uniqueIndexColumnNames) {
                    Table sourceTable = new Table(table.getName());
                    sourceTable.setAlias(new Alias("sourceTable", false));
                    PlainSelect plainSelect = new PlainSelect();
                    plainSelect.setSelectItems(Collections.singletonList(new SelectExpressionItem((Expression)new Column(sourceTable, primaryKeyName))));
                    plainSelect.setFromItem((FromItem)sourceTable);
                    Table targetTable = new Table(table.getName());
                    targetTable.setAlias(new Alias("targetTable", false));
                    NotEqualsTo notEqualsTo = new NotEqualsTo("!=");
                    notEqualsTo.setLeftExpression((Expression)new Column(sourceTable, primaryKeyName));
                    notEqualsTo.setRightExpression((Expression)new Column(targetTable, primaryKeyName));
                    AndExpression andExpression = new AndExpression((Expression)new AndExpression((Expression)notEqualsTo, (Expression)SelectStatementVisitor.equalsTo((Expression)new Column(sourceTable, "ctCollectionId"), (Expression)new LongValue("0"))), (Expression)SelectStatementVisitor.equalsTo((Expression)new Column(targetTable, "ctCollectionId"), (Expression)new LongValue(this.ctCollectionId)));
                    for (String columnName : columnNames) {
                        andExpression = new AndExpression((Expression)andExpression, (Expression)SelectStatementVisitor.equalsTo((Expression)new Column(sourceTable, columnName), (Expression)new Column(targetTable, columnName)));
                    }
                    Join join = new Join();
                    join.setInner(true);
                    join.setOnExpression((Expression)andExpression);
                    join.setRightItem((FromItem)targetTable);
                    plainSelect.setJoins(Collections.singletonList(join));
                    selectBodies.add(plainSelect);
                    brackets.add(Boolean.FALSE);
                    setOperations.add(new UnionOp());
                }
                SetOperationList setOperationList = new SetOperationList();
                setOperationList.setBracketsOpsAndSelects(brackets, selectBodies, setOperations);
                selectBody = setOperationList;
            }
            SubSelect subSelect = new SubSelect();
            subSelect.setSelectBody((SelectBody)selectBody);
            InExpression inExpression = new InExpression((Expression)new Column(table, primaryKeyName), (ItemsList)subSelect);
            inExpression.setNot(true);
            return new Parenthesis((Expression)new OrExpression((Expression)SelectStatementVisitor.equalsTo((Expression)new Column(table, "ctCollectionId"), (Expression)new LongValue(this.ctCollectionId)), (Expression)new AndExpression((Expression)SelectStatementVisitor.equalsTo((Expression)new Column(table, "ctCollectionId"), (Expression)new LongValue("0")), (Expression)inExpression)));
        }
    }

    private static class TableWrapper {
        private final Table _table;

        public boolean equals(Object object) {
            Alias alias2;
            TableWrapper tableWrapper = (TableWrapper)object;
            Table table = tableWrapper._table;
            if (table == this._table) {
                return true;
            }
            if (!Objects.equals(table.getName(), this._table.getName())) {
                return false;
            }
            Alias alias1 = table.getAlias();
            if (alias1 == (alias2 = this._table.getAlias())) {
                return true;
            }
            return alias1 != null && alias2 != null && Objects.equals(alias1.getName(), alias2.getName());
        }

        public int hashCode() {
            String name = this._table.getName();
            return name.hashCode();
        }

        public String toString() {
            return this._table.toString();
        }

        private TableWrapper(Table table) {
            this._table = table;
        }
    }

    private static class DeleteAndUpdateStatementVisitor
    extends BaseStatementVisitor {
        @Override
        protected Expression getWhereExpression(Table table, CTModelRegistration ctModelRegistration) {
            return DeleteAndUpdateStatementVisitor.equalsTo((Expression)new Column(table, "ctCollectionId"), (Expression)new LongValue(this.ctCollectionId));
        }

        @Override
        protected DeleteAndUpdateStatementVisitor newInstance() {
            return new DeleteAndUpdateStatementVisitor(this.ctCollectionId);
        }

        private DeleteAndUpdateStatementVisitor(long ctCollectionId) {
            super(ctCollectionId);
        }
    }

    private static abstract class BaseStatementVisitor
    implements ExpressionVisitor,
    FromItemVisitor,
    ItemsListVisitor,
    SelectItemVisitor,
    SelectVisitor,
    StatementVisitor {
        protected boolean allowNull;
        protected final long ctCollectionId;
        private final Set<TableWrapper> _tableWrappers = new LinkedHashSet<TableWrapper>();

        public void visit(Addition addition) {
            this._visit((BinaryExpression)addition);
        }

        public void visit(AllColumns allColumns) {
        }

        public void visit(AllComparisonExpression allComparisonExpression) {
            SubSelect select = allComparisonExpression.getSubSelect();
            SelectBody selectBody = select.getSelectBody();
            selectBody.accept((SelectVisitor)this);
        }

        public void visit(AllTableColumns allTableColumns) {
        }

        public void visit(Alter alter) {
        }

        public void visit(AlterView alterView) {
        }

        public void visit(AnalyticExpression analyticExpression) {
        }

        public void visit(AndExpression andExpression) {
            this._visit((BinaryExpression)andExpression);
        }

        public void visit(AnyComparisonExpression anyComparisonExpression) {
            SubSelect select = anyComparisonExpression.getSubSelect();
            SelectBody selectBody = select.getSelectBody();
            selectBody.accept((SelectVisitor)this);
        }

        public void visit(Between between) {
            Expression leftExpression = between.getLeftExpression();
            leftExpression.accept((ExpressionVisitor)this);
            Expression betweenExpressionStartExpression = between.getBetweenExpressionStart();
            betweenExpressionStartExpression.accept((ExpressionVisitor)this);
            Expression betweenExpressionEndExpression = between.getBetweenExpressionEnd();
            betweenExpressionEndExpression.accept((ExpressionVisitor)this);
        }

        public void visit(BitwiseAnd bitwiseAnd) {
            this._visit((BinaryExpression)bitwiseAnd);
        }

        public void visit(BitwiseLeftShift bitwiseLeftShift) {
            this._visit((BinaryExpression)bitwiseLeftShift);
        }

        public void visit(BitwiseOr bitwiseOr) {
            this._visit((BinaryExpression)bitwiseOr);
        }

        public void visit(BitwiseRightShift bitwiseRightShift) {
            this._visit((BinaryExpression)bitwiseRightShift);
        }

        public void visit(BitwiseXor bitwiseXor) {
            this._visit((BinaryExpression)bitwiseXor);
        }

        public void visit(Block block) {
            Statements statements = block.getStatements();
            if (statements != null) {
                statements.accept((StatementVisitor)this);
            }
        }

        public void visit(CaseExpression caseExpression) {
            Expression elseExpression;
            List whenClauses;
            Expression switchExpression = caseExpression.getSwitchExpression();
            if (switchExpression != null) {
                switchExpression.accept((ExpressionVisitor)this);
            }
            if ((whenClauses = caseExpression.getWhenClauses()) != null) {
                for (WhenClause whenClause : whenClauses) {
                    whenClause.accept((ExpressionVisitor)this);
                }
            }
            if ((elseExpression = caseExpression.getElseExpression()) != null) {
                elseExpression.accept((ExpressionVisitor)this);
            }
        }

        public void visit(CastExpression castExpression) {
            Expression leftExpression = castExpression.getLeftExpression();
            leftExpression.accept((ExpressionVisitor)this);
        }

        public void visit(CollateExpression collateExpression) {
        }

        public void visit(Column column) {
        }

        public void visit(Comment comment) {
        }

        public void visit(Commit commit) {
        }

        public void visit(Concat concat) {
            this._visit((BinaryExpression)concat);
        }

        public void visit(CreateIndex createIndex) {
        }

        public void visit(CreateTable createTable) {
        }

        public void visit(CreateView createView) {
        }

        public void visit(DateTimeLiteralExpression dateTimeLiteralExpression) {
        }

        public void visit(DateValue dateValue) {
        }

        public void visit(Delete delete) {
            this.visit(delete.getTable());
            List joins = delete.getJoins();
            if (joins != null) {
                for (Join join : joins) {
                    FromItem fromItem = join.getRightItem();
                    fromItem.accept((FromItemVisitor)this);
                }
            }
            delete.setWhere(this._visit(delete.getWhere()));
        }

        public void visit(DescribeStatement describeStatement) {
        }

        public void visit(Division division) {
            this._visit((BinaryExpression)division);
        }

        public void visit(DoubleValue doubleValue) {
        }

        public void visit(Drop drop) {
        }

        public void visit(EqualsTo equalsTo) {
            this._visit((BinaryExpression)equalsTo);
        }

        public void visit(Execute execute) {
        }

        public void visit(ExistsExpression existsExpression) {
            Expression rightExpression = existsExpression.getRightExpression();
            rightExpression.accept((ExpressionVisitor)this);
        }

        public void visit(ExplainStatement explainStatement) {
        }

        public void visit(ExpressionList expressionList) {
            for (Expression expression : expressionList.getExpressions()) {
                expression.accept((ExpressionVisitor)this);
            }
        }

        public void visit(ExtractExpression extractExpression) {
        }

        public void visit(Function function) {
            ExpressionList expressionList = function.getParameters();
            if (expressionList != null) {
                expressionList.accept((ItemsListVisitor)this);
            }
        }

        public void visit(GreaterThan greaterThan) {
            this._visit((BinaryExpression)greaterThan);
        }

        public void visit(GreaterThanEquals greaterThanEquals) {
            this._visit((BinaryExpression)greaterThanEquals);
        }

        public void visit(HexValue hexValue) {
        }

        public void visit(InExpression inExpression) {
            Expression leftExpression = inExpression.getLeftExpression();
            if (leftExpression != null) {
                leftExpression.accept((ExpressionVisitor)this);
            } else {
                ItemsList leftItemsList = inExpression.getLeftItemsList();
                if (leftItemsList == null) {
                    leftItemsList.accept((ItemsListVisitor)this);
                }
            }
            ItemsList rightItemsList = inExpression.getRightItemsList();
            rightItemsList.accept((ItemsListVisitor)this);
        }

        public void visit(Insert insert) {
        }

        public void visit(IntervalExpression intervalExpression) {
        }

        public void visit(IsNullExpression isNullExpression) {
        }

        public void visit(JdbcNamedParameter jdbcNamedParameter) {
        }

        public void visit(JdbcParameter jdbcParameter) {
        }

        public void visit(JsonExpression jsonExpression) {
        }

        public void visit(JsonOperator jsonOperator) {
        }

        public void visit(KeepExpression keepExpression) {
        }

        public void visit(LateralSubSelect lateralSubSelect) {
            SubSelect select = lateralSubSelect.getSubSelect();
            SelectBody selectBody = select.getSelectBody();
            selectBody.accept((SelectVisitor)this);
        }

        public void visit(LikeExpression likeExpression) {
            this._visit((BinaryExpression)likeExpression);
        }

        public void visit(LongValue longValue) {
        }

        public void visit(Matches matches) {
            this._visit((BinaryExpression)matches);
        }

        public void visit(Merge merge) {
        }

        public void visit(MinorThan minorThan) {
            this._visit((BinaryExpression)minorThan);
        }

        public void visit(MinorThanEquals minorThanEquals) {
            this._visit((BinaryExpression)minorThanEquals);
        }

        public void visit(Modulo modulo) {
            this._visit((BinaryExpression)modulo);
        }

        public void visit(MultiExpressionList multiExprList) {
            for (ExpressionList expressionList : multiExprList.getExprList()) {
                expressionList.accept((ItemsListVisitor)this);
            }
        }

        public void visit(Multiplication multiplication) {
            this._visit((BinaryExpression)multiplication);
        }

        public void visit(MySQLGroupConcat mySQLGroupConcat) {
        }

        public void visit(NamedExpressionList namedExpressionList) {
            for (Expression expression : namedExpressionList.getExpressions()) {
                expression.accept((ExpressionVisitor)this);
            }
        }

        public void visit(NextValExpression nextValExpression) {
        }

        public void visit(NotEqualsTo notEqualsTo) {
            this._visit((BinaryExpression)notEqualsTo);
        }

        public void visit(NotExpression notExpression) {
            Expression expression = notExpression.getExpression();
            expression.accept((ExpressionVisitor)this);
        }

        public void visit(NullValue nullValue) {
        }

        public void visit(NumericBind numericBind) {
        }

        public void visit(OracleHierarchicalExpression oracleHierarchicalExpression) {
            Expression startExpression = oracleHierarchicalExpression.getStartExpression();
            startExpression.accept((ExpressionVisitor)this);
            Expression connectExpression = oracleHierarchicalExpression.getConnectExpression();
            connectExpression.accept((ExpressionVisitor)this);
        }

        public void visit(OracleHint oracleHint) {
        }

        public void visit(OrExpression orExpression) {
            this._visit((BinaryExpression)orExpression);
        }

        public void visit(Parenthesis parenthesis) {
            Expression expression = parenthesis.getExpression();
            expression.accept((ExpressionVisitor)this);
        }

        public void visit(ParenthesisFromItem parenthesisFromItem) {
            FromItem fromItem = parenthesisFromItem.getFromItem();
            fromItem.accept((FromItemVisitor)this);
        }

        public void visit(PlainSelect plainSelect) {
            OracleHierarchicalExpression oracleHierarchicalExpression;
            List joins;
            FromItem fromItem;
            List selectItems = plainSelect.getSelectItems();
            if (selectItems != null) {
                for (SelectItem selectItem : selectItems) {
                    selectItem.accept((SelectItemVisitor)this);
                }
            }
            if ((fromItem = plainSelect.getFromItem()) != null) {
                fromItem.accept((FromItemVisitor)this);
            }
            if ((joins = plainSelect.getJoins()) != null) {
                for (Join join : joins) {
                    FromItem rightFromItem = join.getRightItem();
                    rightFromItem.accept((FromItemVisitor)this);
                    if (!join.isLeft() && !join.isRight() && !join.isFull() && !join.isOuter()) continue;
                    this.allowNull = true;
                    Expression onExpression = join.getOnExpression();
                    if (onExpression == null) continue;
                    join.setOnExpression(this._visit(onExpression));
                }
            }
            plainSelect.setWhere(this._visit(plainSelect.getWhere()));
            Expression havingExpression = plainSelect.getHaving();
            if (havingExpression != null) {
                havingExpression.accept((ExpressionVisitor)this);
            }
            if ((oracleHierarchicalExpression = plainSelect.getOracleHierarchical()) != null) {
                oracleHierarchicalExpression.accept((ExpressionVisitor)this);
            }
        }

        public void visit(RegExpMatchOperator regExpMatchOperator) {
            this._visit((BinaryExpression)regExpMatchOperator);
        }

        public void visit(RegExpMySQLOperator regExpMySQLOperator) {
            this._visit((BinaryExpression)regExpMySQLOperator);
        }

        public void visit(Replace replace) {
        }

        public void visit(RowConstructor rowConstructor) {
        }

        public void visit(Select select) {
            SelectBody selectBody = select.getSelectBody();
            selectBody.accept((SelectVisitor)this);
        }

        public void visit(SelectExpressionItem selectExpressionItem) {
            Expression expression = selectExpressionItem.getExpression();
            expression.accept((ExpressionVisitor)this);
        }

        public void visit(SetOperationList setOperationList) {
            for (SelectBody selectBody : setOperationList.getSelects()) {
                selectBody.accept((SelectVisitor)this.newInstance());
            }
        }

        public void visit(SetStatement setStatement) {
        }

        public void visit(ShowColumnsStatement showColumnsStatement) {
        }

        public void visit(ShowStatement showStatement) {
        }

        public void visit(SignedExpression signedExpression) {
            Expression expression = signedExpression.getExpression();
            expression.accept((ExpressionVisitor)this);
        }

        public void visit(SimilarToExpression similarToExpression) {
        }

        public void visit(Statements statements) {
        }

        public void visit(StringValue stringValue) {
        }

        public void visit(SubJoin join) {
            FromItem fromItem = join.getLeft();
            fromItem.accept((FromItemVisitor)this);
            for (Join currentJoin : join.getJoinList()) {
                FromItem currentFromItem = currentJoin.getRightItem();
                currentFromItem.accept((FromItemVisitor)this);
            }
        }

        public void visit(SubSelect select) {
            List withItems = select.getWithItemsList();
            if (withItems != null) {
                for (WithItem withItem : withItems) {
                    withItem.accept((SelectVisitor)this);
                }
            }
            SelectBody selectBody = select.getSelectBody();
            selectBody.accept((SelectVisitor)this.newInstance());
        }

        public void visit(Subtraction subtraction) {
            this._visit((BinaryExpression)subtraction);
        }

        public void visit(Table table) {
            this._tableWrappers.add(new TableWrapper(table));
        }

        public void visit(TableFunction tableFunction) {
        }

        public void visit(TimeKeyExpression timeKeyExpression) {
        }

        public void visit(TimestampValue timestampValue) {
        }

        public void visit(TimeValue timeValue) {
        }

        public void visit(Truncate truncate) {
        }

        public void visit(Update update) {
            List joins;
            FromItem fromItem;
            for (Object table : update.getTables()) {
                this.visit((Table)table);
            }
            List expressions = update.getExpressions();
            if (expressions != null) {
                for (Expression expression : expressions) {
                    expression.accept((ExpressionVisitor)this);
                }
            }
            if ((fromItem = update.getFromItem()) != null) {
                fromItem.accept((FromItemVisitor)this);
            }
            if ((joins = update.getJoins()) != null) {
                for (Join join : update.getJoins()) {
                    fromItem = join.getRightItem();
                    fromItem.accept((FromItemVisitor)this);
                }
            }
            update.setWhere(this._visit(update.getWhere()));
        }

        public void visit(Upsert upsert) {
        }

        public void visit(UserVariable userVariable) {
        }

        public void visit(UseStatement useStatement) {
        }

        public void visit(ValueListExpression valueListExpression) {
            ExpressionList expressionList = valueListExpression.getExpressionList();
            expressionList.accept((ItemsListVisitor)this);
        }

        public void visit(ValuesList valuesList) {
        }

        public void visit(ValuesStatement valuesStatement) {
        }

        public void visit(WhenClause whenClause) {
            Expression thenExpression;
            Expression whenExpression = whenClause.getWhenExpression();
            if (whenExpression != null) {
                whenExpression.accept((ExpressionVisitor)this);
            }
            if ((thenExpression = whenClause.getThenExpression()) != null) {
                thenExpression.accept((ExpressionVisitor)this);
            }
        }

        public void visit(WithItem withItem) {
            SelectBody selectBody = withItem.getSelectBody();
            selectBody.accept((SelectVisitor)this);
        }

        protected static EqualsTo equalsTo(Expression leftExpression, Expression rightExpression) {
            EqualsTo equalsTo = new EqualsTo();
            equalsTo.setLeftExpression(leftExpression);
            equalsTo.setRightExpression(rightExpression);
            return equalsTo;
        }

        protected BaseStatementVisitor(long ctCollectionId) {
            this.ctCollectionId = ctCollectionId;
        }

        protected abstract Expression getWhereExpression(Table var1, CTModelRegistration var2);

        protected abstract BaseStatementVisitor newInstance();

        private void _visit(BinaryExpression binaryExpression) {
            LinkedList<Object> deque = new LinkedList<Object>();
            deque.add(binaryExpression);
            Expression expression = null;
            while ((expression = (Expression)deque.poll()) != null) {
                if (expression instanceof BinaryExpression) {
                    BinaryExpression nextBinaryExpression = (BinaryExpression)expression;
                    deque.push(nextBinaryExpression.getRightExpression());
                    deque.push(nextBinaryExpression.getLeftExpression());
                    continue;
                }
                expression.accept((ExpressionVisitor)this);
            }
        }

        private Expression _visit(Expression whereExpression) {
            if (whereExpression != null) {
                whereExpression.accept((ExpressionVisitor)this);
            }
            for (TableWrapper tableWrapper : this._tableWrappers) {
                Table table = tableWrapper._table;
                CTModelRegistration ctModelRegistration = CTModelRegistry.getCTModelRegistration((String)table.getName());
                if (ctModelRegistration == null) continue;
                Expression ctExpression = this.getWhereExpression(table, ctModelRegistration);
                if (whereExpression == null) {
                    whereExpression = ctExpression;
                    continue;
                }
                whereExpression = new AndExpression(whereExpression, ctExpression);
            }
            return whereExpression;
        }
    }
}

