package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.protocols.*;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

import java.net.InetAddress;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla6 {
    protected JChannel a,b,c;


    void start() throws Exception {
     /*   a=create("A", "bla2");
        Address a_addr=a.getAddress();
        b=create("B", "bla2");
        c=create("C", "bla2");
        Util.waitUntilAllChannelsHaveSameView(10000, 1000, a,b,c);
        Address b_dest=b.getAddress();
        Util.close(a);
        Util.waitUntilAllChannelsHaveSameView(10000, 1000, b,c);


        System.out.printf("-- Non-member A sending messages to member %s\n", b_dest);
        injectMessage(new BytesMessage(b_dest, "hello").setSrc(a_addr), b);
        injectMessage(new BytesMessage(b_dest, "world").setSrc(a_addr), b);

        Util.keyPress("enter to stop");
        Util.close(c,b,a);*/

    }


    protected static JChannel create(String name, String cluster_name) throws Exception {
        return new JChannel(
          new UDP().setBindAddress(InetAddress.getLoopbackAddress())
            .setValue("logical_addr_cache_max_size", 3)
            .setValue("logical_addr_cache_expiration", 5000)
            .setValue("logical_addr_cache_reaper_interval", 10000)
            .setValue("who_has_cache_timeout", 2000),
          new PING(),
          new FD_ALL().setValue("msg_counts_as_heartbeat", true)
            .setValue("timeout", 8000).setValue("interval", 2000),
          new VERIFY_SUSPECT(),
          new NAKACK2(),
          new UNICAST3().setValue("conn_close_timeout", 20000),
          new STABLE(),
          new GMS().joinTimeout(1000)
        )
          .name(name).connect(cluster_name);
    }


    protected static void injectMessage(Message msg, JChannel ch) {
        Protocol p=ch.getProtocolStack().getTransport().getUpProtocol();
        p.up(msg);
    }


    public static void main(String[] args) throws Exception {
        new bla6().start();
    }




}
