/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cluster.multiple.internal.ClusterReceiver;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public abstract class BaseClusterReceiver
implements ClusterReceiver {
    private static final Log _log = LogFactoryUtil.getLog(BaseClusterReceiver.class);
    private volatile List<Address> _addresses;
    private volatile Address _coordinatorAddress;
    private final CountDownLatch _countDownLatch;
    private final ExecutorService _executorService;
    private final boolean _hasDoCoordinatorAddressUpdated;
    private final boolean _hasDoViewAccepted;

    public BaseClusterReceiver(ExecutorService executorService) {
        boolean hasDoCoordinatorAddressUpdated;
        block6: {
            Class<?> clazz;
            boolean hasDoViewAccepted;
            block5: {
                this._countDownLatch = new CountDownLatch(1);
                if (executorService == null) {
                    throw new NullPointerException("Executor service is null");
                }
                this._executorService = executorService;
                hasDoViewAccepted = false;
                clazz = this.getClass();
                try {
                    clazz.getDeclaredMethod("doAddressesUpdated", List.class, List.class);
                    hasDoViewAccepted = true;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    if (!_log.isDebugEnabled()) break block5;
                    _log.debug((Throwable)reflectiveOperationException);
                }
            }
            this._hasDoViewAccepted = hasDoViewAccepted;
            hasDoCoordinatorAddressUpdated = false;
            try {
                clazz.getDeclaredMethod("doCoordinatorAddressUpdated", Address.class, Address.class);
                hasDoCoordinatorAddressUpdated = true;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Throwable)reflectiveOperationException);
            }
        }
        this._hasDoCoordinatorAddressUpdated = hasDoCoordinatorAddressUpdated;
    }

    @Override
    public void addressesUpdated(List<Address> addresses) {
        if (this._addresses == null) {
            this._addresses = addresses;
            return;
        }
        List<Address> oldAddresses = null;
        try {
            this._countDownLatch.await();
            oldAddresses = this._addresses;
            this._addresses = addresses;
            if (this._hasDoViewAccepted) {
                this._executorService.execute(new AddressesUpdatedRunnable(oldAddresses, addresses));
            }
        }
        catch (InterruptedException interruptedException) {
            _log.error((Object)"Latch opened prematurely by interruption. Dependence may not be ready.", (Throwable)interruptedException);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to handle view update from ", oldAddresses, " to ", addresses}), (Throwable)rejectedExecutionException);
        }
    }

    @Override
    public void coordinatorAddressUpdated(Address coordinatorAddress) {
        if (this._coordinatorAddress == null) {
            this._coordinatorAddress = coordinatorAddress;
            return;
        }
        Address oldCoordinatorAddress = null;
        try {
            this._countDownLatch.await();
            oldCoordinatorAddress = this._coordinatorAddress;
            this._coordinatorAddress = coordinatorAddress;
            if (this._hasDoCoordinatorAddressUpdated) {
                this._executorService.execute(new CoordinatorAddressUpdatedRunnable(oldCoordinatorAddress, coordinatorAddress));
            }
        }
        catch (InterruptedException interruptedException) {
            _log.error((Object)"Latch opened prematurely by interruption. Dependence may not be ready.", (Throwable)interruptedException);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to handle coordinator address update from ", oldCoordinatorAddress, " to ", coordinatorAddress}), (Throwable)rejectedExecutionException);
        }
    }

    @Override
    public List<Address> getAddresses() {
        return Collections.unmodifiableList(this._addresses);
    }

    @Override
    public Address getCoordinatorAddress() {
        return this._coordinatorAddress;
    }

    @Override
    public void openLatch() {
        this._countDownLatch.countDown();
    }

    @Override
    public void receive(Object messagePayload, Address srcAddress) {
        try {
            this._countDownLatch.await();
            this._executorService.execute(new ReceiveRunnable(messagePayload, srcAddress));
        }
        catch (InterruptedException interruptedException) {
            _log.error((Object)"Latch opened prematurely by interruption. Dependence may not be ready.", (Throwable)interruptedException);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            _log.error((Object)("Unable to handle received message " + messagePayload), (Throwable)rejectedExecutionException);
        }
    }

    protected void doAddressesUpdated(List<Address> oldAddresses, List<Address> newAddresses) {
    }

    protected void doCoordinatorAddressUpdated(Address oldCoordinatorAddress, Address newCoordinatorAddress) {
    }

    protected abstract void doReceive(Object var1, Address var2);

    private class ReceiveRunnable
    implements Runnable {
        private final Object _messagePayload;
        private final Address _srcAddress;

        @Override
        public void run() {
            BaseClusterReceiver.this.doReceive(this._messagePayload, this._srcAddress);
        }

        private ReceiveRunnable(Object messagePayload, Address srcAddress) {
            this._messagePayload = messagePayload;
            this._srcAddress = srcAddress;
        }
    }

    private class CoordinatorAddressUpdatedRunnable
    implements Runnable {
        private final Address _newCoordinatorAddress;
        private final Address _oldCoordinatorAddress;

        @Override
        public void run() {
            BaseClusterReceiver.this.doCoordinatorAddressUpdated(this._oldCoordinatorAddress, this._newCoordinatorAddress);
        }

        private CoordinatorAddressUpdatedRunnable(Address oldCoordinatorAddress, Address newCoordinatorAddress) {
            this._oldCoordinatorAddress = oldCoordinatorAddress;
            this._newCoordinatorAddress = newCoordinatorAddress;
        }
    }

    private class AddressesUpdatedRunnable
    implements Runnable {
        private final List<Address> _newAddresses;
        private final List<Address> _oldAddresses;

        @Override
        public void run() {
            BaseClusterReceiver.this.doAddressesUpdated(this._oldAddresses, this._newAddresses);
        }

        private AddressesUpdatedRunnable(List<Address> oldAddresses, List<Address> newAddresses) {
            this._oldAddresses = oldAddresses;
            this._newAddresses = newAddresses;
        }
    }
}

