/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal.jgroups;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cluster.multiple.configuration.ClusterExecutorConfiguration;
import com.liferay.portal.cluster.multiple.internal.ClusterChannel;
import com.liferay.portal.cluster.multiple.internal.ClusterChannelFactory;
import com.liferay.portal.cluster.multiple.internal.ClusterReceiver;
import com.liferay.portal.cluster.multiple.internal.jgroups.JGroupsClusterChannel;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.SocketUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.cluster.multiple.configuration.ClusterExecutorConfiguration"}, enabled=false, immediate=true, service={ClusterChannelFactory.class})
public class JGroupsClusterChannelFactory
implements ClusterChannelFactory {
    private static final String[] _ENCODED_CHARACTERS = new String[]{"&amp;", "&quot;", "&apos;", "&gt;", "&lt;"};
    private static final String[] _ORIGINAL_CHARACTERS = new String[]{"&", "\"", "'", ">", "<"};
    private static final Log _log = LogFactoryUtil.getLog(JGroupsClusterChannelFactory.class);
    private InetAddress _bindInetAddress;
    private NetworkInterface _bindNetworkInterface;
    private final ConcurrentMap<ClassLoader, ClassLoader> _classLoaders = new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
    private volatile ClusterExecutorConfiguration _clusterExecutorConfiguration;
    private Props _props;

    @Override
    public ClusterChannel createClusterChannel(ExecutorService executorService, String channleLogicName, String channelPropertiesLocation, String clusterName, ClusterReceiver clusterReceiver) {
        try {
            return new JGroupsClusterChannel(executorService, channleLogicName, this._parseChannelProperties(channelPropertiesLocation), clusterName, clusterReceiver, this._bindInetAddress, this._clusterExecutorConfiguration, this._classLoaders);
        }
        catch (Exception exception) {
            throw new SystemException("Unable to create JGroupsClusterChannel", (Throwable)exception);
        }
    }

    @Override
    public InetAddress getBindInetAddress() {
        return this._bindInetAddress;
    }

    @Override
    public NetworkInterface getBindNetworkInterface() {
        return this._bindNetworkInterface;
    }

    @Activate
    @Modified
    protected synchronized void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._clusterExecutorConfiguration = (ClusterExecutorConfiguration)ConfigurableUtil.createConfigurable(ClusterExecutorConfiguration.class, properties);
        this._initSystemProperties(this._props.getArray("cluster.link.channel.system.properties"));
        this._initBindAddress(GetterUtil.getString((String)this._props.get("cluster.link.autodetect.address")));
    }

    @Deactivate
    protected synchronized void deactivate() {
        this._classLoaders.clear();
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._props = props;
    }

    private InputStream _getInputStream(String channelPropertiesLocation) throws IOException {
        InputStream inputStream = ConfiguratorFactory.getConfigStream((String)channelPropertiesLocation);
        if (inputStream == null) {
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            inputStream = classLoader.getResourceAsStream(channelPropertiesLocation);
        }
        if (inputStream == null) {
            throw new FileNotFoundException("Unable to load channel properties from " + channelPropertiesLocation);
        }
        return inputStream;
    }

    private void _initBindAddress(String autodetectAddress) {
        if (Validator.isNull((String)autodetectAddress)) {
            return;
        }
        String host = autodetectAddress;
        int port = 80;
        int index = autodetectAddress.indexOf(58);
        if (index != -1) {
            host = autodetectAddress.substring(0, index);
            port = GetterUtil.getInteger((String)autodetectAddress.substring(index + 1), (int)port);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Autodetecting JGroups outgoing IP address and interface ", "for ", host, ":", port}));
        }
        try {
            SocketUtil.BindInfo bindInfo = SocketUtil.getBindInfo((String)host, (int)port);
            this._bindInetAddress = bindInfo.getInetAddress();
            this._bindNetworkInterface = bindInfo.getNetworkInterface();
        }
        catch (IOException ioException1) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to detect bind address for JGroups, using loopback");
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)ioException1);
                }
            }
            this._bindInetAddress = InetAddress.getLoopbackAddress();
            try {
                this._bindNetworkInterface = NetworkInterface.getByInetAddress(this._bindInetAddress);
            }
            catch (IOException ioException2) {
                _log.error((Object)"Unable to bind to lopoback interface", (Throwable)ioException2);
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Setting JGroups outgoing IP address to ", this._bindInetAddress.getHostAddress(), " and interface to ", this._bindNetworkInterface.getName()}));
        }
    }

    private void _initSystemProperties(String[] channelSystemPropertiesArray) {
        for (String channelSystemProperty : channelSystemPropertiesArray) {
            int index = channelSystemProperty.indexOf(58);
            if (index == -1) continue;
            String key = channelSystemProperty.substring(0, index);
            String value = channelSystemProperty.substring(index + 1);
            System.setProperty(key, value);
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Setting system property {key=", key, ", value=", value, "}"}));
        }
    }

    private ProtocolStackConfigurator _parseChannelProperties(String channelPropertiesLocation) throws Exception {
        try (InputStream inputStream = this._getInputStream(channelPropertiesLocation);){
            int endIndex;
            int startIndex;
            String configXML = StreamUtil.toString((InputStream)inputStream);
            int index = 0;
            StringBundler sb = new StringBundler();
            while (index < configXML.length() && (startIndex = configXML.indexOf("${", index)) >= 0 && (endIndex = configXML.indexOf("}", startIndex)) >= 0) {
                String propertyKey = configXML.substring(startIndex + 2, endIndex);
                String value = this._props.get(StringUtil.replace((String)propertyKey, (String[])_ENCODED_CHARACTERS, (String[])_ORIGINAL_CHARACTERS));
                if (value instanceof String) {
                    sb.append(configXML.substring(index, startIndex));
                    sb.append(StringUtil.replace((String)value, (String[])_ORIGINAL_CHARACTERS, (String[])_ENCODED_CHARACTERS));
                } else {
                    sb.append(configXML.substring(index, endIndex + 1));
                }
                index = endIndex + 1;
            }
            if (sb.length() > 0) {
                if (index < configXML.length()) {
                    sb.append(configXML.substring(index));
                }
                configXML = sb.toString();
            }
            ProtocolStackConfigurator protocolStackConfigurator = ConfiguratorFactory.getStackConfigurator((InputStream)new UnsyncByteArrayInputStream(configXML.getBytes("UTF-8")));
            return protocolStackConfigurator;
        }
    }
}

