/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.cluster.internal;

import com.liferay.portal.configuration.cluster.internal.ConfigurationThreadLocal;
import com.liferay.portal.configuration.persistence.InMemoryOnlyConfigurationThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.SynchronousConfigurationListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={SynchronousConfigurationListener.class})
public class ConfigurationSynchronousConfigurationListener
implements SynchronousConfigurationListener {
    @Reference
    private ClusterLink _clusterLink;
    @Reference(target="(destination.name=liferay/configuration)")
    private Destination _destination;

    public void configurationEvent(ConfigurationEvent configurationEvent) {
        if (ConfigurationThreadLocal.isLocalUpdate() || InMemoryOnlyConfigurationThreadLocal.isInMemoryOnly()) {
            return;
        }
        Message message = new Message();
        message.setDestinationName("liferay/configuration");
        message.put("service.pid", (Object)configurationEvent.getPid());
        message.put("configuration.event.type", (Object)configurationEvent.getType());
        this._clusterLink.sendMulticastMessage(message, Priority.LEVEL10);
    }
}

