/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.extender.internal;

import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.extender.internal.NamedConfigurationContent;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={})
public class ConfiguratorExtender
implements BundleTrackerCustomizer<Bundle> {
    private static final Log _log = LogFactoryUtil.getLog(ConfiguratorExtender.class);
    private BundleTracker<?> _bundleTracker;
    @Reference
    private ConfigurationAdmin _configurationAdmin;

    public Bundle addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        Dictionary headers = bundle.getHeaders("");
        String configurationPath = (String)headers.get("Liferay-Configuration-Path");
        if (configurationPath == null) {
            return null;
        }
        ArrayList<NamedConfigurationContent> namedConfigurationContents = new ArrayList<NamedConfigurationContent>();
        this._addNamedConfigurations(bundle, configurationPath, namedConfigurationContents, inputStream -> ConfigurationHandler.read((InputStream)inputStream), "*.config");
        this._addNamedConfigurations(bundle, configurationPath, namedConfigurationContents, inputStream -> PropertiesUtil.load((InputStream)inputStream, (String)"UTF-8"), "*.properties");
        if (namedConfigurationContents.isEmpty()) {
            return null;
        }
        ConfiguratorExtender._process(this._configurationAdmin, bundle.getSymbolicName(), namedConfigurationContents);
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Bundle trackedBundle) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Bundle trackedBundle) {
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker(bundleContext, 40, (BundleTrackerCustomizer)this);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    private static void _process(ConfigurationAdmin configurationAdmin, String symbolicName, Collection<NamedConfigurationContent> namedConfigurationContents) {
        for (NamedConfigurationContent namedConfigurationContent : namedConfigurationContents) {
            try {
                ConfiguratorExtender._process(configurationAdmin, symbolicName, namedConfigurationContent);
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
            }
        }
    }

    private static void _process(ConfigurationAdmin configurationAdmin, String symbolicName, NamedConfigurationContent namedConfigurationContent) throws InvalidSyntaxException, IOException {
        Configuration configuration = null;
        String configuratorURL = null;
        if (namedConfigurationContent.getFactoryPid() == null) {
            String pid = namedConfigurationContent.getPid();
            if (ArrayUtil.isNotEmpty((Object[])configurationAdmin.listConfigurations("(service.pid=" + pid + ")"))) {
                return;
            }
            configuration = configurationAdmin.getConfiguration(pid, "?");
        } else {
            configuratorURL = symbolicName + "#" + namedConfigurationContent.getPid();
            if (ArrayUtil.isNotEmpty((Object[])configurationAdmin.listConfigurations("(configurator.url=" + configuratorURL + ")"))) {
                return;
            }
            configuration = configurationAdmin.createFactoryConfiguration(namedConfigurationContent.getFactoryPid(), "?");
        }
        Dictionary<String, Object> properties = null;
        try {
            properties = namedConfigurationContent.getProperties();
        }
        catch (Throwable throwable) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Supplier from description ", namedConfigurationContent, " threw an exception: "}), throwable);
            }
            return;
        }
        if (configuratorURL != null) {
            properties.put("configurator.url", configuratorURL);
        }
        configuration.update(properties);
    }

    private void _addNamedConfigurations(Bundle bundle, String configurationPath, List<NamedConfigurationContent> namedConfigurationContents, UnsafeFunction<InputStream, Dictionary<?, ?>, IOException> propertyFunction, String filePattern) {
        Enumeration enumeration = bundle.findEntries(configurationPath, filePattern, true);
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            String name = url.getFile();
            int lastIndexOfSlash = name.lastIndexOf(47);
            if (lastIndexOfSlash < 0) {
                lastIndexOfSlash = 0;
            }
            String factoryPid = null;
            String pid = null;
            int index = name.lastIndexOf(45);
            if (index > lastIndexOfSlash) {
                factoryPid = name.substring(lastIndexOfSlash, index);
                pid = name.substring(index + 1, name.length() + 1 - filePattern.length());
            } else {
                pid = name.substring(lastIndexOfSlash, name.length() + 1 - filePattern.length());
            }
            namedConfigurationContents.add(new NamedConfigurationContent(factoryPid, pid, () -> {
                try (InputStream inputStream = url.openStream();){
                    Dictionary dictionary = (Dictionary)propertyFunction.apply((Object)inputStream);
                    return dictionary;
                }
            }));
        }
    }
}

