/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.module.configuration.internal;

import aQute.bnd.annotation.metatype.Meta;
import com.liferay.portal.configuration.module.configuration.internal.ConfigurationOverrideInstance;
import com.liferay.portal.configuration.persistence.ConfigurationOverridePropertiesUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class ConfigurationInvocationHandler<S>
implements InvocationHandler {
    private final Class<S> _clazz;
    private final ConfigurationOverrideInstance _configurationOverrideInstance;
    private final Map<String, Object> _overrideProperties;
    private final TypedSettings _typedSettings;

    public ConfigurationInvocationHandler(Class<S> clazz, TypedSettings typedSettings) throws ConfigurationException, ReflectiveOperationException {
        this._clazz = clazz;
        this._typedSettings = typedSettings;
        this._configurationOverrideInstance = ConfigurationOverrideInstance.getConfigurationOverrideInstance(clazz, typedSettings);
        this._overrideProperties = ConfigurationOverridePropertiesUtil.getOverrideProperties((String)clazz.getName());
    }

    public S createProxy() {
        return (S)ProxyUtil.newProxyInstance((ClassLoader)this._clazz.getClassLoader(), (Class[])new Class[]{this._clazz}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws InvocationTargetException {
        try {
            Object result;
            Object overrideValue;
            if (this._overrideProperties != null && (overrideValue = this._overrideProperties.get(method.getName())) != null) {
                return overrideValue;
            }
            if (this._configurationOverrideInstance != null && (result = this._configurationOverrideInstance.invoke(method)) != ConfigurationOverrideInstance.NULL_RESULT) {
                return result;
            }
            return this._invokeTypedSettings(method);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    private Object _getValue(Class<?> returnType, String key) throws ReflectiveOperationException {
        if (returnType.equals(Boolean.TYPE) || returnType.equals(Double.TYPE) || returnType.equals(Float.TYPE) || returnType.equals(Integer.TYPE) || returnType.equals(Long.TYPE)) {
            String value = this._typedSettings.getValue(key, null);
            if (value == null) {
                return value;
            }
            if (returnType.equals(Boolean.TYPE)) {
                return GetterUtil.getBoolean((String)value);
            }
            if (returnType.equals(Double.TYPE)) {
                return GetterUtil.getDouble((String)value);
            }
            if (returnType.equals(Float.TYPE)) {
                return Float.valueOf(GetterUtil.getFloat((String)value));
            }
            if (returnType.equals(Integer.TYPE)) {
                return GetterUtil.getInteger((String)value);
            }
            if (returnType.equals(Long.TYPE)) {
                return GetterUtil.getLong((String)value);
            }
        } else {
            if (returnType.equals(LocalizedValuesMap.class)) {
                LocalizedValuesMap localizedValuesMap = this._typedSettings.getLocalizedValuesMap(key);
                if (localizedValuesMap.getDefaultValue() == null) {
                    return null;
                }
                return localizedValuesMap;
            }
            if (returnType.equals(String.class)) {
                return this._typedSettings.getValue(key, null);
            }
            if (returnType.equals(String[].class)) {
                return this._typedSettings.getValues(key, null);
            }
            if (returnType.isEnum()) {
                String value = this._typedSettings.getValue(key, null);
                if (value == null) {
                    return value;
                }
                Method valueOfMethod = returnType.getDeclaredMethod("valueOf", String.class);
                return valueOfMethod.invoke(returnType, value);
            }
        }
        Constructor<?> constructor = returnType.getConstructor(String.class);
        return constructor.newInstance(this._typedSettings.getValue(key, null));
    }

    private Object _invokeTypedSettings(Method method) throws ReflectiveOperationException {
        Object value;
        Class<?> returnType = method.getReturnType();
        Meta.AD annotation = method.getAnnotation(Meta.AD.class);
        if (annotation != null && !"\u00a7NULL\u00a7".equals(annotation.id()) && (value = this._getValue(returnType, annotation.id())) != null) {
            return value;
        }
        if (returnType.equals(Boolean.TYPE)) {
            return this._typedSettings.getBooleanValue(method.getName());
        }
        if (returnType.equals(Double.TYPE)) {
            return this._typedSettings.getDoubleValue(method.getName());
        }
        if (returnType.equals(Float.TYPE)) {
            return Float.valueOf(this._typedSettings.getFloatValue(method.getName()));
        }
        if (returnType.equals(Integer.TYPE)) {
            return this._typedSettings.getIntegerValue(method.getName());
        }
        if (returnType.equals(LocalizedValuesMap.class)) {
            return this._typedSettings.getLocalizedValuesMap(method.getName());
        }
        if (returnType.equals(Long.TYPE)) {
            return this._typedSettings.getLongValue(method.getName());
        }
        if (returnType.equals(String.class)) {
            return this._typedSettings.getValue(method.getName());
        }
        if (returnType.equals(String[].class)) {
            return this._typedSettings.getValues(method.getName());
        }
        if (returnType.isEnum()) {
            Method valueOfMethod = returnType.getDeclaredMethod("valueOf", String.class);
            return valueOfMethod.invoke(returnType, this._typedSettings.getValue(method.getName()));
        }
        Constructor<?> constructor = returnType.getConstructor(String.class);
        return constructor.newInstance(this._typedSettings.getValue(method.getName()));
    }
}

