/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.module.configuration.internal.model.listener;

import com.liferay.asset.kernel.util.NotifiedAssetEntryThreadLocal;
import com.liferay.portal.configuration.module.configuration.internal.ConfigurationOverrideInstance;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.settings.definition.ConfigurationPidMapping;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class PortletPreferencesModelListener
extends BaseModelListener<PortletPreferences> {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesModelListener.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    @Reference
    private SettingsLocatorHelper _settingsLocatorHelper;

    public void onAfterCreate(PortletPreferences portletPreferences) throws ModelListenerException {
        this._clearConfigurationOverrideInstance(portletPreferences);
    }

    public void onAfterRemove(PortletPreferences portletPreferences) throws ModelListenerException {
        this._clearConfigurationOverrideInstance(portletPreferences);
    }

    public void onAfterUpdate(PortletPreferences originalPortletPreferences, PortletPreferences portletPreferences) throws ModelListenerException {
        this._updateLayout(portletPreferences);
        this._clearConfigurationOverrideInstance(portletPreferences);
    }

    private void _clearConfigurationOverrideInstance(PortletPreferences portletPreferences) {
        if (portletPreferences == null || portletPreferences.getPortletId() == null) {
            return;
        }
        ConfigurationPidMapping configurationPidMapping = this._getConfigurationPidMapping(portletPreferences.getPortletId());
        if (configurationPidMapping == null) {
            return;
        }
        ConfigurationOverrideInstance.clearConfigurationOverrideInstance(configurationPidMapping.getConfigurationBeanClass());
    }

    private ConfigurationPidMapping _getConfigurationPidMapping(String configurationId) {
        ConfigurationPidMapping configurationPidMapping = this._settingsLocatorHelper.getConfigurationPidMapping(configurationId);
        if (configurationPidMapping == null) {
            return null;
        }
        Class clazz = configurationPidMapping.getConfigurationBeanClass();
        if (clazz.getAnnotation(Settings.Config.class) == null) {
            return configurationPidMapping;
        }
        return null;
    }

    private void _updateLayout(PortletPreferences portletPreferences) {
        try {
            if (portletPreferences.getOwnerType() == 2 && portletPreferences.getOwnerId() > 0L) {
                Group group = this._groupLocalService.fetchGroup(portletPreferences.getOwnerId());
                if (group == null) {
                    return;
                }
                String className = group.getClassName();
                if (!className.equals(LayoutSetPrototype.class.getName())) {
                    return;
                }
                LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.fetchLayoutSetPrototype(group.getClassPK());
                if (layoutSetPrototype == null) {
                    return;
                }
                layoutSetPrototype.setModifiedDate(new Date());
                this._layoutSetPrototypeLocalService.updateLayoutSetPrototype(layoutSetPrototype);
            } else if (portletPreferences.getOwnerType() == 3 && portletPreferences.getPlid() > 0L) {
                Layout layout = this._layoutLocalService.fetchLayout(portletPreferences.getPlid());
                if (layout == null || NotifiedAssetEntryThreadLocal.isNotifiedAssetEntryIdsModified()) {
                    return;
                }
                if (layout.isDraftLayout()) {
                    ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
                    this._layoutLocalService.updateStatus(serviceContext.getUserId(), layout.getPlid(), 2, serviceContext);
                } else {
                    layout.setModifiedDate(new Date());
                    this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
                }
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to update the layout's modified date", (Throwable)exception);
        }
    }
}

