/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.module.configuration.internal.model.listener;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.configuration.module.configuration.internal.ConfigurationOverrideInstance;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.settings.definition.ConfigurationPidMapping;
import com.liferay.portal.kernel.util.StringUtil;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ConfigurationListener.class, ModelListener.class})
public class PortletPreferencesModelListener
extends BaseModelListener<PortletPreferences>
implements ConfigurationListener {
    private ServiceTrackerMap<String, ConfigurationPidMapping> _stringConfigurationPidMappingServiceTrackerMap;

    public void configurationEvent(ConfigurationEvent configurationEvent) {
        String key = configurationEvent.getPid();
        String factoryPid = configurationEvent.getFactoryPid();
        if (factoryPid != null) {
            key = StringUtil.replaceLast((String)factoryPid, (String)".scoped", (String)"");
        }
        ConfigurationOverrideInstance.clearConfigurationOverrideInstance(key);
    }

    public void onAfterCreate(PortletPreferences portletPreferences) throws ModelListenerException {
        this._clearConfigurationOverrideInstance(portletPreferences);
    }

    public void onAfterRemove(PortletPreferences portletPreferences) throws ModelListenerException {
        this._clearConfigurationOverrideInstance(portletPreferences);
    }

    public void onAfterUpdate(PortletPreferences portletPreferences) throws ModelListenerException {
        this._clearConfigurationOverrideInstance(portletPreferences);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._stringConfigurationPidMappingServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ConfigurationPidMapping.class, null, (serviceReference, emitter) -> {
            ConfigurationPidMapping configurationPidMapping = (ConfigurationPidMapping)bundleContext.getService(serviceReference);
            emitter.emit((Object)configurationPidMapping.getConfigurationPid());
        });
    }

    @Deactivate
    protected void deactivate() {
        this._stringConfigurationPidMappingServiceTrackerMap.close();
    }

    private void _clearConfigurationOverrideInstance(PortletPreferences portletPreferences) {
        if (portletPreferences == null || portletPreferences.getPortletId() == null) {
            return;
        }
        ConfigurationPidMapping configurationPidMapping = (ConfigurationPidMapping)this._stringConfigurationPidMappingServiceTrackerMap.getService((Object)portletPreferences.getPortletId());
        if (configurationPidMapping == null) {
            return;
        }
        ConfigurationOverrideInstance.clearConfigurationOverrideInstance(configurationPidMapping.getConfigurationBeanClass());
    }
}

