/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.persistence;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.file.install.properties.ConfigurationHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConfigurationOverridePropertiesUtil {
    private static final Log _log = LogFactoryUtil.getLog(ConfigurationOverridePropertiesUtil.class);
    private static final Map<String, Map<String, Object>> _overridePropertiesMap;

    public static Map<String, Object> getOverrideProperties(String pid) {
        return _overridePropertiesMap.get(pid);
    }

    public static Map<String, Map<String, Object>> getOverridePropertiesMap() {
        return _overridePropertiesMap;
    }

    static {
        Properties properties = PropsUtil.getProperties((String)"configuration.override.", (boolean)true);
        HashMap<String, Map> overridePropertiesMap = new HashMap<String, Map>();
        for (String string : properties.stringPropertyNames()) {
            int index = string.indexOf(95);
            if (index <= 0) continue;
            Map overrideProperties = overridePropertiesMap.computeIfAbsent(string.substring(0, index), pid -> new HashMap());
            try {
                String valueString = properties.getProperty(string);
                Object value = ConfigurationHandler.read((String)valueString);
                if (value == null && !valueString.isEmpty()) {
                    _log.error((Object)StringBundler.concat((String[])new String[]{"Key ", string, " was overridden with incorrectly formatted ", "content"}));
                    continue;
                }
                overrideProperties.put(string.substring(index + 1), value);
            }
            catch (IOException ioException) {
                _log.error((Object)"Unable to parse property", (Throwable)ioException);
            }
        }
        for (Map.Entry entry : overridePropertiesMap.entrySet()) {
            Map map = (Map)entry.getValue();
            map.put("service.pid", entry.getKey());
            entry.setValue(Collections.unmodifiableMap(map));
        }
        _overridePropertiesMap = Collections.unmodifiableMap(overridePropertiesMap);
    }
}

