/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.persistence.internal.upgrade.v1_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Dictionary;
import org.apache.felix.cm.file.ConfigurationHandler;

public class ConfigurationUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        if (!this.hasTable("Configuration_")) {
            return;
        }
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select * from Configuration_");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update Configuration_ set configurationId = ?, dictionary = ? where configurationId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                Dictionary dictionary;
                String serviceFactoryPid;
                String dictionaryString = resultSet.getString("dictionary");
                if (Validator.isNull((String)dictionaryString) || (serviceFactoryPid = (String)(dictionary = ConfigurationHandler.read((InputStream)new UnsyncByteArrayInputStream(dictionaryString.getBytes("UTF-8")))).get("service.factoryPid")) == null) continue;
                String currentConfigurationId = resultSet.getString("configurationId");
                String felixFileInstallFilename = (String)dictionary.get("felix.fileinstall.filename");
                int serviceFactoryPidEndIndex = serviceFactoryPid.length();
                String suffix = currentConfigurationId.substring(serviceFactoryPidEndIndex + 1);
                if (felixFileInstallFilename != null) {
                    File file = new File(PropsValues.MODULE_FRAMEWORK_CONFIGS_DIR, felixFileInstallFilename);
                    if (file.exists()) {
                        suffix = felixFileInstallFilename.substring(serviceFactoryPidEndIndex + 1, felixFileInstallFilename.lastIndexOf(46));
                    } else {
                        dictionary.remove("felix.fileinstall.filename");
                    }
                }
                String updatedConfigurationId = StringBundler.concat((Object[])new Object[]{serviceFactoryPid, Character.valueOf('~'), suffix});
                dictionary.put("service.pid", updatedConfigurationId);
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                ConfigurationHandler.write((OutputStream)unsyncByteArrayOutputStream, (Dictionary)dictionary);
                preparedStatement2.setString(1, updatedConfigurationId);
                preparedStatement2.setString(2, unsyncByteArrayOutputStream.toString());
                preparedStatement2.setString(3, currentConfigurationId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

