/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.persistence.internal.upgrade.v2_0_0;

import com.liferay.petra.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.db.partition.util.DBPartitionUtil;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Dictionary;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.cm.file.ConfigurationHandler;

public class ConfigurationDBPartitionUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(ConfigurationDBPartitionUpgradeProcess.class);
    private static final AtomicInteger _atomicInteger = new AtomicInteger();
    private static final CopyOnWriteArrayList<ScopeConfiguration> _scopeConfigurations = new CopyOnWriteArrayList();

    protected void doUpgrade() throws Exception {
        if (PortalInstancePool.getDefaultCompanyId() == CompanyThreadLocal.getCompanyId()) {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("select configurationId, dictionary from Configuration_");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    ScopeConfiguration scopeConfiguration = this._getScopeConfiguration(resultSet.getString(1), resultSet.getString(2));
                    if (scopeConfiguration == null) continue;
                    if (Objects.equals(scopeConfiguration.getScope(), ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE)) {
                        _scopeConfigurations.add(scopeConfiguration);
                        continue;
                    }
                    if (this._isApplicable(scopeConfiguration, PortalInstancePool.getDefaultCompanyId())) continue;
                    _scopeConfigurations.add(scopeConfiguration);
                    this._removeConfiguration(scopeConfiguration.getConfigurationId());
                }
            }
            long[] companyIds = PortalInstancePool.getCompanyIds();
            _atomicInteger.set(companyIds.length - 1);
            return;
        }
        DBPartitionUtil.replaceByTable((Connection)this.connection, (boolean)false, (String)"Configuration_");
        for (ScopeConfiguration scopeConfiguration : _scopeConfigurations) {
            if (!this._isApplicable(scopeConfiguration, CompanyThreadLocal.getCompanyId())) continue;
            this._insertConfiguration(scopeConfiguration.getConfigurationId(), scopeConfiguration.getDictionary());
            if (Objects.equals(scopeConfiguration.getScope(), ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE)) continue;
            _scopeConfigurations.remove(scopeConfiguration);
        }
        int remainingCompanies = _atomicInteger.decrementAndGet();
        if (remainingCompanies == 0 && _log.isWarnEnabled()) {
            for (ScopeConfiguration scopeConfiguration : _scopeConfigurations) {
                if (Objects.equals(scopeConfiguration.getScope(), ExtendedObjectClassDefinition.Scope.COMPANY)) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Company scope configuration with ID ", scopeConfiguration.getConfigurationId(), " has been removed because the company ID ", scopeConfiguration.getScopePK(), " does not exist"}));
                }
                if (!Objects.equals(scopeConfiguration.getScope(), ExtendedObjectClassDefinition.Scope.GROUP)) continue;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Group scope configuration with ID ", scopeConfiguration.getConfigurationId(), " has been removed because the group ID ", scopeConfiguration.getScopePK(), " does not exist"}));
            }
        }
    }

    protected boolean isSkipUpgradeProcess() {
        return !DBPartition.isPartitionEnabled();
    }

    private ScopeConfiguration _getScopeConfiguration(String configurationId, String dictionary) throws Exception {
        Dictionary dictionaryMap = ConfigurationHandler.read((InputStream)new UnsyncByteArrayInputStream(dictionary.getBytes("UTF-8")));
        Object value = dictionaryMap.get(ExtendedObjectClassDefinition.Scope.COMPANY.getPropertyKey());
        if (value != null) {
            return new ScopeConfiguration(configurationId, dictionary, Long.valueOf(GetterUtil.getLong(value)), ExtendedObjectClassDefinition.Scope.COMPANY);
        }
        value = dictionaryMap.get(ExtendedObjectClassDefinition.Scope.GROUP.getPropertyKey());
        if (value != null) {
            return new ScopeConfiguration(configurationId, dictionary, Long.valueOf(GetterUtil.getLong(value)), ExtendedObjectClassDefinition.Scope.GROUP);
        }
        value = dictionaryMap.get(ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE.getPropertyKey());
        if (value != null) {
            return new ScopeConfiguration(configurationId, dictionary, (Serializable)((Object)GetterUtil.getString(value)), ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE);
        }
        return null;
    }

    private void _insertConfiguration(String configurationId, String dictionary) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("insert into Configuration_ (configurationId, dictionary) values (?, ?)");){
            preparedStatement.setString(1, configurationId);
            preparedStatement.setString(2, dictionary);
            preparedStatement.executeUpdate();
        }
    }

    private boolean _isApplicable(ScopeConfiguration scopeConfiguration, long companyId) throws Exception {
        if (Objects.equals(scopeConfiguration.getScope(), ExtendedObjectClassDefinition.Scope.COMPANY)) {
            return companyId == (Long)scopeConfiguration.getScopePK();
        }
        if (Objects.equals(scopeConfiguration.getScope(), ExtendedObjectClassDefinition.Scope.GROUP)) {
            try (PreparedStatement preparedStatement = this.connection.prepareStatement("select groupId from Group_ where groupId = ?");){
                preparedStatement.setLong(1, (Long)scopeConfiguration.getScopePK());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            return false;
        }
        return true;
    }

    private void _removeConfiguration(String configurationId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("delete from Configuration_ where configurationId = ?");){
            preparedStatement.setString(1, configurationId);
            preparedStatement.executeUpdate();
        }
    }

    private class ScopeConfiguration {
        private final String _configurationId;
        private final String _dictionary;
        private final ExtendedObjectClassDefinition.Scope _scope;
        private final Object _scopePK;

        public ScopeConfiguration(String configurationId, String dictionary, Serializable scopePK, ExtendedObjectClassDefinition.Scope scope) {
            this._configurationId = configurationId;
            this._dictionary = dictionary;
            this._scopePK = scopePK;
            this._scope = scope;
        }

        public String getConfigurationId() {
            return this._configurationId;
        }

        public String getDictionary() {
            return this._dictionary;
        }

        public ExtendedObjectClassDefinition.Scope getScope() {
            return this._scope;
        }

        public Object getScopePK() {
            return this._scopePK;
        }
    }
}

