/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.persistence.internal.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.persistence.upgrade.ConfigurationUpgradeStepFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.felix.cm.PersistenceManager;

public class ConfigurationUpgradeStepFactoryImpl
implements ConfigurationUpgradeStepFactory {
    private static final Log _log = LogFactoryUtil.getLog(ConfigurationUpgradeStepFactoryImpl.class);
    private final PersistenceManager _persistenceManager;

    public ConfigurationUpgradeStepFactoryImpl(PersistenceManager persistenceManager) {
        this._persistenceManager = persistenceManager;
    }

    public UpgradeStep createUpgradeStep(String oldPid, String newPid) {
        return dbProcessContext -> {
            try {
                Enumeration enumeration = this._persistenceManager.getDictionaries();
                while (enumeration.hasMoreElements()) {
                    Dictionary dictionary = (Dictionary)enumeration.nextElement();
                    String oldServicePid = (String)dictionary.get("service.pid");
                    if (!oldPid.equals(oldServicePid)) {
                        if (!oldPid.equals(dictionary.get("service.factoryPid"))) continue;
                        dictionary.put("service.factoryPid", newPid);
                    }
                    String newServicePid = StringUtil.replace((String)oldServicePid, (String)oldPid, (String)newPid);
                    dictionary.put("service.pid", newServicePid);
                    String fileName = (String)dictionary.get("felix.fileinstall.filename");
                    if (fileName != null) {
                        dictionary.put("felix.fileinstall.filename", StringUtil.replace((String)fileName, (String)oldPid, (String)newPid));
                    }
                    this._persistenceManager.store(newServicePid, dictionary);
                    this._persistenceManager.delete(oldServicePid);
                }
                File configResourcesDir = new File(PropsValues.MODULE_FRAMEWORK_CONFIGS_DIR);
                for (File file : configResourcesDir.listFiles()) {
                    String fileName = file.getName();
                    if (!fileName.equals(oldPid.concat(".cfg")) && !fileName.equals(oldPid.concat(".config")) && !fileName.startsWith(oldPid.concat("-"))) continue;
                    File newFile = new File(StringUtil.replace((String)file.getPath(), (String)oldPid, (String)newPid));
                    if (newFile.exists()) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to rename ", file.getAbsolutePath(), " to ", newFile.getAbsolutePath(), " because the file already exists"}));
                        continue;
                    }
                    Files.move(file.toPath(), newFile.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException ioException) {
                throw new UpgradeException((Throwable)ioException);
            }
        };
    }
}

