/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.settings.internal;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsDescriptor;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class AnnotatedSettingsDescriptor
implements SettingsDescriptor {
    private final DCLSingleton<Set<String>> _allKeysDCLSingleton = new DCLSingleton();
    private final DCLSingleton<Set<String>> _multiValuedKeysDCLSingleton = new DCLSingleton();
    private final Class<?> _settingsClass;

    public AnnotatedSettingsDescriptor(Class<?> settingsClass) {
        this._settingsClass = settingsClass;
    }

    public Set<String> getAllKeys() {
        return new HashSet<String>((Collection)this._allKeysDCLSingleton.getSingleton(this::_createAllKeys));
    }

    public Set<String> getMultiValuedKeys() {
        return new HashSet<String>((Collection)this._multiValuedKeysDCLSingleton.getSingleton(this::_createMultiValuedKeys));
    }

    private Set<String> _createAllKeys() {
        HashSet<String> allKeys = new HashSet<String>();
        for (Method propertyMethod : this._getPropertyMethods()) {
            allKeys.add(this._getPropertyName(propertyMethod));
        }
        return allKeys;
    }

    private Set<String> _createMultiValuedKeys() {
        HashSet<String> multiValuedKeys = new HashSet<String>();
        for (Method propertyMethod : this._getPropertyMethods()) {
            Class<?> clazz = propertyMethod.getReturnType();
            if (clazz != String[].class) continue;
            multiValuedKeys.add(this._getPropertyName(propertyMethod));
        }
        return multiValuedKeys;
    }

    private Method[] _getPropertyMethods() {
        Method[] methods;
        ArrayList<Method> propertyMethods = new ArrayList<Method>();
        for (Method method : methods = this._settingsClass.getMethods()) {
            String name;
            Settings.Property settingsProperty = method.getAnnotation(Settings.Property.class);
            if (settingsProperty != null && settingsProperty.ignore() || (name = method.getName()).equals("getClass") || !name.startsWith("get") && !name.startsWith("is")) continue;
            propertyMethods.add(method);
        }
        return propertyMethods.toArray(new Method[0]);
    }

    private String _getPropertyName(Method propertyMethod) {
        String name;
        Settings.Property settingsProperty = propertyMethod.getAnnotation(Settings.Property.class);
        if (settingsProperty != null && !(name = settingsProperty.name()).isEmpty()) {
            return name;
        }
        name = propertyMethod.getName();
        if (name.startsWith("get")) {
            name = name.substring(3);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
        } else {
            throw new IllegalArgumentException("Invalid method name for getter " + propertyMethod.getName());
        }
        return StringUtil.toLowerCase((String)name.substring(0, 1)) + name.substring(1);
    }
}

