/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.settings.internal;

import com.liferay.portal.configuration.settings.internal.ArchivedSettingsImpl;
import com.liferay.portal.kernel.exception.NoSuchPortletItemException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.PortletItemLocalService;
import com.liferay.portal.kernel.settings.ArchivedSettings;
import com.liferay.portal.kernel.settings.ArchivedSettingsFactory;
import com.liferay.portal.kernel.settings.SettingsException;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ArchivedSettingsFactory.class})
public class ArchivedSettingsFactoryImpl
implements ArchivedSettingsFactory {
    private static final Log _log = LogFactoryUtil.getLog(ArchivedSettingsFactoryImpl.class);
    @Reference
    private PortletItemLocalService _portletItemLocalService;

    public ArchivedSettings getPortletInstanceArchivedSettings(long groupId, String portletId, String name) throws SettingsException {
        try {
            return new ArchivedSettingsImpl(this._getPortletItem(groupId, portletId, name));
        }
        catch (PortalException portalException) {
            throw new SettingsException((Throwable)portalException);
        }
    }

    public List<ArchivedSettings> getPortletInstanceArchivedSettingsList(long groupId, String portletId) {
        ArrayList<ArchivedSettings> archivedSettingsList = new ArrayList<ArchivedSettings>();
        List portletItems = this._portletItemLocalService.getPortletItems(groupId, portletId, com.liferay.portal.kernel.model.PortletPreferences.class.getName());
        for (PortletItem portletItem : portletItems) {
            archivedSettingsList.add(new ArchivedSettingsImpl(portletItem));
        }
        return archivedSettingsList;
    }

    private PortletItem _getPortletItem(long groupId, String portletId, String name) throws PortalException {
        PortletItem portletItem = null;
        try {
            portletItem = this._portletItemLocalService.getPortletItem(groupId, name, portletId, PortletPreferences.class.getName());
        }
        catch (NoSuchPortletItemException noSuchPortletItemException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchPortletItemException);
            }
            portletItem = this._portletItemLocalService.updatePortletItem(PrincipalThreadLocal.getUserId(), groupId, name, portletId, PortletPreferences.class.getName());
        }
        return portletItem;
    }
}

