/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.settings.internal;

import aQute.bnd.annotation.metatype.Meta;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.metatype.definitions.ExtendedMetaTypeInformation;
import com.liferay.portal.configuration.metatype.definitions.ExtendedMetaTypeService;
import com.liferay.portal.configuration.settings.internal.AnnotatedSettingsDescriptor;
import com.liferay.portal.configuration.settings.internal.ConfigurationBeanClassSettingsDescriptor;
import com.liferay.portal.configuration.settings.internal.scoped.configuration.admin.service.ScopedConfigurationManagedServiceFactory;
import com.liferay.portal.configuration.settings.internal.util.ConfigurationPidUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.resource.manager.ClassLoaderResourceManager;
import com.liferay.portal.kernel.resource.manager.ResourceManager;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.settings.ConfigurationBeanSettings;
import com.liferay.portal.kernel.settings.LocationVariableResolver;
import com.liferay.portal.kernel.settings.PortletPreferencesSettings;
import com.liferay.portal.kernel.settings.PropertiesSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsDescriptor;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.settings.definition.ConfigurationPidMapping;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.Props;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.portlet.PortletPreferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={SettingsLocatorHelper.class})
public class SettingsLocatorHelperImpl
implements SettingsLocatorHelper {
    private static final Log _log = LogFactoryUtil.getLog(SettingsLocatorHelperImpl.class);
    private BundleContext _bundleContext;
    private final DCLSingleton<BundleTracker<?>> _bundleTrackerDCLSingleton = new DCLSingleton();
    private final Map<String, Settings> _configurationBeanSettings = new ConcurrentHashMap<String, Settings>();
    @Reference
    private ExtendedMetaTypeService _extendedMetaTypeService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    private Settings _portalPropertiesSettings;
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PrefsProps _prefsProps;
    @Reference
    private Props _props;
    private final Map<String, ScopedConfigurationManagedServiceFactory> _scopedConfigurationManagedServiceFactories = new ConcurrentHashMap<String, ScopedConfigurationManagedServiceFactory>();
    private ServiceTrackerMap<String, ConfigurationPidMapping> _serviceTrackerMap;

    public Settings getCompanyConfigurationBeanSettings(long companyId, String configurationPid, Settings parentSettings) {
        return this._getScopedConfigurationBeanSettings(ExtendedObjectClassDefinition.Scope.COMPANY, Long.valueOf(companyId), configurationPid, parentSettings);
    }

    public Settings getCompanyPortletPreferencesSettings(long companyId, String settingsId, Settings parentSettings) {
        return new PortletPreferencesSettings(this._portletPreferencesLocalService.getStrictPreferences(companyId, companyId, 1, 0L, settingsId), parentSettings);
    }

    public Settings getConfigurationBeanSettings(String configurationPid) {
        this._bundleTrackerDCLSingleton.getSingleton(this::_createBundleTracker);
        Settings configurationBeanSettings = this._configurationBeanSettings.get(this._toOCDPid(configurationPid));
        if (configurationBeanSettings == null) {
            return this._portalPropertiesSettings;
        }
        return configurationBeanSettings;
    }

    public ConfigurationPidMapping getConfigurationPidMapping(String configurationId) {
        this._bundleTrackerDCLSingleton.getSingleton(this::_createBundleTracker);
        return (ConfigurationPidMapping)this._serviceTrackerMap.getService((Object)configurationId);
    }

    public Settings getGroupConfigurationBeanSettings(long groupId, String configurationPid, Settings parentSettings) {
        return this._getScopedConfigurationBeanSettings(ExtendedObjectClassDefinition.Scope.GROUP, Long.valueOf(groupId), configurationPid, parentSettings);
    }

    public Settings getGroupPortletPreferencesSettings(long groupId, String settingsId, Settings parentSettings) {
        try {
            Group group = this._groupLocalService.getGroup(groupId);
            return new PortletPreferencesSettings(this._portletPreferencesLocalService.getStrictPreferences(group.getCompanyId(), groupId, 2, 0L, settingsId), parentSettings);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    public Settings getPortalPreferencesSettings(long companyId, Settings parentSettings) {
        return new PortletPreferencesSettings(this._prefsProps.getPreferences(companyId), parentSettings);
    }

    public Settings getPortletInstanceConfigurationBeanSettings(String portletId, String configurationPid, Settings parentSettings) {
        return this._getScopedConfigurationBeanSettings(ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE, (Serializable)((Object)portletId), configurationPid, parentSettings);
    }

    public Settings getPortletInstancePortletPreferencesSettings(long companyId, long ownerId, int ownerType, long plid, String portletId, Settings parentSettings) {
        return new PortletPreferencesSettings(this._getPortletInstancePortletPreferences(companyId, ownerId, ownerType, plid, portletId), parentSettings);
    }

    public Settings getPortletInstancePortletPreferencesSettings(long companyId, long plid, String portletId, Settings parentSettings) {
        return this.getPortletInstancePortletPreferencesSettings(companyId, 0L, 3, plid, portletId, parentSettings);
    }

    public Settings getServerSettings(String settingsId) {
        return this.getConfigurationBeanSettings(settingsId);
    }

    public SettingsDescriptor getSettingsDescriptor(String settingsId) {
        ConfigurationPidMapping configurationPidMapping = this.getConfigurationPidMapping(settingsId = PortletIdCodec.decodePortletName((String)settingsId));
        Class clazz = configurationPidMapping.getConfigurationBeanClass();
        if (clazz.getAnnotation(Settings.Config.class) == null) {
            return new ConfigurationBeanClassSettingsDescriptor(clazz);
        }
        return new AnnotatedSettingsDescriptor(clazz);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._portalPropertiesSettings = new PropertiesSettings(new LocationVariableResolver((ResourceManager)new ClassLoaderResourceManager(PortalClassLoaderUtil.getClassLoader()), (SettingsLocatorHelper)this), this._props.getProperties());
        this._bundleContext = bundleContext;
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ConfigurationPidMapping.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.createFromFunction((BundleContext)bundleContext, ConfigurationPidMapping::getConfigurationPid));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
        this._bundleTrackerDCLSingleton.destroy(BundleTracker::close);
    }

    private BundleTracker<?> _createBundleTracker() {
        BundleTracker bundleTracker = new BundleTracker(this._bundleContext, 32, (BundleTrackerCustomizer)new ConfigurationBeanClassBundleTrackerCustomizer());
        bundleTracker.open();
        return bundleTracker;
    }

    private PortletPreferences _getPortletInstancePortletPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId) {
        Layout layout;
        if (plid != 0L && (layout = this._layoutLocalService.fetchLayout(plid)) != null) {
            return this._portletPreferencesFactory.getStrictPortletSetup(layout, portletId);
        }
        if (PortletIdCodec.hasUserId((String)portletId)) {
            ownerId = PortletIdCodec.decodeUserId((String)portletId);
            ownerType = 4;
        }
        return this._portletPreferencesLocalService.getStrictPreferences(companyId, ownerId, ownerType, plid, portletId);
    }

    private Settings _getScopedConfigurationBeanSettings(ExtendedObjectClassDefinition.Scope scope, Serializable scopePK, String configurationPid, Settings parentSettings) {
        this._bundleTrackerDCLSingleton.getSingleton(this::_createBundleTracker);
        ScopedConfigurationManagedServiceFactory scopedConfigurationManagedServiceFactory = this._scopedConfigurationManagedServiceFactories.get(configurationPid);
        if (scopedConfigurationManagedServiceFactory == null) {
            return parentSettings;
        }
        Object configurationBean = scopedConfigurationManagedServiceFactory.getConfiguration(scope, scopePK);
        if (configurationBean == null) {
            return parentSettings;
        }
        return new ConfigurationBeanSettings(scopedConfigurationManagedServiceFactory.getLocationVariableResolver(), configurationBean, parentSettings);
    }

    private SafeCloseable _registerConfigurationBeanClass(final Class<?> configurationBeanClass) {
        if (configurationBeanClass.getAnnotation(Meta.OCD.class) == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping registration for class because Meta.OCD is missing: " + configurationBeanClass.getName()));
            }
            return null;
        }
        HashSet<String> requiredKeys = new HashSet<String>();
        for (Method method : configurationBeanClass.getMethods()) {
            Meta.AD annotation = method.getAnnotation(Meta.AD.class);
            if (annotation == null || !annotation.required()) continue;
            requiredKeys.add(method.getName());
        }
        final String configurationPid = ConfigurationPidUtil.getConfigurationPid(configurationBeanClass);
        if (this._configurationBeanSettings.containsKey(configurationPid)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping registration for class because it is already registered: " + configurationPid));
            }
            return null;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        LocationVariableResolver locationVariableResolver = new LocationVariableResolver((ResourceManager)new ClassLoaderResourceManager(configurationBeanClass.getClassLoader()), (SettingsLocatorHelper)this);
        ServiceRegistration managedServiceServiceRegistration = this._bundleContext.registerService(ManagedService.class, properties -> {
            if (properties == null) {
                properties = new HashMapDictionary();
            }
            Enumeration enumeration = properties.keys();
            HashSet localRequiredKeys = new HashSet(requiredKeys);
            while (enumeration.hasMoreElements()) {
                localRequiredKeys.remove(enumeration.nextElement());
            }
            if (localRequiredKeys.isEmpty()) {
                this._configurationBeanSettings.put(configurationPid, (Settings)new ConfigurationBeanSettings(locationVariableResolver, ConfigurableUtil.createConfigurable((Class)configurationBeanClass, (Dictionary)properties), this._portalPropertiesSettings));
            }
            countDownLatch.countDown();
        }, MapUtil.singletonDictionary((Object)"service.pid", (Object)configurationPid));
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            _log.error((Throwable)interruptedException);
        }
        ScopedConfigurationManagedServiceFactory scopedConfigurationManagedServiceFactory = new ScopedConfigurationManagedServiceFactory(configurationBeanClass, locationVariableResolver);
        ServiceRegistration managedServiceFactoryServiceRegistration = this._bundleContext.registerService(ManagedServiceFactory.class, (Object)scopedConfigurationManagedServiceFactory, MapUtil.singletonDictionary((Object)"service.pid", (Object)(configurationPid + ".scoped")));
        this._scopedConfigurationManagedServiceFactories.put(scopedConfigurationManagedServiceFactory.getName(), scopedConfigurationManagedServiceFactory);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registering configuration class: " + configurationBeanClass.getName()));
        }
        ServiceRegistration configurationPidMappingServiceRegistration = this._bundleContext.registerService(ConfigurationPidMapping.class, (Object)new ConfigurationPidMapping(){

            public Class<?> getConfigurationBeanClass() {
                return configurationBeanClass;
            }

            public String getConfigurationPid() {
                return configurationPid;
            }
        }, null);
        return () -> {
            configurationPidMappingServiceRegistration.unregister();
            this._scopedConfigurationManagedServiceFactories.remove(configurationPid);
            managedServiceFactoryServiceRegistration.unregister();
            this._configurationBeanSettings.remove(configurationPid);
            managedServiceServiceRegistration.unregister();
        };
    }

    private String _toOCDPid(String configurationPid) {
        ConfigurationPidMapping configurationPidMapping = this.getConfigurationPidMapping(configurationPid);
        if (configurationPidMapping == null) {
            return configurationPid;
        }
        Class clazz = configurationPidMapping.getConfigurationBeanClass();
        if (clazz.getAnnotation(Settings.Config.class) != null) {
            return configurationPid;
        }
        return ConfigurationPidUtil.getConfigurationPid(clazz);
    }

    private class ConfigurationBeanClassBundleTrackerCustomizer
    implements BundleTrackerCustomizer<List<SafeCloseable>> {
        private ConfigurationBeanClassBundleTrackerCustomizer() {
        }

        public List<SafeCloseable> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            String bundleSymbolicName = bundle.getSymbolicName();
            if (bundleSymbolicName.endsWith(".test")) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Skipping bundle (do not check test modules): " + bundleSymbolicName));
                }
                return null;
            }
            ExtendedMetaTypeInformation metaTypeInformation = SettingsLocatorHelperImpl.this._extendedMetaTypeService.getMetaTypeInformation(bundle);
            if (metaTypeInformation == null) {
                return null;
            }
            ArrayList<SafeCloseable> autoCloseables = new ArrayList<SafeCloseable>();
            for (String pid : (String[])ArrayUtil.append((Object[])metaTypeInformation.getPids(), (Object[])metaTypeInformation.getFactoryPids())) {
                Class configurationBeanClass;
                try {
                    configurationBeanClass = bundle.loadClass(pid);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("Class not found: " + classNotFoundException.getMessage()));
                    continue;
                }
                SafeCloseable safeCloseable = SettingsLocatorHelperImpl.this._registerConfigurationBeanClass(configurationBeanClass);
                if (safeCloseable == null) continue;
                autoCloseables.add(safeCloseable);
            }
            if (ListUtil.isEmpty(autoCloseables)) {
                return null;
            }
            return autoCloseables;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, List<SafeCloseable> autoCloseables) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, List<SafeCloseable> safeCloseables) {
            if (ListUtil.isEmpty(safeCloseables)) {
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Un-registering configuration classes for bundle: " + bundle.getSymbolicName()));
            }
            for (SafeCloseable safeCloseable : safeCloseables) {
                safeCloseable.close();
            }
        }
    }
}

