/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.settings.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesServiceUtil;
import com.liferay.portal.kernel.settings.ArchivedSettings;
import com.liferay.portal.kernel.settings.BaseModifiableSettings;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.PortletPreferencesSettings;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import javax.portlet.PortletPreferences;
import javax.portlet.ValidatorException;

public class ArchivedSettingsImpl
extends BaseModifiableSettings
implements ArchivedSettings {
    private final PortletItem _portletItem;
    private PortletPreferencesSettings _portletPreferencesSettings;

    public ArchivedSettingsImpl(PortletItem portletItem) {
        this._portletItem = portletItem;
    }

    public void delete() throws IOException {
        try {
            PortletPreferencesServiceUtil.deleteArchivedPreferences((long)this._portletItem.getPortletItemId());
        }
        catch (PortalException portalException) {
            throw new IOException("Unable to delete archived settings", portalException);
        }
        catch (SystemException systemException) {
            throw new IOException("Unable to delete archived settings", systemException);
        }
    }

    public Date getModifiedDate() {
        return this._portletItem.getModifiedDate();
    }

    public Collection<String> getModifiedKeys() {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        return modifiableSettings.getModifiedKeys();
    }

    public String getName() {
        return this._portletItem.getName();
    }

    public String getUserName() {
        return this._portletItem.getUserName();
    }

    public void reset(String key) {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        modifiableSettings.reset(key);
    }

    public ModifiableSettings setValue(String key, String value) {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        modifiableSettings.setValue(key, value);
        return this;
    }

    public ModifiableSettings setValues(String key, String[] values) {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        modifiableSettings.setValues(key, values);
        return this;
    }

    public void store() throws IOException, ValidatorException {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        modifiableSettings.store();
    }

    protected String doGetValue(String key) {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        return modifiableSettings.getValue(key, null);
    }

    protected String[] doGetValues(String key) {
        ModifiableSettings modifiableSettings = this._getModifiableSettings();
        return modifiableSettings.getValues(key, null);
    }

    private ModifiableSettings _getModifiableSettings() {
        if (this._portletPreferencesSettings != null) {
            return this._portletPreferencesSettings;
        }
        PortletPreferences portletPreferences = null;
        try {
            long ownerId = this._portletItem.getPortletItemId();
            int ownerType = 5;
            long plid = 0L;
            portletPreferences = PortletPreferencesLocalServiceUtil.getPreferences((long)this._portletItem.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)PortletIdCodec.decodePortletName((String)this._portletItem.getPortletId()));
        }
        catch (SystemException systemException) {
            throw new RuntimeException("Unable to load settings", systemException);
        }
        this._portletPreferencesSettings = new PortletPreferencesSettings(portletPreferences);
        return this._portletPreferencesSettings;
    }
}

