/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.settings.internal;

import com.liferay.portal.kernel.settings.SettingsDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class ConfigurationBeanClassSettingsDescriptor
implements SettingsDescriptor {
    private final Set<String> _allKeys = new HashSet<String>();
    private final Class<?> _configurationBeanClass;
    private final Set<String> _multiValuedKeys = new HashSet<String>();

    public ConfigurationBeanClassSettingsDescriptor(Class<?> configurationBeanClass) {
        this._configurationBeanClass = configurationBeanClass;
        this._initAllKeys();
        this._initMultiValuedKeys();
    }

    public Set<String> getAllKeys() {
        return this._allKeys;
    }

    public Set<String> getMultiValuedKeys() {
        return this._multiValuedKeys;
    }

    private void _initAllKeys() {
        Method[] methods;
        for (Method method : methods = this._configurationBeanClass.getMethods()) {
            this._allKeys.add(method.getName());
        }
    }

    private void _initMultiValuedKeys() {
        Method[] methods;
        for (Method method : methods = this._configurationBeanClass.getMethods()) {
            Class<?> returnType = method.getReturnType();
            if (!returnType.equals(String[].class)) continue;
            this._multiValuedKeys.add(method.getName());
        }
    }
}

