/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.settings.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.settings.internal.util.ConfigurationPidUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.function.Consumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;

public class ConfigurationBeanManagedService
implements ManagedService {
    private final BundleContext _bundleContext;
    private final Class<?> _configurationBeanClass;
    private final Consumer<Object> _configurationBeanConsumer;
    private final AtomicMarkableReference<ServiceRegistration<?>> _configurationBeanServiceRegistrationReference = new AtomicMarkableReference<Object>(null, false);
    private final String _configurationPid;
    private ServiceRegistration<ManagedService> _managedServiceServiceRegistration;

    public ConfigurationBeanManagedService(BundleContext bundleContext, Class<?> configurationBeanClass, Consumer<Object> configurationBeanConsumer) {
        this._bundleContext = bundleContext;
        this._configurationBeanClass = configurationBeanClass;
        this._configurationBeanConsumer = configurationBeanConsumer;
        this._configurationPid = ConfigurationPidUtil.getConfigurationPid(configurationBeanClass);
    }

    public String getConfigurationPid() {
        return this._configurationPid;
    }

    public void register() {
        this._managedServiceServiceRegistration = this._bundleContext.registerService(ManagedService.class, (Object)this, (Dictionary)HashMapDictionaryBuilder.put((Object)"service.pid", (Object)this._configurationPid).build());
    }

    public void unregister() {
        ServiceRegistration<?> serviceRegistration;
        this._managedServiceServiceRegistration.unregister();
        while (!this._configurationBeanServiceRegistrationReference.compareAndSet(serviceRegistration = this._configurationBeanServiceRegistrationReference.getReference(), null, false, true)) {
        }
        serviceRegistration.unregister();
    }

    public void updated(Dictionary<String, ?> properties) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new UpdatePrivilegedAction(properties));
        } else {
            this.doUpdated(properties);
        }
    }

    protected void doUpdated(Dictionary<String, ?> properties) {
        block2: {
            ServiceRegistration<?> serviceRegistration;
            if (properties == null) {
                properties = new HashMapDictionary();
            }
            Object configurationBean = ConfigurableUtil.createConfigurable(this._configurationBeanClass, (Dictionary)properties);
            this._configurationBeanConsumer.accept(configurationBean);
            ServiceRegistration newServiceRegistration = this._bundleContext.registerService(this._configurationBeanClass.getName(), configurationBean, (Dictionary)new HashMapDictionary());
            do {
                if (!this._configurationBeanServiceRegistrationReference.isMarked()) continue;
                newServiceRegistration.unregister();
                break block2;
            } while (!this._configurationBeanServiceRegistrationReference.compareAndSet(serviceRegistration = this._configurationBeanServiceRegistrationReference.getReference(), newServiceRegistration, false, false));
            if (serviceRegistration == null) break block2;
            serviceRegistration.unregister();
        }
    }

    protected class UpdatePrivilegedAction
    implements PrivilegedAction<Void> {
        private final Dictionary<String, ?> _properties;

        @Override
        public Void run() {
            ConfigurationBeanManagedService.this.doUpdated(this._properties);
            return null;
        }

        private UpdatePrivilegedAction(Dictionary<String, ?> properties) {
            this._properties = properties;
        }
    }
}

