/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.settings.internal.scoped.configuration.admin.service;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.settings.internal.util.ConfigurationPidUtil;
import com.liferay.portal.kernel.settings.LocationVariableResolver;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class ScopedConfigurationManagedServiceFactory
implements ManagedServiceFactory {
    private final BundleContext _bundleContext;
    private final Class<?> _configurationBeanClass;
    private final Map<ScopeKey, Map<String, Object>> _configurationBeans = new ConcurrentHashMap<ScopeKey, Map<String, Object>>();
    private final String _factoryPid;
    private final LocationVariableResolver _locationVariableResolver;
    private ServiceRegistration<ManagedServiceFactory> _managedServiceFactoryServiceRegistration;
    private final Map<String, Set<ScopeKey>> _pidScopeKeys = new ConcurrentHashMap<String, Set<ScopeKey>>();

    public ScopedConfigurationManagedServiceFactory(BundleContext bundleContext, Class<?> configurationBeanClass, LocationVariableResolver locationVariableResolver) {
        this._bundleContext = bundleContext;
        this._configurationBeanClass = configurationBeanClass;
        this._locationVariableResolver = locationVariableResolver;
        this._factoryPid = ConfigurationPidUtil.getConfigurationPid(configurationBeanClass);
    }

    public void deleted(String pid) {
        this._removePidConfigurations(pid);
    }

    public Object getConfiguration(ExtendedObjectClassDefinition.Scope scope, Serializable scopePK) {
        Map<String, Object> scopeConfigurationBeans = this._configurationBeans.get(new ScopeKey(scopePK, scope));
        if (!MapUtil.isEmpty(scopeConfigurationBeans)) {
            List valuesList = ListUtil.fromCollection(scopeConfigurationBeans.values());
            return valuesList.get(valuesList.size() - 1);
        }
        return null;
    }

    public LocationVariableResolver getLocationVariableResolver() {
        return this._locationVariableResolver;
    }

    public String getName() {
        return this._factoryPid;
    }

    public void register() {
        this._managedServiceFactoryServiceRegistration = this._bundleContext.registerService(ManagedServiceFactory.class, (Object)this, (Dictionary)HashMapDictionaryBuilder.put((Object)"service.pid", (Object)(this._factoryPid + ".scoped")).build());
    }

    public void unregister() {
        this._managedServiceFactoryServiceRegistration.unregister();
    }

    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        String portletInstanceId;
        long groupId;
        long companyId = GetterUtil.getLong(properties.get(ExtendedObjectClassDefinition.Scope.COMPANY.getPropertyKey()), (long)0L);
        if (companyId != 0L) {
            this._updateEntries(pid, Long.valueOf(companyId), ExtendedObjectClassDefinition.Scope.COMPANY, properties);
        }
        if ((groupId = GetterUtil.getLong(properties.get(ExtendedObjectClassDefinition.Scope.GROUP.getPropertyKey()), (long)-1L)) != -1L) {
            this._updateEntries(pid, Long.valueOf(groupId), ExtendedObjectClassDefinition.Scope.GROUP, properties);
        }
        if (Validator.isNotNull((String)(portletInstanceId = GetterUtil.getString(properties.get(ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE.getPropertyKey()))))) {
            this._updateEntries(pid, (Serializable)((Object)portletInstanceId), ExtendedObjectClassDefinition.Scope.PORTLET_INSTANCE, properties);
        }
    }

    private void _removePidConfigurations(String pid) {
        this._pidScopeKeys.computeIfPresent(pid, (key, scopeKeys) -> {
            for (ScopeKey scopeKey : scopeKeys) {
                this._removeScopePidConfigurations(pid, scopeKey);
            }
            return null;
        });
    }

    private void _removeScopePidConfigurations(String pid, ScopeKey scopeKey) {
        this._configurationBeans.computeIfPresent(scopeKey, (key, scopeConfigurations) -> {
            scopeConfigurations.remove(pid);
            if (!scopeConfigurations.isEmpty()) {
                return scopeConfigurations;
            }
            return null;
        });
    }

    private void _updateEntries(String pid, Serializable scopePK, ExtendedObjectClassDefinition.Scope scope, Dictionary<String, ?> properties) {
        ScopeKey scopeKey = new ScopeKey(scopePK, scope);
        this._pidScopeKeys.compute(pid, (key, scopeKeys) -> {
            if (scopeKeys == null) {
                scopeKeys = new HashSet<ScopeKey>();
            }
            scopeKeys.add(scopeKey);
            return scopeKeys;
        });
        this._configurationBeans.compute(scopeKey, (key, scopeConfigurations) -> {
            if (scopeConfigurations == null) {
                scopeConfigurations = new LinkedHashMap<String, Object>();
            }
            scopeConfigurations.remove(pid);
            scopeConfigurations.put(pid, ConfigurableUtil.createConfigurable(this._configurationBeanClass, (Dictionary)properties));
            return scopeConfigurations;
        });
    }

    private class ScopeKey {
        private final ExtendedObjectClassDefinition.Scope _scope;
        private final Serializable _scopePK;

        public boolean equals(Object object) {
            if (!(object instanceof ScopeKey)) {
                return false;
            }
            ScopeKey scopeKey = (ScopeKey)object;
            return Objects.equals(this._scope, scopeKey.getScope()) && Objects.equals(this._scopePK, scopeKey.getScopePK());
        }

        public ExtendedObjectClassDefinition.Scope getScope() {
            return this._scope;
        }

        public Serializable getScopePK() {
            return this._scopePK;
        }

        public int hashCode() {
            return Objects.hash(this._scope.getValue(), this._scopePK);
        }

        private ScopeKey(Serializable scopePK, ExtendedObjectClassDefinition.Scope scope) {
            this._scopePK = scopePK;
            this._scope = scope;
        }
    }
}

