/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.test.util;

import com.liferay.osgi.util.configuration.ConfigurationFactoryUtil;
import com.liferay.osgi.util.service.OSGiServiceUtil;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Dictionary;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;

public class ConfigurationTestUtil {
    private static final BundleContext _bundleContext;

    public static String createFactoryConfiguration(String factoryPid, Dictionary<String, Object> properties) throws Exception {
        Configuration configuration = ConfigurationTestUtil._createFactoryConfiguration(factoryPid);
        ConfigurationTestUtil._updateProperties(configuration, properties);
        return configuration.getPid();
    }

    public static void deleteConfiguration(Configuration configuration) throws Exception {
        ConfigurationTestUtil._updateProperties(configuration, null);
    }

    public static void deleteConfiguration(String pid) throws Exception {
        ConfigurationTestUtil._updateProperties(ConfigurationTestUtil._getConfiguration(pid), null);
    }

    public static void deleteFactoryConfiguration(String pid, String factoryPid) throws Exception {
        Configuration configuration = ConfigurationTestUtil._getFactoryConfiguration(pid, factoryPid);
        if (configuration != null) {
            ConfigurationTestUtil._updateProperties(configuration, null);
        }
    }

    public static void saveConfiguration(Configuration configuration, Dictionary<String, Object> properties) throws Exception {
        ConfigurationTestUtil._updateProperties(configuration, properties);
    }

    public static void saveConfiguration(String pid, Dictionary<String, Object> properties) throws Exception {
        ConfigurationTestUtil._updateProperties(ConfigurationTestUtil._getConfiguration(pid), properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration updateConfiguration(String pid, UnsafeRunnable<Exception> unsafeRunnable) throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(2);
        ServiceRegistration serviceRegistration = _bundleContext.registerService(ManagedService.class, props -> countDownLatch.countDown(), MapUtil.singletonDictionary((Object)"service.pid", (Object)pid));
        unsafeRunnable.run();
        try {
            countDownLatch.await();
        }
        finally {
            serviceRegistration.unregister();
        }
        Configuration[] configurations = (Configuration[])OSGiServiceUtil.callService((BundleContext)_bundleContext, ConfigurationAdmin.class, configurationAdmin -> configurationAdmin.listConfigurations(StringBundler.concat((String[])new String[]{"(", "service.pid", "=", pid, ")"})));
        if (configurations == null || configurations.length == 0) {
            return null;
        }
        return configurations[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration updateFactoryConfiguration(String pid, UnsafeRunnable<Exception> unsafeRunnable) throws Exception {
        String factoryPid = ConfigurationFactoryUtil.getFactoryPidFromPid((String)pid);
        Assert.assertNotNull((Object)factoryPid);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ServiceRegistration serviceRegistration = _bundleContext.registerService(ManagedServiceFactory.class, (Object)new InternalManagerServiceFactory(factoryPid, (servicePid, props) -> countDownLatch.countDown()), MapUtil.singletonDictionary((Object)"service.pid", (Object)factoryPid));
        unsafeRunnable.run();
        try {
            countDownLatch.await();
        }
        finally {
            serviceRegistration.unregister();
        }
        Configuration[] configurations = (Configuration[])OSGiServiceUtil.callService((BundleContext)_bundleContext, ConfigurationAdmin.class, configurationAdmin -> configurationAdmin.listConfigurations(StringBundler.concat((String[])new String[]{"(", "service.pid", "=", pid, ")"})));
        if (configurations == null || configurations.length == 0) {
            return null;
        }
        return configurations[0];
    }

    private static Configuration _createFactoryConfiguration(String factoryPid) throws Exception {
        return (Configuration)OSGiServiceUtil.callService((BundleContext)_bundleContext, ConfigurationAdmin.class, configurationAdmin -> configurationAdmin.createFactoryConfiguration(factoryPid, "?"));
    }

    private static Configuration _getConfiguration(String pid) throws Exception {
        return (Configuration)OSGiServiceUtil.callService((BundleContext)_bundleContext, ConfigurationAdmin.class, configurationAdmin -> configurationAdmin.getConfiguration(pid, "?"));
    }

    private static Configuration _getFactoryConfiguration(String pid, String factoryPid) throws Exception {
        String tempFilterString = "(service.pid=" + pid + ")";
        if (Validator.isNotNull((String)factoryPid)) {
            tempFilterString = StringBundler.concat((String[])new String[]{"(&", tempFilterString, "(service.factoryPid=", factoryPid, "))"});
        }
        String filterString = tempFilterString;
        return (Configuration)OSGiServiceUtil.callService((BundleContext)_bundleContext, ConfigurationAdmin.class, configurationAdmin -> {
            Configuration[] configurations = configurationAdmin.listConfigurations(filterString);
            if (configurations != null) {
                return configurations[0];
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _updateProperties(Configuration configuration, Dictionary<String, Object> dictionary) throws Exception {
        CountDownLatch eventCountDownLatch = new CountDownLatch(1);
        CountDownLatch updateCountDownLatch = new CountDownLatch(2);
        String markerPID = ConfigurationTestUtil.class.getName();
        ConfigurationListener configurationListener = configurationEvent -> {
            if (markerPID.equals(configurationEvent.getPid())) {
                eventCountDownLatch.countDown();
            }
        };
        ServiceRegistration configurationListenerServiceRegistration = _bundleContext.registerService(ConfigurationListener.class, (Object)configurationListener, null);
        ManagedService managedService = properties -> {
            try {
                eventCountDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                ReflectionUtil.throwException((Throwable)interruptedException);
            }
            updateCountDownLatch.countDown();
        };
        ServiceRegistration managedServiceServiceRegistration = _bundleContext.registerService(ManagedService.class, (Object)managedService, (Dictionary)HashMapDictionaryBuilder.put((Object)"service.pid", (Object)markerPID).build());
        try {
            if (dictionary == null) {
                configuration.delete();
            } else {
                configuration.update(dictionary);
            }
            Configuration markerConfiguration = (Configuration)OSGiServiceUtil.callService((BundleContext)_bundleContext, ConfigurationAdmin.class, configurationAdmin -> configurationAdmin.getConfiguration(markerPID, "?"));
            markerConfiguration.update();
            markerConfiguration.delete();
            updateCountDownLatch.await();
        }
        finally {
            configurationListenerServiceRegistration.unregister();
            managedServiceServiceRegistration.unregister();
        }
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(ConfigurationTestUtil.class);
        _bundleContext = bundle.getBundleContext();
    }

    public static class InternalManagerServiceFactory
    implements ManagedServiceFactory {
        private final String _factoryPid;
        private final UnsafeBiConsumer<String, Dictionary<String, ?>, ConfigurationException> _unsafeBiConsumer;

        public InternalManagerServiceFactory(String factoryPid, UnsafeBiConsumer<String, Dictionary<String, ?>, ConfigurationException> unsafeBiConsumer) {
            this._factoryPid = factoryPid;
            this._unsafeBiConsumer = unsafeBiConsumer;
        }

        public void deleted(String pid) {
        }

        public String getName() {
            return this._factoryPid;
        }

        public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
            this._unsafeBiConsumer.accept((Object)pid, properties);
        }
    }
}

