/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.upgrade.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.upgrade.PrefsPropsToConfigurationUpgradeHelper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Objects;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PrefsPropsToConfigurationUpgradeHelper.class})
public class PrefsPropsToConfigurationUpgradeHelperImpl
implements PrefsPropsToConfigurationUpgradeHelper {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private PrefsProps _prefsProps;

    public void mapConfigurations(Class<?> configurationClass, KeyValuePair ... keyValuePairs) throws Exception {
        String filterString = StringBundler.concat((String[])new String[]{"(", "service.pid", "=", configurationClass.getName(), ")"});
        Configuration[] configurations = this._configurationAdmin.listConfigurations(filterString);
        if (configurations != null) {
            return;
        }
        HashMapDictionary properties = new HashMapDictionary();
        PortletPreferences portletPreferences = this._prefsProps.getPreferences();
        Object defaultConfiguration = ConfigurableUtil.createConfigurable(configurationClass, (Dictionary)properties);
        for (KeyValuePair keyValuePair : keyValuePairs) {
            String valueString = this._prefsProps.getString(keyValuePair.getKey(), null);
            if (Validator.isNull((String)valueString)) continue;
            Method method = configurationClass.getMethod(keyValuePair.getValue(), new Class[0]);
            Object defaultValueObject = method.invoke(defaultConfiguration, new Object[0]);
            Class<?> returnType = method.getReturnType();
            String[] value = null;
            if (returnType == Boolean.TYPE) {
                value = GetterUtil.getBoolean((String)valueString);
            } else if (returnType == Double.TYPE) {
                value = GetterUtil.getDouble((String)valueString);
            } else if (returnType == Integer.TYPE) {
                value = GetterUtil.getInteger((String)valueString);
            } else if (returnType == Float.TYPE) {
                value = Float.valueOf(GetterUtil.getFloat((String)valueString));
            } else if (returnType == Long.TYPE) {
                value = GetterUtil.getLong((String)valueString);
            } else if (returnType == Short.TYPE) {
                value = GetterUtil.getShort((String)valueString);
            } else if (returnType == String.class) {
                value = GetterUtil.getString((String)valueString);
            } else {
                if (returnType == String[].class) {
                    value = StringUtil.split((String)valueString);
                    if (Arrays.equals(value, (Object[])defaultValueObject)) continue;
                    this._writeProperty((Dictionary<String, Object>)properties, portletPreferences, keyValuePair, value);
                    continue;
                }
                throw new IllegalArgumentException("No valid return type found: " + method);
            }
            if (Objects.equals(value, defaultValueObject)) continue;
            this._writeProperty((Dictionary<String, Object>)properties, portletPreferences, keyValuePair, value);
        }
        if (properties.isEmpty()) {
            return;
        }
        Configuration configuration = this._configurationAdmin.getConfiguration(configurationClass.getName(), "?");
        configuration.update((Dictionary)properties);
        portletPreferences.store();
    }

    private void _writeProperty(Dictionary<String, Object> properties, PortletPreferences portletPreferences, KeyValuePair keyValuePair, Object value) {
        properties.put(keyValuePair.getValue(), value);
        if (!portletPreferences.isReadOnly(keyValuePair.getKey())) {
            try {
                portletPreferences.reset(keyValuePair.getKey());
            }
            catch (ReadOnlyException readOnlyException) {
                throw new RuntimeException(readOnlyException);
            }
        }
    }
}

