/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.partition.test.util;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.init.DBInitUtil;
import com.liferay.portal.dao.jdbc.util.ConnectionWrapper;
import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.db.partition.DBPartitionUtil;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.test.rule.AggregateTestRule;
import com.liferay.portal.kernel.test.rule.AssumeTestRule;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.test.rule.Inject;
import com.liferay.portal.test.rule.LiferayIntegrationTestRule;
import com.liferay.portal.test.rule.PermissionCheckerMethodTestRule;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;

public abstract class BaseDBPartitionTestCase {
    @ClassRule
    @Rule
    public static final AggregateTestRule aggregateTestRule = new AggregateTestRule(new TestRule[]{new AssumeTestRule("assume"), new LiferayIntegrationTestRule(), PermissionCheckerMethodTestRule.INSTANCE});
    protected static final long[] COMPANY_IDS = new long[]{123456789L, 987654321L};
    protected static final String TEST_CONTROL_TABLE_NAME = "TestControlTable";
    protected static final String TEST_CONTROL_TABLE_NEW_COLUMN = "testControlTableNewColumn";
    protected static final String TEST_INDEX_NAME = "IX_Test";
    protected static final String TEST_TABLE_NAME = "TestTable";
    protected static Connection connection;
    protected static DB db;
    protected static DBInspector dbInspector;
    @Inject
    protected static Portal portal;
    private static final boolean _DATABASE_PARTITION_MIGRATE_ENABLED;
    private static final String _DATABASE_PARTITION_SCHEMA_NAME_PREFIX = "lpartitiontest_";
    private static final DataSource _currentDataSource;
    private static boolean _dbPartitionEnabled;
    private static LazyConnectionDataSourceProxy _lazyConnectionDataSourceProxy;
    private static String _originalDatabasePartitionEnabled;
    @Inject
    private static Props _props;

    public static void assume() {
        db = DBManagerUtil.getDB();
        Assume.assumeTrue((db.getDBType() == DBType.MYSQL ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addDBPartitions() throws Exception {
        CurrentConnection defaultCurrentConnection = CurrentConnectionUtil.getCurrentConnection();
        try {
            CurrentConnection currentConnection = dataSource -> connection;
            ReflectionTestUtil.setFieldValue(CurrentConnectionUtil.class, (String)"_currentConnection", (Object)currentConnection);
            for (long companyId : COMPANY_IDS) {
                DBPartitionUtil.addDBPartition((long)companyId);
            }
        }
        finally {
            ReflectionTestUtil.setFieldValue(CurrentConnectionUtil.class, (String)"_currentConnection", (Object)defaultCurrentConnection);
        }
    }

    protected static void createControlTable(String tableName) throws Exception {
        db.runSQL("create table " + tableName + " (testColumn bigint primary key)");
    }

    protected static void createIndex(String tableName) throws Exception {
        db.runSQL(BaseDBPartitionTestCase.getCreateIndexSQL(tableName));
    }

    protected static void createTable(String tableName) throws Exception {
        db.runSQL(BaseDBPartitionTestCase.getCreateTableSQL(tableName));
    }

    protected static void createUniqueIndex(String tableName) throws Exception {
        db.runSQL(StringBundler.concat((String[])new String[]{"create unique index ", TEST_INDEX_NAME, " on ", tableName, " (testColumn)"}));
    }

    protected static void deletePartitionRequiredData() throws Exception {
        try (Statement statement = connection.createStatement();){
            for (long companyId : COMPANY_IDS) {
                try (SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)companyId);){
                    statement.execute("delete from Company where companyId = " + companyId);
                    statement.execute("delete from User_ where companyId = " + companyId);
                }
            }
        }
    }

    protected static void disableDBPartition() {
        DataAccess.cleanUp((Connection)connection);
        if (_dbPartitionEnabled) {
            return;
        }
        PropsUtil.set((String)"database.partition.enabled", (String)_originalDatabasePartitionEnabled);
        ReflectionTestUtil.setFieldValue(DBInitUtil.class, (String)"_dataSource", (Object)_currentDataSource);
        ReflectionTestUtil.setFieldValue(DBPartitionUtil.class, (String)"_DATABASE_PARTITION_SCHEMA_NAME_PREFIX", (Object)"");
        _lazyConnectionDataSourceProxy.setTargetDataSource(_currentDataSource);
        ReflectionTestUtil.setFieldValue(InfrastructureUtil.class, (String)"_dataSource", (Object)_lazyConnectionDataSourceProxy);
    }

    protected static void dropIndex(String tableName) throws Exception {
        db.runSQL(StringBundler.concat((String[])new String[]{"drop index ", TEST_INDEX_NAME, " on ", tableName}));
    }

    protected static void dropSchemas() throws Exception {
        for (long companyId : COMPANY_IDS) {
            db.runSQL("drop schema if exists " + BaseDBPartitionTestCase.getSchemaName(companyId));
        }
    }

    protected static void dropTable(String tableName) throws Exception {
        db.runSQL("drop table if exists " + tableName);
    }

    protected static void enableDBPartition() throws Exception {
        CompanyThreadLocal.setCompanyId((Long)PortalInstances.getDefaultCompanyId());
        _dbPartitionEnabled = DBPartition.isPartitionEnabled();
        if (_dbPartitionEnabled) {
            return;
        }
        _originalDatabasePartitionEnabled = PropsUtil.get((String)"database.partition.enabled");
        PropsUtil.set((String)"database.partition.enabled", (String)"true");
        ReflectionTestUtil.setFieldValue(DBPartitionUtil.class, (String)"_DATABASE_PARTITION_SCHEMA_NAME_PREFIX", (Object)_DATABASE_PARTITION_SCHEMA_NAME_PREFIX);
        ReflectionTestUtil.setFieldValue(DBPartitionUtil.class, (String)"_DATABASE_PARTITION_THREAD_POOL_ENABLED", (Object)true);
        DBPartitionUtil.setDefaultCompanyId((long)portal.getDefaultCompanyId());
        DataSource dbPartitionDataSource = BaseDBPartitionTestCase._wrapDataSource(DBPartitionUtil.wrapDataSource((DataSource)_currentDataSource));
        _lazyConnectionDataSourceProxy = (LazyConnectionDataSourceProxy)PortalBeanLocatorUtil.locate((String)"liferayDataSource");
        _lazyConnectionDataSourceProxy.setTargetDataSource(dbPartitionDataSource);
        ReflectionTestUtil.setFieldValue(DBInitUtil.class, (String)"_dataSource", (Object)dbPartitionDataSource);
        ReflectionTestUtil.setFieldValue(InfrastructureUtil.class, (String)"_dataSource", (Object)_lazyConnectionDataSourceProxy);
        connection = DataAccess.getConnection();
        dbInspector = new DBInspector(connection);
    }

    protected static String getCreateIndexSQL(String tableName) {
        return StringBundler.concat((String[])new String[]{"create index ", TEST_INDEX_NAME, " on ", tableName, " (testColumn)"});
    }

    protected static String getCreateTableSQL(String tableName) {
        return "create table " + tableName + " (testColumn bigint primary key, companyId bigint)";
    }

    protected static String getSchemaName(long companyId) {
        if (_dbPartitionEnabled) {
            return (String)ReflectionTestUtil.getFieldValue(DBPartitionUtil.class, (String)"_DATABASE_PARTITION_SCHEMA_NAME_PREFIX") + companyId;
        }
        return _DATABASE_PARTITION_SCHEMA_NAME_PREFIX + companyId;
    }

    protected static void insertPartitionRequiredData() throws Exception {
        for (long companyId : COMPANY_IDS) {
            try (SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)companyId);
                 PreparedStatement preparedStatement1 = connection.prepareStatement("insert into Company (companyId, webId) values (?, ?)");
                 PreparedStatement preparedStatement2 = connection.prepareStatement("insert into User_ (userId, companyId, screenName, emailAddress, languageId, timeZoneId, type_) values (?, ?, ?, ?, ?, ?, ?)");){
                preparedStatement1.setLong(1, companyId);
                preparedStatement1.setString(2, "Test" + companyId);
                preparedStatement1.executeUpdate();
                preparedStatement2.setLong(1, 1L);
                preparedStatement2.setLong(2, companyId);
                preparedStatement2.setString(3, "Test");
                preparedStatement2.setString(4, "test@test.com");
                preparedStatement2.setString(5, "en_US");
                preparedStatement2.setString(6, "UTC");
                preparedStatement2.setInt(7, 0);
                preparedStatement2.executeUpdate();
            }
        }
    }

    protected static void removeDBPartitions(boolean migrate) throws Exception {
        BaseDBPartitionTestCase.removeDBPartitions(COMPANY_IDS, migrate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeDBPartitions(long[] companyIds, boolean migrate) throws Exception {
        CurrentConnection defaultCurrentConnection = CurrentConnectionUtil.getCurrentConnection();
        try {
            CurrentConnection currentConnection = dataSource -> connection;
            ReflectionTestUtil.setFieldValue(CurrentConnectionUtil.class, (String)"_currentConnection", (Object)currentConnection);
            ReflectionTestUtil.setFieldValue(DBPartitionUtil.class, (String)"_DATABASE_PARTITION_MIGRATE_ENABLED", (Object)migrate);
            for (long companyId : companyIds) {
                DBPartitionUtil.removeDBPartition((long)companyId);
            }
        }
        finally {
            ReflectionTestUtil.setFieldValue(CurrentConnectionUtil.class, (String)"_currentConnection", (Object)defaultCurrentConnection);
            ReflectionTestUtil.setFieldValue(DBPartitionUtil.class, (String)"_DATABASE_PARTITION_MIGRATE_ENABLED", (Object)_DATABASE_PARTITION_MIGRATE_ENABLED);
        }
    }

    protected void createAndPopulateControlTable(String tableName) throws Exception {
        try (Statement statement = connection.createStatement();){
            statement.execute("create table " + tableName + " (testColumn bigint primary key)");
            statement.execute("insert into " + tableName + " values (1)");
        }
    }

    protected void createAndPopulateTable(String tableName) throws Exception {
        try (Statement statement = connection.createStatement();){
            statement.execute(BaseDBPartitionTestCase.getCreateTableSQL(tableName));
            statement.execute(StringBundler.concat((Object[])new Object[]{"insert into ", tableName, " values (1, ", CompanyThreadLocal.getCompanyId(), ")"}));
        }
    }

    private static DataSource _wrapDataSource(DataSource dataSource) {
        return new DataSourceWrapper(dataSource){

            public Connection getConnection() throws SQLException {
                return this._wrapConnection(super.getConnection());
            }

            public Connection getConnection(String userName, String password) throws SQLException {
                return this._wrapConnection(super.getConnection());
            }

            private Connection _wrapConnection(Connection connection) {
                return new ConnectionWrapper(connection){

                    public void close() throws SQLException {
                        String defaultSchemaName = (String)ReflectionTestUtil.getFieldValue(DBPartitionUtil.class, (String)"_defaultSchemaName");
                        this.setCatalog(defaultSchemaName);
                        super.close();
                    }
                };
            }
        };
    }

    static {
        _DATABASE_PARTITION_MIGRATE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"database.partition.migrate.enabled"));
        _currentDataSource = (DataSource)ReflectionTestUtil.getFieldValue(DBInitUtil.class, (String)"_dataSource");
    }
}

