/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.partition.internal.instance.lifecycle;

import com.liferay.portal.configuration.persistence.ReloadablePersistenceManager;
import com.liferay.portal.db.partition.util.DBPartitionUtil;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.util.PortalInstances;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class ConfigurationPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final HashMap<Long, List<String>> _configurationMap = new HashMap();
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ReloadablePersistenceManager _reloadablePersistenceManager;

    public void portalInstancePreunregistered(Company company) throws Exception {
        if (!DBPartition.isPartitionEnabled()) {
            return;
        }
        _configurationMap.remove(company.getCompanyId());
        List pids = DBPartitionUtil.getConfigurationPids((long)company.getCompanyId());
        _configurationMap.put(company.getCompanyId(), pids);
    }

    public void portalInstanceRegistered(Company company) throws Exception {
        if (!DBPartition.isPartitionEnabled() || !PortalInstances.isCompanyInCopyProcess() && !PortalInstances.isCompanyInInsertionProcess()) {
            return;
        }
        if (PortalInstances.isCompanyInInsertionProcess()) {
            Map configurations = DBPartitionUtil.getConfigurations((long)company.getCompanyId());
            for (String configurationId : configurations.keySet()) {
                this._reloadablePersistenceManager.reload(configurationId);
            }
            return;
        }
        Map configurations = DBPartitionUtil.getConfigurations((long)PortalInstances.getCopyInProcessCompanyId());
        for (Map.Entry entry : configurations.entrySet()) {
            String dictionaryString = (String)entry.getValue();
            Dictionary dictionary = ConfigurationHandler.read((InputStream)new UnsyncByteArrayInputStream(dictionaryString.getBytes("UTF-8")));
            if (dictionary.get("service.factoryPid") == null) continue;
            if (dictionary.get("companyId") != null) {
                dictionary.put("companyId", company.getCompanyId());
            }
            Configuration configuration = this._configurationAdmin.createFactoryConfiguration((String)dictionary.get("service.factoryPid"), "?");
            dictionary.put("service.pid", configuration.getPid());
            configuration.update(dictionary);
        }
    }

    public void portalInstanceUnregistered(Company company) throws Exception {
        if (!DBPartition.isPartitionEnabled() || MapUtil.isEmpty(_configurationMap)) {
            return;
        }
        for (String pid : _configurationMap.get(company.getCompanyId())) {
            Configuration configuration = this._configurationAdmin.getConfiguration(pid, "?");
            if (configuration == null) continue;
            configuration.delete();
        }
        _configurationMap.remove(company.getCompanyId());
    }
}

