/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.partition.internal.messaging;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.db.partition.internal.configuration.DBPartitionConfiguration;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusInterceptor;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.util.PortalInstances;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.db.partition.internal.configuration.DBPartitionConfiguration"}, service={MessageBusInterceptor.class})
public class DBPartitionMessageBusInterceptor
implements MessageBusInterceptor {
    @Reference
    private CompanyLocalService _companyLocalService;
    private volatile Set<String> _excludedMessageBusDestinationNames;
    private volatile Set<String> _excludedSchedulerJobNames;

    public boolean intercept(MessageBus messageBus, String destinationName, Message message) {
        if (DBPartition.isPartitionEnabled() && message.getLong("companyId") == 0L && !this._excludedMessageBusDestinationNames.contains(destinationName) && !this._excludedSchedulerJobNames.contains(message.getString("JOB_NAME"))) {
            ArrayList companyIds = new ArrayList();
            this._companyLocalService.forEachCompany(company -> {
                if (!company.isActive() || PortalInstances.isCompanyInDeletionProcess((long)company.getCompanyId())) {
                    return;
                }
                companyIds.add(company.getCompanyId());
            });
            message.remove("companyId");
            message.put("companyIds", (Object)companyIds.toArray(new Long[0]));
        }
        return false;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        DBPartitionConfiguration dbPartitionConfiguration = (DBPartitionConfiguration)ConfigurableUtil.createConfigurable(DBPartitionConfiguration.class, properties);
        this._excludedMessageBusDestinationNames = SetUtil.fromArray((Object[])dbPartitionConfiguration.excludedMessageBusDestinationNames());
        this._excludedSchedulerJobNames = SetUtil.fromArray((Object[])dbPartitionConfiguration.excludedSchedulerJobNames());
    }
}

