/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.partition.internal.operation;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.db.partition.internal.configuration.DBPartitionExtractVirtualInstanceConfiguration;
import com.liferay.portal.db.partition.internal.operation.BaseVirtualInstanceOperation;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.db.partition.internal.configuration.DBPartitionExtractVirtualInstanceConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, enabled=false, service={})
public class DBPartitionExtractVirtualInstanceOperation
extends BaseVirtualInstanceOperation {
    private static final Log _log = LogFactoryUtil.getLog(DBPartitionExtractVirtualInstanceOperation.class);
    @Reference
    private CompanyLocalService _companyLocalService;

    @Override
    public String getOperationCompletedMessage(long companyId) {
        return "Virtual instance with company ID " + companyId + " extracted successfully";
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.onVirtualInstance(() -> {
            DBPartitionExtractVirtualInstanceConfiguration dBPartitionExtractVirtualInstanceConfiguration = (DBPartitionExtractVirtualInstanceConfiguration)ConfigurableUtil.createConfigurable(DBPartitionExtractVirtualInstanceConfiguration.class, (Map)properties);
            long companyId = dBPartitionExtractVirtualInstanceConfiguration.partitionCompanyId();
            if (this._companyLocalService.fetchCompany(companyId) == null) {
                _log.error((Object)("Virtual instance with company ID " + companyId + " does not exist"));
                return null;
            }
            return this._companyLocalService.extractDBPartitionCompany(companyId);
        }, properties);
    }
}

