/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.schema.definition.internal.exporter;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.db.schema.definition.internal.configuration.DBSchemaDefinitionExporterConfiguration;
import com.liferay.portal.db.schema.definition.internal.sql.writer.SQLWriter;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.patcher.PatcherValues;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.db.schema.definition.internal.configuration.DBSchemaDefinitionExporterConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class DBSchemaDefinitionExporter {
    private static final Log _log = LogFactoryUtil.getLog(DBSchemaDefinitionExporter.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ReleaseLocalService _releaseLocalService;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._exportDBSchemaDefinition(properties);
    }

    private void _deleteConfiguration(String pid) {
        try {
            Path path = Paths.get(PropsValues.MODULE_FRAMEWORK_CONFIGS_DIR, pid.concat(".config"));
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            } else {
                Configuration[] configurations = this._configurationAdmin.listConfigurations(StringBundler.concat((String[])new String[]{"(", "service.pid", "=", pid, "*)"}));
                if (configurations == null) {
                    return;
                }
                for (Configuration configuration : configurations) {
                    configuration.delete();
                }
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _exportDBSchemaDefinition(Map<String, Object> properties) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Start database schema definition export");
        }
        try {
            DBSchemaDefinitionExporterConfiguration dbSchemaDefinitionExporterConfiguration = (DBSchemaDefinitionExporterConfiguration)ConfigurableUtil.createConfigurable(DBSchemaDefinitionExporterConfiguration.class, properties);
            DBType dbType = DBType.valueOf((String)StringUtil.toUpperCase((String)dbSchemaDefinitionExporterConfiguration.databaseType()));
            SQLWriter sqlWriter = new SQLWriter(dbType);
            File file = new File(dbSchemaDefinitionExporterConfiguration.path());
            sqlWriter.writeFiles(file);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Finished database schema definition export to " + file.getAbsolutePath()));
            }
            this._generateReport(dbSchemaDefinitionExporterConfiguration.path(), dbType);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to export database schema definition", (Throwable)exception);
        }
        finally {
            this._deleteConfiguration((String)properties.get("service.pid"));
        }
    }

    private void _generateReport(String dirName, DBType exportDBType) throws Exception {
        String installedPatchNames = StringUtil.merge((Object[])PatcherValues.INSTALLED_PATCH_NAMES, (String)", ");
        Release release = this._releaseLocalService.fetchRelease("portal");
        FileUtil.write((File)new File(dirName, "db_schema_definition_export_report.txt"), (String)StringUtil.merge((Object[])new Object[]{"Export date: " + this._toString(new Date()), "Portal build date: " + this._toString(release.getBuildDate()), "Portal build number: " + release.getBuildNumber(), "Portal installed patches: " + installedPatchNames, "Portal schema version: " + release.getSchemaVersion(), "\n", "Database type: " + DBManagerUtil.getDBType(), "Export database type: " + exportDBType, "\n", this._getTablesInfo(dirName)}, (String)"\n"));
    }

    private Set<String> _getDBTableNames(String type) throws Exception {
        HashSet<String> tableNames = new HashSet<String>();
        DataSource dataSource = InfrastructureUtil.getDataSource();
        try (Connection connection = dataSource.getConnection();){
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTables(connection.getCatalog(), connection.getSchema(), null, new String[]{type});){
                while (resultSet.next()) {
                    tableNames.add(StringUtil.toLowerCase((String)resultSet.getString("TABLE_NAME")));
                }
            }
        }
        return tableNames;
    }

    private Set<String> _getExportTableNames(long companyId, String dirName, String type) throws Exception {
        String[] lines;
        HashSet<String> tableNames = new HashSet<String>();
        String prefix = "";
        if (companyId != PortalInstancePool.getDefaultCompanyId()) {
            prefix = companyId + "_";
        }
        String content = StringUtil.toLowerCase((String)FileUtil.read((File)new File(dirName, prefix + "tables.sql")));
        for (String line : lines = StringUtil.split((String)content, (String)"\n")) {
            if (type.equals("TABLE") && StringUtil.startsWith((String)line, (String)"create table")) {
                String[] parts = line.split(" ");
                String tableName = StringUtil.extractLast((String)parts[2], (String)".");
                tableNames.add(tableName == null ? parts[2] : tableName);
                continue;
            }
            if (!type.equals("VIEW") || !StringUtil.startsWith((String)line, (String)"create or replace view")) continue;
            tableNames.add(StringUtil.extractLast((String)line.split(" ")[4], (String)"."));
        }
        return tableNames;
    }

    private String _getTablesInfo(long companyId, String dirName, String message, String type) throws Exception {
        Set<String> dbTableNames = this._getDBTableNames(type);
        Set<String> exportTableNames = this._getExportTableNames(companyId, dirName, type);
        String missingTableNames = StringUtil.merge((Collection)SetUtil.asymmetricDifference(dbTableNames, exportTableNames), (String)", ");
        return StringUtil.merge((Object[])new Object[]{StringUtil.replace((String)message, (char)'?', (String)"database") + dbTableNames.size(), StringUtil.replace((String)message, (char)'?', (String)"export") + exportTableNames.size(), StringUtil.replace((String)message, (char)'?', (String)"missing") + missingTableNames, "\n"}, (String)"\n");
    }

    private String _getTablesInfo(String dirName) throws Exception {
        if (!DBPartition.isPartitionEnabled()) {
            return this._getTablesInfo(PortalInstancePool.getDefaultCompanyId(), dirName, "Portal ? tables: ", "TABLE");
        }
        StringBundler sb = new StringBundler(this._getTablesInfo(PortalInstancePool.getDefaultCompanyId(), dirName, "Default virtual instance ? tables: ", "TABLE"));
        this._companyLocalService.forEachCompanyId(companyId -> {
            if (companyId == PortalInstancePool.getDefaultCompanyId()) {
                return;
            }
            sb.append("\n");
            sb.append(this._getTablesInfo((long)companyId, dirName, StringBundler.concat((Object[])new Object[]{"Virtual instance ", companyId, " ? tables: "}), "TABLE"));
            sb.append(this._getTablesInfo((long)companyId, dirName, StringBundler.concat((Object[])new Object[]{"Virtual instance ", companyId, " ? views: "}), "VIEW"));
        });
        return sb.toString();
    }

    private String _toString(Date date) {
        return Time.getSimpleDate((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ssZ");
    }
}

