/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.schema.definition.internal.sql.provider;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.db.DBResourceUtil;
import com.liferay.portal.db.schema.definition.internal.sql.provider.SQLProvider;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactory;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.upgrade.release.SchemaCreator;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceLoader;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class BaseSQLProvider
implements SQLProvider {
    protected final DB db;
    private final StringBundler _indexesSQLSB = new StringBundler();
    private final StringBundler _tablesSQLSB = new StringBundler();

    public BaseSQLProvider(DBType dbType) throws Exception {
        this.db = this._getDB(dbType);
        this._appendPortalSQL();
        this._appendModulesSQL();
        this._appendPluginsSQL();
    }

    @Override
    public String getIndexesSQL() {
        return this._indexesSQLSB.toString();
    }

    @Override
    public String getTablesSQL() {
        return this._tablesSQLSB.toString();
    }

    private void _appendModulesSQL() throws Exception {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        Collection serviceReferences = bundleContext.getServiceReferences(SchemaCreator.class, null);
        for (ServiceReference serviceReference : serviceReferences) {
            this._appendSQL(DBResourceUtil.getModuleIndexesSQL((Bundle)serviceReference.getBundle()), DBResourceUtil.getModuleTablesSQL((Bundle)serviceReference.getBundle()));
        }
    }

    private void _appendPluginsSQL() throws Exception {
        HashSet<String> contextNames = new HashSet<String>();
        for (PluginPackage pluginPackage : PluginPackageUtil.getInstalledPluginPackages()) {
            String contextName = pluginPackage.getArtifactId();
            if (!contextNames.add(contextName)) continue;
            this._appendSQL(this._read(contextName, "/WEB-INF/sql/indexes.sql"), this._read(contextName, "/WEB-INF/sql/tables.sql"));
        }
    }

    private void _appendPortalSQL() throws Exception {
        this._appendSQL(DBResourceUtil.getPortalIndexesSQL(), DBResourceUtil.getPortalTablesSQL());
    }

    private void _appendSQL(String indexesSQL, String tablesSQL) throws Exception {
        if (Validator.isNotNull((String)indexesSQL)) {
            this._indexesSQLSB.append(this.db.buildSQL(indexesSQL));
        }
        if (Validator.isNotNull((String)tablesSQL)) {
            this._tablesSQLSB.append(this.db.buildSQL(tablesSQL));
        }
    }

    private DB _getDB(DBType dbType) {
        ServiceLoader<DBFactory> serviceLoader = ServiceLoader.load(DBFactory.class, DBFactory.class.getClassLoader());
        for (DBFactory dbFactory : serviceLoader) {
            if (dbFactory.getDBType() != dbType) continue;
            return dbFactory.create(0, 0);
        }
        throw new IllegalArgumentException("Database type " + dbType);
    }

    private String _read(String contextName, String path) throws Exception {
        ServletContext servletContext = ServletContextPool.get((String)contextName);
        if (servletContext == null) {
            return null;
        }
        InputStream inputStream = servletContext.getResourceAsStream(path);
        if (inputStream == null) {
            return null;
        }
        return StringUtil.read((InputStream)inputStream);
    }
}

