/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.schema.definition.internal.sql.provider;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionLocalizationTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionLocalizationTableFactory;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTableFactory;
import com.liferay.object.petra.sql.dsl.DynamicObjectRelationshipMappingTable;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.service.ObjectDefinitionLocalServiceUtil;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFieldLocalServiceUtil;
import com.liferay.object.service.ObjectRelationshipLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.db.schema.definition.internal.sql.provider.SQLProvider;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class ObjectSQLProvider
implements SQLProvider {
    private final long _companyId;
    private final DB _db;
    private final StringBundler _indexesSQLSB = new StringBundler();
    private final Set<String> _tableNames = new HashSet<String>();
    private final StringBundler _tablesSQLSB = new StringBundler();

    public ObjectSQLProvider(long companyId, DB db) throws Exception {
        this._companyId = companyId;
        this._db = db;
        this._appendSQL();
    }

    @Override
    public String getIndexesSQL() {
        return this._indexesSQLSB.toString();
    }

    @Override
    public String getTablesSQL() {
        return this._tablesSQLSB.toString();
    }

    private void _appendIndexesSQL() throws Exception {
        DataSource dataSource = InfrastructureUtil.getDataSource();
        DB sourceDB = DBManagerUtil.getDB();
        try (Connection connection = dataSource.getConnection();){
            for (String tableName : this._tableNames) {
                for (IndexMetadata indexMetadata : sourceDB.getIndexMetadatas(connection, tableName, null, false)) {
                    this._indexesSQLSB.append(indexMetadata.getCreateSQL(null));
                    this._indexesSQLSB.append("\n");
                }
            }
        }
    }

    private void _appendRelationshipTablesSQL(ObjectDefinition objectDefinition) throws Exception {
        List objectRelationships = ObjectRelationshipLocalServiceUtil.getAllObjectRelationships((long)objectDefinition.getObjectDefinitionId());
        for (ObjectRelationship objectRelationship : objectRelationships) {
            if (!StringUtil.equalsIgnoreCase((String)objectRelationship.getType(), (String)"manyToMany") || this._tableNames.contains(objectRelationship.getDBTableName())) continue;
            Map pkObjectFieldDBColumnNames = ObjectRelationshipUtil.getPKObjectFieldDBColumnNames((ObjectDefinition)ObjectDefinitionLocalServiceUtil.getObjectDefinition((long)objectRelationship.getObjectDefinitionId1()), (ObjectDefinition)ObjectDefinitionLocalServiceUtil.getObjectDefinition((long)objectRelationship.getObjectDefinitionId2()), (boolean)false);
            String pkObjectFieldDBColumnName1 = (String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName1");
            String pkObjectFieldDBColumnName2 = (String)pkObjectFieldDBColumnNames.get("pkObjectFieldDBColumnName2");
            DynamicObjectRelationshipMappingTable dynamicObjectRelationshipMappingTable = new DynamicObjectRelationshipMappingTable(pkObjectFieldDBColumnName1, pkObjectFieldDBColumnName2, objectRelationship.getDBTableName());
            this._appendTableSQL(dynamicObjectRelationshipMappingTable.getCreateTableSQL(), dynamicObjectRelationshipMappingTable.getTableName());
        }
    }

    private void _appendSQL() throws Exception {
        List objectDefinitions = ObjectDefinitionLocalServiceUtil.getObjectDefinitions((long)this._companyId, (int)0);
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            this._appendTablesSQL(objectDefinition);
            this._appendRelationshipTablesSQL(objectDefinition);
        }
        if (this._tablesSQLSB.index() > 0) {
            this._tablesSQLSB.setIndex(this._tablesSQLSB.index() - 1);
        }
        this._appendIndexesSQL();
    }

    private void _appendTableSQL(String sql, String tableName) throws Exception {
        this._tableNames.add(tableName);
        this._tablesSQLSB.append(this._db.buildSQL(sql));
        this._tablesSQLSB.append("\n");
    }

    private void _appendTablesSQL(ObjectDefinition objectDefinition) throws Exception {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable;
        DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable = DynamicObjectDefinitionLocalizationTableFactory.create((ObjectDefinition)objectDefinition, (ObjectFieldLocalService)ObjectFieldLocalServiceUtil.getService());
        if (dynamicObjectDefinitionLocalizationTable != null) {
            this._appendTableSQL(dynamicObjectDefinitionLocalizationTable.getCreateTableSQL(), dynamicObjectDefinitionLocalizationTable.getTableName());
        }
        if (!objectDefinition.isUnmodifiableSystemObject()) {
            dynamicObjectDefinitionTable = DynamicObjectDefinitionTableFactory.create((ObjectDefinition)objectDefinition, (ObjectFieldLocalService)ObjectFieldLocalServiceUtil.getService());
            this._appendTableSQL(dynamicObjectDefinitionTable.getCreateTableSQL(), dynamicObjectDefinitionTable.getTableName());
        }
        dynamicObjectDefinitionTable = DynamicObjectDefinitionTableFactory.createExtension((ObjectDefinition)objectDefinition, (ObjectFieldLocalService)ObjectFieldLocalServiceUtil.getService());
        this._appendTableSQL(dynamicObjectDefinitionTable.getCreateTableSQL(), dynamicObjectDefinitionTable.getTableName());
    }
}

