/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.equinox.log.bridge.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleStartStopLogger
implements SynchronousBundleListener {
    private static final Logger _log = LoggerFactory.getLogger(BundleStartStopLogger.class);
    private final AtomicBoolean _portalStarted;

    public BundleStartStopLogger(AtomicBoolean portalStarted) {
        this._portalStarted = portalStarted;
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle = bundleEvent.getBundle();
        if (bundle.getSymbolicName() == null) {
            _log.error("{} has a null symbolic name", (Object)bundle.getLocation());
        }
        if (this._portalStarted.get()) {
            if (_log.isInfoEnabled()) {
                if (bundleEvent.getType() == 2) {
                    _log.info("STARTED {}", (Object)bundle);
                } else if (bundleEvent.getType() == 4) {
                    _log.info("STOPPED {}", (Object)bundle);
                }
            }
        } else if (_log.isDebugEnabled()) {
            if (bundleEvent.getType() == 2) {
                _log.debug("STARTED {}", (Object)bundle);
            } else if (bundleEvent.getType() == 4) {
                _log.debug("STOPPED {}", (Object)bundle);
            }
        }
    }
}

