/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.executor.internal;

import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.concurrent.NoticeableThreadPoolExecutor;
import com.liferay.petra.concurrent.ThreadPoolHandler;
import com.liferay.petra.concurrent.ThreadPoolHandlerAdapter;
import com.liferay.petra.executor.PortalExecutorConfig;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={PortalExecutorManager.class})
public class DefaultPortalExecutorManager
implements PortalExecutorManager {
    public static final String DEFAULT_CONFIG_NAME = "default";
    private final PortalExecutorConfig _defaultPortalExecutorConfig = new PortalExecutorConfig("default", 1, 10, 60L, TimeUnit.SECONDS, Integer.MAX_VALUE, (ThreadFactory)new NamedThreadFactory("default", 5, PortalClassLoaderUtil.getClassLoader()), (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy(), (ThreadPoolHandler)new ThreadPoolHandlerAdapter(){

        public void afterExecute(Runnable runnable, Throwable throwable) {
            CentralizedThreadLocal.clearShortLivedThreadLocals();
        }
    });
    private final ConcurrentMap<String, NoticeableExecutorService> _noticeableExecutorServices = new ConcurrentHashMap<String, NoticeableExecutorService>();
    private final ConcurrentMap<String, PortalExecutorConfig> _portalExecutorConfigs = new ConcurrentHashMap<String, PortalExecutorConfig>();

    public NoticeableExecutorService getPortalExecutor(String name) {
        return this.getPortalExecutor(name, true);
    }

    public NoticeableExecutorService getPortalExecutor(String name, boolean createIfAbsent) {
        NoticeableExecutorService previousNoticeableExecutorService;
        NoticeableExecutorService noticeableExecutorService = (NoticeableExecutorService)this._noticeableExecutorServices.get(name);
        if (noticeableExecutorService == null && createIfAbsent && (previousNoticeableExecutorService = this.registerPortalExecutor(name, noticeableExecutorService = this._createPortalExecutor(name))) != null) {
            noticeableExecutorService.shutdown();
            noticeableExecutorService = previousNoticeableExecutorService;
        }
        return noticeableExecutorService;
    }

    public NoticeableExecutorService registerPortalExecutor(String name, NoticeableExecutorService noticeableExecutorService) {
        NoticeableExecutorService previousNoticeableExecutorService = this._noticeableExecutorServices.putIfAbsent(name, noticeableExecutorService);
        if (previousNoticeableExecutorService == null) {
            NoticeableFuture terminationNoticeableFuture = noticeableExecutorService.terminationNoticeableFuture();
            terminationNoticeableFuture.addFutureListener(future -> {
                NoticeableExecutorService cfr_ignored_0 = (NoticeableExecutorService)this._noticeableExecutorServices.remove(name);
            });
        }
        return previousNoticeableExecutorService;
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean interrupt) {
        for (NoticeableExecutorService noticeableExecutorService : this._noticeableExecutorServices.values()) {
            if (interrupt) {
                noticeableExecutorService.shutdownNow();
                continue;
            }
            noticeableExecutorService.shutdown();
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addPortalExecutorConfig(PortalExecutorConfig portalExecutorConfig) {
        this._portalExecutorConfigs.putIfAbsent(portalExecutorConfig.getName(), portalExecutorConfig);
    }

    @Deactivate
    protected void deactivate() {
        this.shutdown(true);
    }

    protected void removePortalExecutorConfig(PortalExecutorConfig portalExecutorConfig) {
        this._portalExecutorConfigs.remove(portalExecutorConfig.getName(), portalExecutorConfig);
    }

    private NoticeableExecutorService _createPortalExecutor(String executorName) {
        PortalExecutorConfig portalExecutorConfig = this._getPortalExecutorConfig(executorName);
        return new NoticeableThreadPoolExecutor(portalExecutorConfig.getCorePoolSize(), portalExecutorConfig.getMaxPoolSize(), portalExecutorConfig.getKeepAliveTime(), portalExecutorConfig.getTimeUnit(), new LinkedBlockingQueue(portalExecutorConfig.getMaxQueueSize()), portalExecutorConfig.getThreadFactory(), portalExecutorConfig.getRejectedExecutionHandler(), portalExecutorConfig.getThreadPoolHandler());
    }

    private PortalExecutorConfig _getPortalExecutorConfig(String name) {
        PortalExecutorConfig portalExecutorConfig = (PortalExecutorConfig)this._portalExecutorConfigs.get(name);
        if (portalExecutorConfig != null) {
            return portalExecutorConfig;
        }
        return this._portalExecutorConfigs.getOrDefault(DEFAULT_CONFIG_NAME, this._defaultPortalExecutorConfig);
    }
}

