/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.properties;

import com.liferay.portal.file.install.properties.CFGProperties;
import com.liferay.portal.file.install.properties.ConfigurationProperties;
import com.liferay.portal.file.install.properties.TypedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;

public class ConfigurationPropertiesFactory {
    public static ConfigurationProperties create(File file, String encoding) throws IOException {
        ConfigurationProperties configurationProperties = null;
        String fileName = file.getName();
        if (fileName.endsWith("cfg")) {
            configurationProperties = new CFGProperties();
        } else if (fileName.endsWith("config")) {
            configurationProperties = new TypedProperties();
        } else {
            throw new IllegalArgumentException("Unknown configuration type: " + file);
        }
        try (FileInputStream inputStream = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)inputStream, encoding);){
            configurationProperties.load(reader);
        }
        return configurationProperties;
    }

    public static ConfigurationProperties create(String fileName, String content, String encoding) throws IOException {
        ConfigurationProperties configurationProperties = null;
        if (fileName.endsWith("cfg")) {
            configurationProperties = new CFGProperties();
        } else if (fileName.endsWith("config")) {
            configurationProperties = new TypedProperties();
        } else {
            throw new IllegalArgumentException("Unknown configuration type: " + fileName);
        }
        try (StringReader reader = new StringReader(content);){
            configurationProperties.load(reader);
        }
        return configurationProperties;
    }
}

