/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.concurrent.DefaultNoticeableFuture;
import com.liferay.petra.io.BigEndianCodec;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.file.install.FileInstaller;
import com.liferay.portal.file.install.internal.Artifact;
import com.liferay.portal.file.install.internal.Scanner;
import com.liferay.portal.file.install.internal.Util;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ModuleFrameworkPropsValues;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DirectoryWatcher
extends Thread
implements BundleListener {
    private static final Log _log = LogFactoryUtil.getLog(DirectoryWatcher.class);
    private final Map<Long, Long> _bundleChecksums = new HashMap<Long, Long>();
    private final BundleContext _bundleContext;
    private final RandomAccessFile _checksumRandomAccessFile;
    private final Set<Bundle> _consistentlyFailingBundles = new HashSet<Bundle>();
    private final Map<File, Artifact> _currentManagedArtifacts = new HashMap<File, Artifact>();
    private final Set<Bundle> _delayedStart = new HashSet<Bundle>();
    private final ServiceTrackerList<FileInstaller> _fileInstallers;
    private final FilenameFilter _filenameFilter;
    private int _frameworkStartLevel;
    private final Map<File, Artifact> _installationFailures = new HashMap<File, Artifact>();
    private final Set<File> _processingFailures = new HashSet<File>();
    private final Scanner _scanner;
    private final AtomicBoolean _stateChanged = new AtomicBoolean();
    private final Bundle _systemBundle;
    private final List<String> _watchedDirPaths = new ArrayList<String>();
    private final List<File> _watchedDirs = new ArrayList<File>();

    public DirectoryWatcher(BundleContext bundleContext) throws IOException {
        super("fileinstall-directory-watcher");
        this.setDaemon(true);
        this._bundleContext = bundleContext;
        Bundle bundle = bundleContext.getBundle();
        this._checksumRandomAccessFile = new RandomAccessFile(bundle.getDataFile("bundles.checksum"), "rw");
        long length = this._checksumRandomAccessFile.length();
        if (length > 0L) {
            int entryCount = (int)(length / 16L);
            byte[] bytes = new byte[entryCount * 16];
            this._checksumRandomAccessFile.readFully(bytes);
            int index = 0;
            for (int i = 0; i < entryCount; ++i) {
                this._bundleChecksums.put(BigEndianCodec.getLong((byte[])bytes, (int)index), BigEndianCodec.getLong((byte[])bytes, (int)(index + 8)));
                index += 16;
            }
            ArrayList<Long> currentBundleIds = new ArrayList<Long>();
            for (Bundle currentBundle : bundleContext.getBundles()) {
                currentBundleIds.add(currentBundle.getBundleId());
            }
            Set<Long> checksumBundleIds = this._bundleChecksums.keySet();
            checksumBundleIds.retainAll(currentBundleIds);
            int actualEntryCount = this._bundleChecksums.size();
            if (actualEntryCount < entryCount) {
                index = 0;
                for (Map.Entry<Long, Long> entry : this._bundleChecksums.entrySet()) {
                    BigEndianCodec.putLong((byte[])bytes, (int)index, (long)entry.getKey());
                    BigEndianCodec.putLong((byte[])bytes, (int)(index + 8), (long)entry.getValue());
                    index += 16;
                }
                this._checksumRandomAccessFile.seek(0L);
                int fileSize = actualEntryCount * 16;
                this._checksumRandomAccessFile.write(bytes, 0, fileSize);
                this._checksumRandomAccessFile.setLength(fileSize);
            }
        }
        this._systemBundle = bundleContext.getBundle("System Bundle");
        for (String dir2 : PropsValues.MODULE_FRAMEWORK_AUTO_DEPLOY_DIRS) {
            String filePath = Util.getFilePath(dir2);
            this._watchedDirPaths.add(filePath);
            this._watchedDirs.add(new File(filePath));
        }
        this._fileInstallers = ServiceTrackerListFactory.open((BundleContext)this._bundleContext, FileInstaller.class, null, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<FileInstaller, FileInstaller>(){

            public FileInstaller addingService(ServiceReference<FileInstaller> serviceReference) {
                return (FileInstaller)DirectoryWatcher.this._bundleContext.getService(serviceReference);
            }

            public void modifiedService(ServiceReference<FileInstaller> serviceReference, FileInstaller fileInstaller) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<FileInstaller> serviceReference, FileInstaller fileInstaller) {
                DirectoryWatcher.this._bundleContext.ungetService(serviceReference);
                DirectoryWatcher.this._bundleContext.ungetService(serviceReference);
                for (Artifact artifact : DirectoryWatcher.this._getArtifacts()) {
                    if (artifact.getFileInstaller() != fileInstaller) continue;
                    artifact.setFileInstaller(null);
                }
                1 var3_3 = this;
                synchronized (var3_3) {
                    this.notifyAll();
                }
            }
        });
        this._filenameFilter = !Validator.isBlank((String)PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_FILTER) ? new FilenameFilter(){
            private final Pattern _pattern = Pattern.compile(PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_FILTER);

            @Override
            public boolean accept(File dir, String name) {
                Matcher matcher = this._pattern.matcher(name);
                return matcher.matches();
            }
        } : (dir, name) -> true;
        this._scanner = new Scanner(this._watchedDirs, this._filenameFilter, PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_SUBDIR_MODE);
        this._bundleContext.addBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        int type = bundleEvent.getType();
        if (type == 16) {
            List<Artifact> artifacts = this._getArtifacts();
            Iterator<Artifact> iterator = artifacts.iterator();
            while (iterator.hasNext()) {
                Artifact artifact = iterator.next();
                Bundle bundle = bundleEvent.getBundle();
                long bundleId = bundle.getBundleId();
                if (artifact.getBundleId() != bundleId) continue;
                iterator.remove();
                break;
            }
        }
        if (type == 1 || type == 32 || type == 16 || type == 64 || type == 8) {
            this._setStateChanged(true);
        }
    }

    public void close() throws IOException {
        block2: {
            this._bundleContext.removeBundleListener((BundleListener)this);
            this.interrupt();
            try {
                this.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)interruptedException);
            }
        }
        this._fileInstallers.close();
        this._checksumRandomAccessFile.close();
    }

    public Scanner getScanner() {
        return this._scanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_NO_INITIAL_DELAY) {
            try {
                Thread.sleep(PropsValues.MODULE_FRAMEWORK_AUTO_DEPLOY_INTERVAL);
            }
            catch (InterruptedException interruptedException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)interruptedException);
                }
                return;
            }
            this._initializeCurrentManagedBundles();
        }
        while (!DirectoryWatcher.interrupted()) {
            try {
                Object files;
                FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)this._systemBundle.adapt(FrameworkStartLevel.class);
                if (frameworkStartLevel.getStartLevel() >= PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_ACTIVE_LEVEL && this._systemBundle.getState() == 32 && (files = this._scanner.scan(false)) != null) {
                    this._process((Set<File>)files);
                }
                files = this;
                synchronized (files) {
                    this.wait(PropsValues.MODULE_FRAMEWORK_AUTO_DEPLOY_INTERVAL);
                }
            }
            catch (InterruptedException interruptedException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)interruptedException);
                }
                this.interrupt();
                return;
            }
            catch (Throwable throwable) {
                try {
                    this._bundleContext.getBundle();
                }
                catch (IllegalStateException illegalStateException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)illegalStateException);
                    }
                    return;
                }
                _log.error((Object)throwable, throwable);
            }
        }
    }

    @Override
    public void start() {
        if (PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_NO_INITIAL_DELAY) {
            this._initializeCurrentManagedBundles();
            Set<File> files = this._scanner.scan(true);
            if (files != null) {
                try {
                    this._process(files);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
        }
        super.start();
    }

    private boolean _contains(String path, List<String> dirPaths) {
        for (String dirPath : dirPaths) {
            if (!path.contains(dirPath)) continue;
            return true;
        }
        return false;
    }

    private void _findBundlesWithFragmentsToRefresh(Set<Bundle> bundles) {
        HashSet<String> hostBundleSymbolicNames = new HashSet<String>();
        for (Bundle bundle : bundles) {
            if (bundle.getState() == 1 || !this._isFragment(bundle)) continue;
            hostBundleSymbolicNames.add(this._getFragmentHost(bundle));
        }
        if (hostBundleSymbolicNames.isEmpty()) {
            return;
        }
        for (Bundle bundle : this._bundleContext.getBundles()) {
            int hostBundleState;
            if (!hostBundleSymbolicNames.remove(bundle.getSymbolicName()) || (hostBundleState = bundle.getState()) != 32 && hostBundleState != 4 && hostBundleState != 8) continue;
            bundles.add(bundle);
        }
    }

    private FileInstaller _findFileInstaller(File file, Iterable<FileInstaller> iterable) {
        for (FileInstaller fileInstaller : iterable) {
            if (!fileInstaller.canTransformURL(file)) continue;
            return fileInstaller;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Artifact _getArtifact(File file) {
        Map<File, Artifact> map = this._currentManagedArtifacts;
        synchronized (map) {
            return this._currentManagedArtifacts.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Artifact> _getArtifacts() {
        Map<File, Artifact> map = this._currentManagedArtifacts;
        synchronized (map) {
            return new ArrayList<Artifact>(this._currentManagedArtifacts.values());
        }
    }

    private long _getChecksum(Bundle bundle) {
        Long checksum = this._bundleChecksums.get(bundle.getBundleId());
        if (checksum == null) {
            return Long.MIN_VALUE;
        }
        return checksum;
    }

    private String _getFragmentHost(Bundle bundle) {
        Dictionary dictionary = bundle.getHeaders("");
        String fragmentHost = (String)dictionary.get("Fragment-Host");
        if (fragmentHost == null) {
            return null;
        }
        int index = fragmentHost.indexOf(59);
        if (index != -1) {
            fragmentHost = fragmentHost.substring(0, index);
        }
        return fragmentHost;
    }

    private void _initializeCurrentManagedBundles() {
        Bundle[] bundles = this._bundleContext.getBundles();
        HashMap<File, Long> checksums = new HashMap<File, Long>();
        for (Bundle bundle : bundles) {
            int index;
            String location = bundle.getLocation();
            URI uri = null;
            try {
                uri = new URI(location);
                uri = uri.normalize();
            }
            catch (URISyntaxException uriSyntaxException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)uriSyntaxException);
                }
                File file = new File(location);
                uri = file.toURI();
                uri = uri.normalize();
            }
            String locationPath = uri.getPath();
            if (locationPath == null) continue;
            String path = null;
            if (location != null && this._contains(locationPath, this._watchedDirPaths)) {
                String schemeSpecificPart = uri.getSchemeSpecificPart();
                if (uri.isOpaque() && schemeSpecificPart != null) {
                    int lastIndexOfFileProtocol = schemeSpecificPart.lastIndexOf("file:");
                    int offsetFileProtocol = 0;
                    if (lastIndexOfFileProtocol >= 0) {
                        offsetFileProtocol = lastIndexOfFileProtocol + "file:".length();
                    }
                    int firstIndexOfDollar = schemeSpecificPart.indexOf("$");
                    int endOfPath = schemeSpecificPart.length();
                    if (firstIndexOfDollar >= 0) {
                        endOfPath = firstIndexOfDollar;
                    }
                    path = schemeSpecificPart.substring(offsetFileProtocol, endOfPath);
                } else {
                    path = uri.getPath();
                }
            }
            if (path == null || (index = path.lastIndexOf(47)) == -1 || !this._startWith(path, this._watchedDirPaths) || !this._filenameFilter.accept(new File(path.substring(0, index)), path.substring(index + 1))) continue;
            Artifact artifact = new Artifact();
            artifact.setBundleId(bundle.getBundleId());
            artifact.setChecksum(this._getChecksum(bundle));
            artifact.setFile(new File(path));
            this._setArtifact(new File(path), artifact);
            checksums.put(new File(path), artifact.getChecksum());
        }
        this._scanner.initialize(checksums);
    }

    private Bundle _install(Artifact artifact) {
        File file = artifact.getFile();
        Bundle bundle = null;
        AtomicBoolean modified = new AtomicBoolean();
        try {
            FileInstaller fileInstaller = this._findFileInstaller(file, (Iterable<FileInstaller>)this._fileInstallers);
            if (fileInstaller == null) {
                this._processingFailures.add(file);
                return null;
            }
            artifact.setFileInstaller(fileInstaller);
            long checksum = artifact.getChecksum();
            Artifact badArtifact = this._installationFailures.get(file);
            if (badArtifact != null && badArtifact.getChecksum() == checksum) {
                return null;
            }
            URL url = fileInstaller.transformURL(file);
            if (url != null) {
                String location = url.toString();
                try (InputStream inputStream = url.openStream();
                     BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
                    bundle = this._installOrUpdateBundle(location, bufferedInputStream, checksum, modified);
                    artifact.setBundleId(bundle.getBundleId());
                }
            }
            this._installationFailures.remove(file);
            this._setArtifact(file, artifact);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to install artifact: " + file), (Throwable)exception);
            this._installationFailures.put(file, artifact);
        }
        if (modified.get()) {
            return bundle;
        }
        return null;
    }

    private Collection<Bundle> _install(Collection<Artifact> artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Artifact artifact : artifacts) {
            Bundle bundle = this._install(artifact);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    private Bundle _installOrUpdateBundle(String location, BufferedInputStream bufferedInputStream, long checksum, AtomicBoolean modified) throws Exception {
        Bundle bundle = this._bundleContext.getBundle(location);
        if (bundle != null && this._getChecksum(bundle) != checksum) {
            bundle.update((InputStream)bufferedInputStream);
            this._putChecksum(bundle, checksum);
            return bundle;
        }
        bufferedInputStream.mark(262144);
        try (JarInputStream jarInputStream = new JarInputStream(bufferedInputStream);){
            Manifest manifest = jarInputStream.getManifest();
            if (manifest == null) {
                throw new BundleException(StringBundler.concat((String[])new String[]{"The bundle ", location, " does not have a ", "META-INF/MANIFEST.MF! Make sure, META-INF and ", "MANIFEST.MF are the first 2 entries in your JAR!"}));
            }
            Attributes attributes = manifest.getMainAttributes();
            String symbolicName = attributes.getValue("Bundle-SymbolicName");
            String versionString = attributes.getValue("Bundle-Version");
            Version version = Version.emptyVersion;
            if (versionString != null) {
                version = Version.parseVersion((String)versionString);
            }
            for (Bundle currentBundle : this._bundleContext.getBundles()) {
                String currentSymbolicName = currentBundle.getSymbolicName();
                if (currentSymbolicName == null || !Objects.equals(currentSymbolicName, symbolicName)) continue;
                Dictionary headers = currentBundle.getHeaders("");
                versionString = (String)headers.get("Bundle-Version");
                Version currentVersion = Version.emptyVersion;
                if (versionString != null) {
                    currentVersion = Version.parseVersion((String)versionString);
                }
                if (!version.equals((Object)currentVersion)) continue;
                bufferedInputStream.reset();
                if (this._getChecksum(currentBundle) != checksum) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((String[])new String[]{"A bundle with the same symbolic name ", "(", symbolicName, ") and version (", versionString, ") is already installed. Updating ", "this bundle instead."}));
                    }
                    this._stopTransient(currentBundle);
                    this._putChecksum(currentBundle, checksum);
                    currentBundle.update((InputStream)bufferedInputStream);
                    modified.set(true);
                }
                Bundle bundle2 = currentBundle;
                return bundle2;
            }
            bufferedInputStream.reset();
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Installing bundle ", symbolicName, " / ", version}));
            }
            if ((bundle = this._bundleContext.installBundle(location, (InputStream)bufferedInputStream)).getState() == 1) {
                Bundle bundle3 = bundle;
                return bundle3;
            }
            this._putChecksum(bundle, checksum);
            modified.set(true);
            Dictionary headers = bundle.getHeaders("");
            String header = (String)headers.get("Web-ContextPath");
            BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
            if (header != null) {
                bundleStartLevel.setStartLevel(ModuleFrameworkPropsValues.MODULE_FRAMEWORK_WEB_START_LEVEL);
            } else if (ModuleFrameworkPropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL != 0) {
                bundleStartLevel.setStartLevel(ModuleFrameworkPropsValues.MODULE_FRAMEWORK_DYNAMIC_INSTALL_START_LEVEL);
            }
            Bundle bundle4 = bundle;
            return bundle4;
        }
    }

    private boolean _isFragment(Bundle bundle) {
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        return (bundleRevision.getTypes() & 1) != 0;
    }

    private boolean _isStateChanged() {
        return this._stateChanged.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _process(Set<File> files) throws InterruptedException {
        ArrayList<Artifact> createdArtifacts = new ArrayList<Artifact>();
        ArrayList<Artifact> deletedArtifacts = new ArrayList<Artifact>();
        ArrayList<Artifact> modifiedArtifacts = new ArrayList<Artifact>();
        Set<File> set = this._processingFailures;
        synchronized (set) {
            files.addAll(this._processingFailures);
            this._processingFailures.clear();
        }
        for (File file : files) {
            Artifact artifact = this._getArtifact(file);
            if (!file.exists()) {
                if (artifact == null) continue;
                deletedArtifacts.add(artifact);
                continue;
            }
            if (artifact != null) {
                artifact.setChecksum(this._scanner.getChecksum(file));
                modifiedArtifacts.add(artifact);
                continue;
            }
            artifact = new Artifact();
            artifact.setChecksum(this._scanner.getChecksum(file));
            artifact.setFile(file);
            createdArtifacts.add(artifact);
        }
        Collection<Bundle> uninstalledBundles = this._uninstall(deletedArtifacts);
        Collection<Bundle> updatedBundles = this._update(modifiedArtifacts);
        Collection<Bundle> installedBundles = this._install(createdArtifacts);
        if (!(uninstalledBundles.isEmpty() && updatedBundles.isEmpty() && installedBundles.isEmpty())) {
            HashSet<Bundle> bundles = new HashSet<Bundle>();
            bundles.addAll(uninstalledBundles);
            bundles.addAll(updatedBundles);
            bundles.addAll(installedBundles);
            this._findBundlesWithFragmentsToRefresh(bundles);
            if (!bundles.isEmpty()) {
                this._refresh(bundles);
                this._setStateChanged(true);
            }
        }
        if (PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_BUNDLES_START_NEW) {
            FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)this._systemBundle.adapt(FrameworkStartLevel.class);
            int startLevel = frameworkStartLevel.getStartLevel();
            if (this._isStateChanged() || startLevel != this._frameworkStartLevel) {
                this._frameworkStartLevel = startLevel;
                this._startAllBundles();
                this._delayedStart.addAll(installedBundles);
                this._delayedStart.removeAll(uninstalledBundles);
                this._startBundles(this._delayedStart);
                this._consistentlyFailingBundles.clear();
                this._consistentlyFailingBundles.addAll(this._delayedStart);
                this._setStateChanged(false);
            }
        }
    }

    private void _putChecksum(Bundle bundle, long checksum) {
        long bundleId = bundle.getBundleId();
        this._bundleChecksums.put(bundleId, checksum);
        byte[] bytes = new byte[16];
        BigEndianCodec.putLong((byte[])bytes, (int)0, (long)bundleId);
        BigEndianCodec.putLong((byte[])bytes, (int)8, (long)checksum);
        try {
            this._checksumRandomAccessFile.write(bytes);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private void _refresh(Collection<Bundle> bundles) throws InterruptedException {
        FrameworkWiring frameworkWiring = (FrameworkWiring)this._systemBundle.adapt(FrameworkWiring.class);
        DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        frameworkWiring.refreshBundles(bundles, new FrameworkListener[]{frameworkEvent -> defaultNoticeableFuture.set((Object)frameworkEvent)});
        try {
            FrameworkEvent frameworkEvent2 = (FrameworkEvent)defaultNoticeableFuture.get();
            if (frameworkEvent2.getType() != 4) {
                throw frameworkEvent2.getThrowable();
            }
        }
        catch (Throwable throwable) {
            ReflectionUtil.throwException((Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _removeArtifact(File file) {
        Map<File, Artifact> map = this._currentManagedArtifacts;
        synchronized (map) {
            this._currentManagedArtifacts.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setArtifact(File file, Artifact artifact) {
        Map<File, Artifact> map = this._currentManagedArtifacts;
        synchronized (map) {
            this._currentManagedArtifacts.put(file, artifact);
        }
    }

    private void _setStateChanged(boolean changed) {
        this._stateChanged.set(changed);
    }

    private void _startAllBundles() {
        FrameworkStartLevel frameworkStartLevel = (FrameworkStartLevel)this._systemBundle.adapt(FrameworkStartLevel.class);
        LinkedHashSet<Bundle> bundles = new LinkedHashSet<Bundle>();
        for (Artifact artifact : this._getArtifacts()) {
            Bundle bundle;
            long bundleId = artifact.getBundleId();
            if (bundleId <= 0L || (bundle = this._bundleContext.getBundle(bundleId)) == null) continue;
            int state = bundle.getState();
            BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
            if (state == 8 || state == 32 || !PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_BUNDLES_START_TRANSIENT && !bundleStartLevel.isPersistentlyStarted() || frameworkStartLevel.getStartLevel() < bundleStartLevel.getStartLevel()) continue;
            bundles.add(bundle);
        }
        this._startBundles(bundles);
    }

    private boolean _startBundle(Bundle bundle, boolean logFailures) {
        block8: {
            BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
            if (PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_BUNDLES_START_NEW && bundle.getState() != 1 && !this._isFragment(bundle) && this._frameworkStartLevel >= bundleStartLevel.getStartLevel()) {
                try {
                    int options = 0;
                    if (PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_BUNDLES_START_TRANSIENT) {
                        options = 1;
                    }
                    if (PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_BUNDLES_START_ACTIVATION_POLICY) {
                        options |= 2;
                    }
                    bundle.start(options);
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Started bundle: " + bundle.getLocation()));
                    }
                    return true;
                }
                catch (IllegalStateException illegalStateException) {
                    if (bundle.getState() == 1) {
                        return true;
                    }
                    throw illegalStateException;
                }
                catch (BundleException bundleException) {
                    if (!logFailures) break block8;
                    _log.error((Object)("Unable to start bundle: " + bundle.getLocation()), (Throwable)bundleException);
                }
            }
        }
        return false;
    }

    private void _startBundles(Set<Bundle> bundles) {
        Iterator<Bundle> iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = iterator.next();
            if (!this._startBundle(bundle, true)) continue;
            iterator.remove();
        }
    }

    private boolean _startWith(String path, List<String> dirPaths) {
        for (String dirPath : dirPaths) {
            if (!path.startsWith(dirPath)) continue;
            return true;
        }
        return false;
    }

    private void _stopTransient(Bundle bundle) throws BundleException {
        if (PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_BUNDLES_START_NEW && !this._isFragment(bundle)) {
            bundle.stop(1);
        }
    }

    private Bundle _uninstall(Artifact artifact) {
        block7: {
            try {
                long bundleId;
                File file = artifact.getFile();
                this._removeArtifact(file);
                FileInstaller fileInstaller = artifact.getFileInstaller();
                if (fileInstaller != null) {
                    fileInstaller.uninstall(file);
                }
                if ((bundleId = artifact.getBundleId()) > 0L) {
                    Bundle bundle = this._bundleContext.getBundle(bundleId);
                    if (bundle == null) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to uninstall bundle: ", file, " with id: ", bundleId, ". The bundle has already been uninstalled"}));
                        }
                        return null;
                    }
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)StringBundler.concat((Object[])new Object[]{"Uninstalling bundle ", bundle.getBundleId(), " (", bundle.getSymbolicName(), ")"}));
                    }
                    bundle.uninstall();
                    return bundle;
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)("Unable to uninstall artifact: " + artifact.getFile()), (Throwable)exception);
            }
        }
        return null;
    }

    private Collection<Bundle> _uninstall(Collection<Artifact> artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Artifact artifact : artifacts) {
            Bundle bundle = this._uninstall(artifact);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    private Bundle _update(Artifact artifact) {
        Bundle bundle;
        block19: {
            bundle = null;
            try {
                File file = artifact.getFile();
                FileInstaller fileInstaller = this._findFileInstaller(file, (Iterable<FileInstaller>)this._fileInstallers);
                if (fileInstaller == null) {
                    this._processingFailures.add(file);
                    return null;
                }
                artifact.setFileInstaller(fileInstaller);
                URL url = fileInstaller.transformURL(file);
                if (url == null) {
                    return null;
                }
                long bundleId = artifact.getBundleId();
                bundle = this._bundleContext.getBundle(bundleId);
                if (bundle == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update bundle: ", file, " with ID ", bundleId, ". The bundle has been uninstalled"}));
                    }
                    return null;
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Updating bundle ", bundle.getSymbolicName(), " / ", bundle.getVersion()}));
                }
                this._stopTransient(bundle);
                this._putChecksum(bundle, artifact.getChecksum());
                try (InputStream inputStream = url.openStream();){
                    bundle.update(inputStream);
                }
            }
            catch (Throwable throwable) {
                if (!_log.isWarnEnabled()) break block19;
                _log.warn((Object)("Unable to update artifact " + artifact.getFile()), throwable);
            }
        }
        return bundle;
    }

    private Collection<Bundle> _update(Collection<Artifact> artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Artifact artifact : artifacts) {
            Bundle bundle = this._update(artifact);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }
}

