/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal;

import com.liferay.petra.reflect.ReflectionUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.CRC32;

public class Scanner {
    public static final String SUBDIR_MODE_RECURSE = "recurse";
    private final FilenameFilter _filenameFilter;
    private final Map<File, Long> _lastChecksums = new HashMap<File, Long>();
    private final boolean _recurseSubdir;
    private final Map<File, Long> _storedChecksums = new HashMap<File, Long>();
    private final List<File> _watchedDirs;

    public Scanner(List<File> dirs, FilenameFilter filenameFilter, String subdirMode) {
        this._filenameFilter = filenameFilter;
        this._watchedDirs = dirs;
        this._recurseSubdir = SUBDIR_MODE_RECURSE.equals(subdirMode);
    }

    public long getChecksum(File file) {
        Long checksum = this._storedChecksums.get(file);
        if (checksum != null) {
            return checksum;
        }
        return 0L;
    }

    public void initialize(Map<File, Long> checksums) {
        this._storedChecksums.putAll(checksums);
    }

    public Set<File> scan(boolean reportImmediately) {
        Set<File> files = this._processFiles(reportImmediately, this._list());
        return new TreeSet<File>(files);
    }

    public void updateChecksum(File file) {
        if (file != null && this._storedChecksums.containsKey(file)) {
            long newChecksum = Scanner._checksum(file);
            this._storedChecksums.put(file, newChecksum);
        }
    }

    private static long _checksum(File file) {
        CRC32 crc32 = new CRC32();
        Scanner._checksum(file, crc32);
        return crc32.getValue();
    }

    private static void _checksum(File file, CRC32 crc32) {
        File[] children;
        String name = file.getName();
        crc32.update(name.getBytes());
        if (file.isFile()) {
            Scanner._checksum(file.canWrite() ? 1000L : -1000L, crc32);
            Scanner._checksum(file.lastModified() / 1000L, crc32);
            Scanner._checksum(file.length(), crc32);
        } else if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                Scanner._checksum(child, crc32);
            }
        }
    }

    private static void _checksum(long l, CRC32 crc32) {
        for (int i = 0; i < 8; ++i) {
            crc32.update((int)(l & 0xFFL));
            l >>= 8;
        }
    }

    private File[] _list() {
        final ArrayList files = new ArrayList();
        for (File dir : this._watchedDirs) {
            if (this._recurseSubdir) {
                try {
                    Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                            File file = path.toFile();
                            if (Scanner.this._filenameFilter.accept(file.getParentFile(), file.getName())) {
                                files.add(file);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException ioException) {
                    ReflectionUtil.throwException((Throwable)ioException);
                }
                continue;
            }
            File[] list = dir.listFiles(this._filenameFilter);
            if (list == null) continue;
            Collections.addAll(files, list);
        }
        return files.toArray(new File[0]);
    }

    private Set<File> _processFiles(boolean reportImmediately, File[] list) {
        if (list == null) {
            return new HashSet<File>();
        }
        HashSet<File> files = new HashSet<File>();
        HashSet<File> removed = new HashSet<File>(this._storedChecksums.keySet());
        for (File file : list) {
            if (file.isDirectory()) continue;
            long lastChecksum = 0L;
            if (this._lastChecksums.get(file) != null) {
                lastChecksum = this._lastChecksums.get(file);
            }
            long storedChecksum = 0L;
            if (this._storedChecksums.get(file) != null) {
                storedChecksum = this._storedChecksums.get(file);
            }
            long newChecksum = Scanner._checksum(file);
            this._lastChecksums.put(file, newChecksum);
            if ((newChecksum == lastChecksum || reportImmediately) && newChecksum != storedChecksum) {
                this._storedChecksums.put(file, newChecksum);
                files.add(file);
            }
            removed.remove(file);
        }
        files.addAll(removed);
        for (File file : removed) {
            this._lastChecksums.remove(file);
            this._storedChecksums.remove(file);
        }
        return files;
    }
}

