/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal.configuration;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.file.install.FileInstaller;
import com.liferay.portal.file.install.internal.Util;
import com.liferay.portal.file.install.properties.ConfigurationProperties;
import com.liferay.portal.file.install.properties.ConfigurationPropertiesFactory;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigurationFileInstaller
implements FileInstaller {
    private static final Log _log = LogFactoryUtil.getLog(ConfigurationFileInstaller.class);
    private final String _configsDirPath;
    private final ConfigurationAdmin _configurationAdmin;
    private final String _encoding;

    public ConfigurationFileInstaller(ConfigurationAdmin configurationAdmin, String encoding) {
        this._configurationAdmin = configurationAdmin;
        this._encoding = encoding;
        this._configsDirPath = Util.getFilePath(PropsValues.MODULE_FRAMEWORK_CONFIGS_DIR);
    }

    public boolean canTransformURL(File file) {
        if (!Objects.equals(this._configsDirPath, Util.getFilePath(file.getParent()))) {
            return false;
        }
        String name = file.getName();
        if (name.endsWith(".config")) {
            return true;
        }
        if (name.endsWith(".cfg")) {
            if (PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_CFG_ENABLED) {
                return true;
            }
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to install .cfg file " + file + ", please use .config file instead."));
            }
        }
        return false;
    }

    public URL transformURL(File file) throws Exception {
        HashMapDictionary dictionary = new HashMapDictionary();
        ConfigurationProperties configurationProperties = ConfigurationPropertiesFactory.create((File)file, (String)this._encoding);
        for (String key : configurationProperties.keySet()) {
            dictionary.put(key, configurationProperties.get(key));
        }
        String[] pid = this._parsePid(file.getName());
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)this._getCompanyId(this._getScope((Dictionary<String, Object>)dictionary), (Dictionary<String, Object>)dictionary, file.getName()));){
            Configuration configuration = this._getConfiguration(file.getName(), pid[0], pid[1]);
            Set configurationAttributes = configuration.getAttributes();
            if (configurationAttributes.contains(Configuration.ConfigurationAttribute.READ_ONLY)) {
                configuration.removeAttributes(new Configuration.ConfigurationAttribute[]{Configuration.ConfigurationAttribute.READ_ONLY});
            }
            Dictionary properties = configuration.getProperties();
            HashMapDictionary old = null;
            if (properties != null) {
                old = new HashMapDictionary();
                Enumeration enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    old.put(key, properties.get(key));
                }
            }
            String oldFileName = null;
            if (old != null) {
                oldFileName = (String)old.remove("felix.fileinstall.filename");
                old.remove("service.pid");
                old.remove("service.factoryPid");
                Object bundleLocation = dictionary.get("service.bundleLocation");
                if (bundleLocation == null && Objects.equals("?", old.get("service.bundleLocation"))) {
                    old.remove("service.bundleLocation");
                }
            }
            String currentFileName = file.getName();
            if (!this._equals((Dictionary<String, Object>)dictionary, (Dictionary<String, Object>)old) || !Objects.equals(oldFileName, currentFileName) || configurationAttributes.contains(Configuration.ConfigurationAttribute.READ_ONLY) || !file.canWrite()) {
                dictionary.put("felix.fileinstall.filename", currentFileName);
                String logString = "";
                if (pid[1] != null) {
                    logString = "~" + pid[1];
                }
                if (old == null) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)StringBundler.concat((String[])new String[]{"Creating configuration from ", pid[0], logString, ".config"}));
                    }
                } else if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"Updating configuration from ", pid[0], logString, ".config"}));
                }
                configuration.updateIfDifferent((Dictionary)dictionary);
                if (!file.canWrite()) {
                    try {
                        configuration.addAttributes(new Configuration.ConfigurationAttribute[]{Configuration.ConfigurationAttribute.READ_ONLY});
                    }
                    catch (Throwable throwable) {
                        _log.error(throwable);
                    }
                }
            }
        }
        return null;
    }

    public void uninstall(File file) throws Exception {
        String[] pid = this._parsePid(file.getName());
        String logString = "";
        if (pid[1] != null) {
            logString = "~" + pid[1];
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Deleting configuration from ", pid[0], logString, ".config"}));
        }
        Configuration configuration = this._getConfiguration(file.getName(), pid[0], pid[1]);
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)this._getCompanyId(ExtendedObjectClassDefinition.Scope.COMPANY, configuration.getProperties(), file.getName()));){
            configuration.delete();
        }
    }

    private boolean _equals(Dictionary<String, Object> newDictionary, Dictionary<String, Object> oldDictionary) {
        if (oldDictionary == null) {
            return false;
        }
        Enumeration<String> enumeration = newDictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object oldValue;
            String key = enumeration.nextElement();
            Object newValue = newDictionary.get(key);
            if (Objects.equals(newValue, oldValue = oldDictionary.remove(key)) || Objects.deepEquals(newValue, oldValue)) continue;
            return false;
        }
        return oldDictionary.isEmpty();
    }

    private String _escapeFilterValue(String string) {
        string = StringUtil.replace((String)string, (String)"[(]", (String)"\\\\(");
        string = StringUtil.replace((String)string, (String)"[)]", (String)"\\\\)");
        string = StringUtil.replace((String)string, (String)"[=]", (String)"\\\\=");
        return StringUtil.replace((String)string, (String)"[\\*]", (String)"\\\\*");
    }

    private Configuration _findExistingConfiguration(String fileName) throws Exception {
        Configuration[] configurations = this._configurationAdmin.listConfigurations(StringBundler.concat((String[])new String[]{"(", "felix.fileinstall.filename", "=", this._escapeFilterValue(fileName), ")"}));
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    private Long _getCompanyId(ExtendedObjectClassDefinition.Scope scope, Dictionary<String, Object> dictionary, String fileName) {
        if (!DBPartition.isPartitionEnabled() || scope != ExtendedObjectClassDefinition.Scope.COMPANY || dictionary == null) {
            return 0L;
        }
        Long companyId = (Long)dictionary.get(scope.getPropertyKey());
        if (companyId != null) {
            if (!ArrayUtil.contains((long[])PortalInstancePool.getCompanyIds(), (long)companyId)) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Unable to process ", fileName, " because company ID ", companyId, " does not exist"}));
            }
            return companyId;
        }
        String webId = (String)dictionary.get(scope.getPortablePropertyKey());
        if (webId != null) {
            try {
                companyId = PortalInstancePool.getCompanyId((String)webId);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Unable to process ", fileName, ": ", illegalArgumentException.getMessage()}));
            }
            return companyId;
        }
        return 0L;
    }

    private Configuration _getConfiguration(String fileName, String pid, String name) throws Exception {
        Configuration configuration = this._findExistingConfiguration(fileName);
        if (configuration != null) {
            return configuration;
        }
        if (name != null) {
            return this._configurationAdmin.getFactoryConfiguration(pid, name, "?");
        }
        return this._configurationAdmin.getConfiguration(pid, "?");
    }

    private ExtendedObjectClassDefinition.Scope _getScope(Dictionary<String, Object> dictionary) {
        if (!DBPartition.isPartitionEnabled()) {
            return null;
        }
        for (ExtendedObjectClassDefinition.Scope scope : ExtendedObjectClassDefinition.Scope.values()) {
            for (String key : new String[]{scope.getPropertyKey(), scope.getPortablePropertyKey()}) {
                if (key == null || dictionary.get(key) == null) continue;
                if (!scope.equals(ExtendedObjectClassDefinition.Scope.COMPANY)) {
                    throw new UnsupportedOperationException(StringBundler.concat((String[])new String[]{StringUtil.upperCaseFirstLetter((String)scope.getValue()), " scoped configuration files do not support ", "database partitioning"}));
                }
                return scope;
            }
        }
        return ExtendedObjectClassDefinition.Scope.SYSTEM;
    }

    private String[] _parsePid(String path) {
        String pid = path.substring(0, path.lastIndexOf(46));
        int index = pid.indexOf(126);
        if (index <= 0 && (index = pid.indexOf(95)) <= 0) {
            index = pid.indexOf(45);
        }
        if (index > 0) {
            String name = pid.substring(index + 1);
            pid = pid.substring(0, index);
            return new String[]{pid, name};
        }
        return new String[]{pid, null};
    }
}

