/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal.configuration;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.file.install.internal.activator.FileInstallImplBundleActivator;
import com.liferay.portal.file.install.properties.ConfigurationProperties;
import com.liferay.portal.file.install.properties.ConfigurationPropertiesFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public class FileSyncConfigurationListener
implements ConfigurationListener {
    private static final Log _log = LogFactoryUtil.getLog(FileSyncConfigurationListener.class);
    private final ConfigurationAdmin _configurationAdmin;
    private final String _encoding;
    private final FileInstallImplBundleActivator _fileInstallImplBundleActivator;
    private final Map<String, String> _pidToFile;

    public FileSyncConfigurationListener(ConfigurationAdmin configurationAdmin, FileInstallImplBundleActivator fileInstallImplBundleActivator, String encoding) {
        block5: {
            this._pidToFile = new HashMap<String, String>();
            this._configurationAdmin = configurationAdmin;
            this._fileInstallImplBundleActivator = fileInstallImplBundleActivator;
            this._encoding = encoding;
            try {
                Configuration[] configurations = this._configurationAdmin.listConfigurations(null);
                if (configurations != null) {
                    for (Configuration configuration : configurations) {
                        Dictionary dictionary = configuration.getProperties();
                        String fileName = null;
                        if (dictionary != null) {
                            fileName = (String)dictionary.get("felix.fileinstall.filename");
                        }
                        if (fileName == null) continue;
                        this._pidToFile.put(configuration.getPid(), fileName);
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to initialize configurations", (Throwable)exception);
            }
        }
    }

    public void configurationEvent(ConfigurationEvent configurationEvent) {
        block40: {
            int type = configurationEvent.getType();
            if (type == 1) {
                try {
                    Configuration configuration = this._configurationAdmin.getConfiguration(configurationEvent.getPid(), "?");
                    Dictionary dictionary = configuration.getProperties();
                    String fileName = null;
                    if (dictionary != null) {
                        fileName = (String)dictionary.get("felix.fileinstall.filename");
                    }
                    File file = null;
                    if (fileName != null) {
                        file = this._fromConfigKey(fileName);
                    }
                    if (file == null || !file.isFile()) break block40;
                    if (!file.canWrite()) {
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)StringBundler.concat((String[])new String[]{"Unable to save configuration because the ", "file ", file.getAbsolutePath(), " is not writable"}));
                        }
                        this._pidToFile.remove(configuration.getPid(), fileName);
                        return;
                    }
                    this._pidToFile.put(configuration.getPid(), fileName);
                    ConfigurationProperties configurationProperties = ConfigurationPropertiesFactory.create((File)file, (String)this._encoding);
                    ArrayList<Object> toRemovePropertyKeys = new ArrayList<Object>();
                    for (Object key : configurationProperties.keySet()) {
                        if (dictionary.get(key) != null || Objects.equals("service.pid", key) || Objects.equals("service.factoryPid", key) || Objects.equals("felix.fileinstall.filename", key)) continue;
                        toRemovePropertyKeys.add(key);
                    }
                    Enumeration enumeration = dictionary.keys();
                    while (enumeration.hasMoreElements()) {
                        Object key;
                        key = (String)enumeration.nextElement();
                        if (Objects.equals("service.pid", key) || Objects.equals("service.factoryPid", key) || Objects.equals("felix.fileinstall.filename", key)) continue;
                        Object v = dictionary.get(key);
                        configurationProperties.put((String)key, v);
                    }
                    for (String string : toRemovePropertyKeys) {
                        configurationProperties.remove(string);
                    }
                    Throwable throwable = null;
                    try (FileOutputStream outputStream = new FileOutputStream(file);
                         OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, this._encoding);){
                        configurationProperties.save((Writer)writer);
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    this._fileInstallImplBundleActivator.updateChecksum(file);
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)"Unable to save configuration", (Throwable)exception);
                    }
                    break block40;
                }
            }
            if (type == 2) {
                try {
                    String fileName = this._pidToFile.remove(configurationEvent.getPid());
                    File file = null;
                    if (fileName != null) {
                        file = this._fromConfigKey(fileName);
                    }
                    if (file != null && file.isFile() && !file.delete()) {
                        throw new IOException("Unable to delete file " + file);
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block40;
                    _log.warn((Object)"Unable to delete configuration file", (Throwable)exception);
                }
            }
        }
    }

    private File _fromConfigKey(String key) {
        return new File(PropsValues.MODULE_FRAMEWORK_CONFIGS_DIR, key);
    }
}

