/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.html.parser.internal;

import com.liferay.portal.html.parser.internal.CachedLoggerProvider;
import com.liferay.portal.kernel.util.HtmlParser;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={HtmlParser.class})
public class HtmlParserImpl
implements HtmlParser {
    public String extractText(String html) {
        if (html == null) {
            return null;
        }
        Source source = new Source((CharSequence)html);
        return String.valueOf(source.getTextExtractor());
    }

    public String findAttributeValue(Predicate<Function<String, String>> findValuePredicate, Function<Function<String, String>, String> returnValueFunction, String html, String startTagName) {
        Source clientSource = new Source((CharSequence)html);
        List startTags = clientSource.getAllStartTags(startTagName);
        for (StartTag startTag : startTags) {
            boolean found = findValuePredicate.test(arg_0 -> ((StartTag)startTag).getAttributeValue(arg_0));
            if (!found) continue;
            return returnValueFunction.apply(arg_0 -> ((StartTag)startTag).getAttributeValue(arg_0));
        }
        return null;
    }

    public String render(String html) {
        if (html == null) {
            return null;
        }
        Source source = new Source((CharSequence)html);
        return String.valueOf(source.getRenderer());
    }

    @Activate
    protected void activate() throws Exception {
        CachedLoggerProvider.install();
    }
}

