/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.http.internal;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.memory.FinalizeAction;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.http.internal.configuration.HttpConfiguration;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncFilterInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.http.internal.configuration.HttpConfiguration"}, service={Http.class})
public class HttpImpl
implements Http {
    private static final String _DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 6.3; Trident/7.0; rv 11.0) like Gecko";
    private static final int _MAX_BYTE_ARRAY_LENGTH = 0x7FFFFFF7;
    private static final int _MAX_CONNECTIONS_PER_HOST = GetterUtil.getInteger((String)PropsUtil.get((String)(Http.class.getName() + ".max.connections.per.host")), (int)2);
    private static final int _MAX_TOTAL_CONNECTIONS = GetterUtil.getInteger((String)PropsUtil.get((String)(Http.class.getName() + ".max.total.connections")), (int)20);
    private static final String[] _NON_PROXY_HOSTS = StringUtil.split((String)SystemProperties.get((String)"http.nonProxyHosts"), (String)"|");
    private static final String _PROXY_AUTH_TYPE = GetterUtil.getString((String)PropsUtil.get((String)(Http.class.getName() + ".proxy.auth.type")));
    private static final String _PROXY_HOST = GetterUtil.getString((String)SystemProperties.get((String)"http.proxyHost"));
    private static final String _PROXY_NTLM_DOMAIN = GetterUtil.getString((String)PropsUtil.get((String)(Http.class.getName() + ".proxy.ntlm.domain")));
    private static final String _PROXY_NTLM_HOST = GetterUtil.getString((String)PropsUtil.get((String)(Http.class.getName() + ".proxy.ntlm.host")));
    private static final String _PROXY_PASSWORD = GetterUtil.getString((String)PropsUtil.get((String)(Http.class.getName() + ".proxy.password")));
    private static final int _PROXY_PORT = GetterUtil.getInteger((String)SystemProperties.get((String)"http.proxyPort"));
    private static final String _PROXY_USERNAME = GetterUtil.getString((String)PropsUtil.get((String)(Http.class.getName() + ".proxy.username")));
    private static final int _TIMEOUT = GetterUtil.getInteger((String)PropsUtil.get((String)(Http.class.getName() + ".timeout")), (int)5000);
    private static final Log _log = LogFactoryUtil.getLog(HttpImpl.class);
    private static final ThreadLocal<javax.servlet.http.Cookie[]> _cookies = new ThreadLocal();
    private final DCLSingleton<CloseableHttpClient> _closeableHttpClientDCLSingleton = new DCLSingleton();
    private volatile HttpConfiguration _httpConfiguration;
    private final DCLSingleton<PoolingHttpClientConnectionManager> _poolingHttpClientConnectionManagerDCLSingleton = new DCLSingleton();
    private final List<String> _proxyAuthPrefs = new ArrayList<String>();
    private final DCLSingleton<CloseableHttpClient> _proxyCloseableHttpClientDCLSingleton = new DCLSingleton();
    private Credentials _proxyCredentials;

    public javax.servlet.http.Cookie[] getCookies() {
        return _cookies.get();
    }

    public boolean hasProxyConfig() {
        return Validator.isNotNull((String)_PROXY_HOST) && _PROXY_PORT > 0;
    }

    public boolean isNonProxyHost(String host) {
        if (Validator.isNull((String)host)) {
            return false;
        }
        for (String nonProxyHost : _NON_PROXY_HOSTS) {
            if (!nonProxyHost.equals(host) && (!nonProxyHost.contains("*") || !StringUtil.wildcardMatches((String)host, (String)nonProxyHost, (char)'\u0000', (char)'*', (char)'\u0000', (boolean)false))) continue;
            return true;
        }
        return false;
    }

    public boolean isProxyHost(String host) {
        if (Validator.isNull((String)host)) {
            return false;
        }
        return this.hasProxyConfig() && !this.isNonProxyHost(host);
    }

    public byte[] URLtoByteArray(Http.Options options) throws IOException {
        return this.URLtoByteArray(options.getLocation(), options.getMethod(), options.getHeaders(), options.getCookieSpec(), options.getCookies(), options.getAuth(), options.getBody(), options.getFileParts(), options.getInputStreamParts(), options.getParts(), options.getResponse(), options.isFollowRedirects(), options.isNormalizeURI(), options.getTimeout());
    }

    public byte[] URLtoByteArray(String location) throws IOException {
        Http.Options options = new Http.Options();
        options.setLocation(location);
        return this.URLtoByteArray(options);
    }

    public byte[] URLtoByteArray(String location, boolean post) throws IOException {
        Http.Options options = new Http.Options();
        options.setLocation(location);
        options.setPost(post);
        return this.URLtoByteArray(options);
    }

    public InputStream URLtoInputStream(Http.Options options) throws IOException {
        return this.URLtoInputStream(options.getLocation(), options.getMethod(), options.getHeaders(), options.getCookieSpec(), options.getCookies(), options.getAuth(), options.getBody(), options.getFileParts(), options.getInputStreamParts(), options.getParts(), options.getResponse(), options.isFollowRedirects(), options.isNormalizeURI(), options.getTimeout());
    }

    public InputStream URLtoInputStream(String location) throws IOException {
        Http.Options options = new Http.Options();
        options.setLocation(location);
        return this.URLtoInputStream(options);
    }

    public InputStream URLtoInputStream(String location, boolean post) throws IOException {
        Http.Options options = new Http.Options();
        options.setLocation(location);
        options.setPost(post);
        return this.URLtoInputStream(options);
    }

    public String URLtoString(Http.Options options) throws IOException {
        byte[] bytes = this.URLtoByteArray(options);
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    public String URLtoString(String location) throws IOException {
        byte[] bytes = this.URLtoByteArray(location);
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    public String URLtoString(String location, boolean post) throws IOException {
        byte[] bytes = this.URLtoByteArray(location, post);
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    public String URLtoString(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        String protocol = StringUtil.toLowerCase((String)url.getProtocol());
        if (protocol.startsWith("http") || protocol.startsWith("https")) {
            return this.URLtoString(url.toString());
        }
        URLConnection urlConnection = url.openConnection();
        if (urlConnection == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to open a connection to " + url));
            }
            return null;
        }
        String xml = null;
        try (InputStream inputStream = urlConnection.getInputStream();
             UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            byte[] bytes = new byte[512];
            int i = inputStream.read(bytes, 0, 512);
            while (i != -1) {
                unsyncByteArrayOutputStream.write(bytes, 0, i);
                i = inputStream.read(bytes, 0, 512);
            }
            xml = new String(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
        }
        return xml;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._httpConfiguration = (HttpConfiguration)ConfigurableUtil.createConfigurable(HttpConfiguration.class, properties);
        this._proxyAuthPrefs.add("Basic");
        this._proxyAuthPrefs.add("Digest");
        if (_PROXY_AUTH_TYPE.equals("username-password")) {
            this._proxyCredentials = new UsernamePasswordCredentials(_PROXY_USERNAME, _PROXY_PASSWORD);
            this._proxyAuthPrefs.add("NTLM");
        } else if (_PROXY_AUTH_TYPE.equals("ntlm")) {
            this._proxyCredentials = new NTCredentials(_PROXY_USERNAME, _PROXY_PASSWORD, _PROXY_NTLM_HOST, _PROXY_NTLM_DOMAIN);
            this._proxyAuthPrefs.add(0, "NTLM");
        } else {
            this._proxyCredentials = null;
        }
    }

    protected void addProxyCredentials(URI uri, HttpClientContext httpClientContext) {
        if (!this.isProxyHost(uri.getHost()) || this._proxyCredentials == null) {
            return;
        }
        CredentialsProvider credentialsProvider = httpClientContext.getCredentialsProvider();
        if (credentialsProvider == null) {
            credentialsProvider = new BasicCredentialsProvider();
            httpClientContext.setCredentialsProvider(credentialsProvider);
        }
        credentialsProvider.setCredentials(new AuthScope(_PROXY_HOST, _PROXY_PORT), this._proxyCredentials);
    }

    @Deactivate
    protected void deactivate() {
        this._poolingHttpClientConnectionManagerDCLSingleton.destroy(HttpImpl::_destroyPoolingHttpClientConnectionManager);
    }

    protected boolean hasRequestHeader(RequestBuilder requestBuilder, String name) {
        return !ArrayUtil.isEmpty((Object[])requestBuilder.getHeaders(name));
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this._httpConfiguration = (HttpConfiguration)ConfigurableUtil.createConfigurable(HttpConfiguration.class, properties);
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = (PoolingHttpClientConnectionManager)this._poolingHttpClientConnectionManagerDCLSingleton.getSingleton(this::_createPoolingHttpClientConnectionManager);
        poolingHttpClientConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoKeepAlive(this._httpConfiguration.tcpKeepAliveEnabled()).build());
    }

    protected void processPostMethod(RequestBuilder requestBuilder, Map<String, String> headers, List<Http.FilePart> fileParts, List<Http.InputStreamPart> inputStreamParts, Map<String, String> parts) {
        if (ListUtil.isEmpty(fileParts) && ListUtil.isEmpty(inputStreamParts)) {
            if (parts != null) {
                for (Map.Entry<String, String> entry : parts.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    requestBuilder.addParameter(entry.getKey(), value);
                }
            }
        } else {
            ContentType contentType;
            String boundary;
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            if (headers.containsKey("Content-Type") && (boundary = (contentType = ContentType.parse((String)headers.get("Content-Type"))).getParameter("boundary")) != null) {
                multipartEntityBuilder.setBoundary(boundary);
            }
            if (parts != null) {
                for (Map.Entry<String, String> entry : parts.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    multipartEntityBuilder.addPart(entry.getKey(), (ContentBody)new StringBody(value, ContentType.create((String)"text/plain", (String)"UTF-8")));
                }
            }
            if (fileParts != null) {
                for (Http.FilePart filePart : fileParts) {
                    ByteArrayBody byteArrayBody = new ByteArrayBody(filePart.getValue(), ContentType.DEFAULT_BINARY, filePart.getFileName());
                    multipartEntityBuilder.addPart(filePart.getName(), (ContentBody)byteArrayBody);
                }
            }
            if (inputStreamParts != null) {
                for (Http.InputStreamPart inputStreamPart : inputStreamParts) {
                    ContentType contentType2 = ContentType.DEFAULT_BINARY;
                    if (inputStreamPart.getContentType() != null) {
                        contentType2 = ContentType.create((String)inputStreamPart.getContentType());
                    }
                    multipartEntityBuilder.addPart(inputStreamPart.getName(), (ContentBody)new InputStreamBody(inputStreamPart.getInputStream(), contentType2, inputStreamPart.getInputStreamName()));
                }
            }
            requestBuilder.setEntity(multipartEntityBuilder.build());
        }
    }

    protected Cookie toHttpCookie(javax.servlet.http.Cookie cookie) {
        BasicClientCookie basicClientCookie = new BasicClientCookie(cookie.getName(), cookie.getValue());
        basicClientCookie.setDomain(cookie.getDomain());
        int maxAge = cookie.getMaxAge();
        if (maxAge > 0) {
            Date expiryDate = new Date(System.currentTimeMillis() + (long)maxAge * 1000L);
            basicClientCookie.setExpiryDate(expiryDate);
            basicClientCookie.setAttribute("max-age", String.valueOf(maxAge));
        }
        basicClientCookie.setPath(cookie.getPath());
        basicClientCookie.setSecure(cookie.getSecure());
        basicClientCookie.setVersion(cookie.getVersion());
        return basicClientCookie;
    }

    protected Cookie[] toHttpCookies(javax.servlet.http.Cookie[] cookies) {
        if (cookies == null) {
            return null;
        }
        Cookie[] httpCookies = new Cookie[cookies.length];
        for (int i = 0; i < cookies.length; ++i) {
            httpCookies[i] = this.toHttpCookie(cookies[i]);
        }
        return httpCookies;
    }

    protected javax.servlet.http.Cookie toServletCookie(Cookie httpCookie) {
        String path;
        Date expiryDate;
        String domain;
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(httpCookie.getName(), httpCookie.getValue());
        if (!PropsValues.SESSION_COOKIE_USE_FULL_HOSTNAME && Validator.isNotNull((String)(domain = httpCookie.getDomain()))) {
            cookie.setDomain(domain);
        }
        if ((expiryDate = httpCookie.getExpiryDate()) != null) {
            int maxAge = (int)(expiryDate.getTime() - System.currentTimeMillis());
            if ((maxAge /= 1000) > -1) {
                cookie.setMaxAge(maxAge);
            }
        }
        if (Validator.isNotNull((String)(path = httpCookie.getPath()))) {
            cookie.setPath(path);
        }
        cookie.setSecure(httpCookie.isSecure());
        cookie.setVersion(httpCookie.getVersion());
        return cookie;
    }

    protected javax.servlet.http.Cookie[] toServletCookies(List<Cookie> httpCookies) {
        if (httpCookies == null) {
            return null;
        }
        javax.servlet.http.Cookie[] cookies = new javax.servlet.http.Cookie[httpCookies.size()];
        for (int i = 0; i < httpCookies.size(); ++i) {
            cookies[i] = this.toServletCookie(httpCookies.get(i));
        }
        return cookies;
    }

    protected byte[] URLtoByteArray(String location, Http.Method method, Map<String, String> headers, Http.CookieSpec cookieSpec, javax.servlet.http.Cookie[] cookies, Http.Auth auth, Http.Body body, List<Http.FilePart> fileParts, List<Http.InputStreamPart> inputStreamParts, Map<String, String> parts, Http.Response response, boolean followRedirects, boolean normalizeURI, int timeout) throws IOException {
        try (InputStream inputStream = this.URLtoInputStream(location, method, headers, cookieSpec, cookies, auth, body, fileParts, inputStreamParts, parts, response, followRedirects, normalizeURI, timeout);){
            if (inputStream == null) {
                byte[] byArray = null;
                return byArray;
            }
            long contentLengthLong = response.getContentLengthLong();
            if (contentLengthLong > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(StringBundler.concat((Object[])new Object[]{"Retrieving ", location, " yields a file of size ", contentLengthLong, " bytes that is too large to convert to a byte array"}));
            }
            byte[] byArray = FileUtil.getBytes((InputStream)inputStream);
            return byArray;
        }
    }

    protected InputStream URLtoInputStream(String location, Http.Method method, Map<String, String> headers, Http.CookieSpec cookieSpec, javax.servlet.http.Cookie[] cookies, Http.Auth auth, Http.Body body, List<Http.FilePart> fileParts, List<Http.InputStreamPart> inputStreamParts, Map<String, String> parts, Http.Response response, boolean followRedirects, boolean normalizeURI, int timeout) throws IOException {
        URI uri = null;
        try {
            uri = HttpComponentsUtil.getURI((String)location);
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IOException("Invalid URI: " + location, uriSyntaxException);
        }
        BasicCookieStore basicCookieStore = null;
        CloseableHttpResponse closeableHttpResponse = null;
        HttpEntity httpEntity = null;
        try {
            Header contentTypeHeader;
            Header contentLengthHeader;
            String locationHeaderValue;
            _cookies.set(null);
            if (location == null) {
                InputStream inputStream = null;
                return inputStream;
            }
            if (!location.startsWith("http://") && !location.startsWith("https://")) {
                location = "http://" + location;
                uri = HttpComponentsUtil.getURI((String)location);
            }
            HttpHost targetHttpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            RequestConfig.Builder requestConfigBuilder = this._getRequestConfigBuilder(uri, timeout);
            int maxConnectionsPerHost = GetterUtil.getInteger((String)PropsUtil.get((String)(Http.class.getName() + ".max.connections.per.host"), (Filter)new Filter(uri.getHost())));
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = (PoolingHttpClientConnectionManager)this._poolingHttpClientConnectionManagerDCLSingleton.getSingleton(this::_createPoolingHttpClientConnectionManager);
            if (maxConnectionsPerHost > 0 && maxConnectionsPerHost != _MAX_CONNECTIONS_PER_HOST) {
                poolingHttpClientConnectionManager.setMaxPerRoute(new HttpRoute(new HttpHost(uri.getHost(), uri.getPort())), maxConnectionsPerHost);
            }
            RequestConfig requestConfig = requestConfigBuilder.build();
            CloseableHttpClient httpClient = null;
            httpClient = requestConfig.getProxy() != null && this.hasProxyConfig() && Validator.isNotNull((String)_PROXY_USERNAME) ? (CloseableHttpClient)this._proxyCloseableHttpClientDCLSingleton.getSingleton(() -> this._createCloseableHttpClient(poolingHttpClientConnectionManager, new HttpHost(_PROXY_HOST, _PROXY_PORT), this._proxyAuthPrefs)) : (CloseableHttpClient)this._closeableHttpClientDCLSingleton.getSingleton(() -> this._createCloseableHttpClient(poolingHttpClientConnectionManager, null, null));
            HttpClientContext httpClientContext = HttpClientContext.create();
            RequestBuilder requestBuilder = null;
            if (method.equals((Object)Http.Method.PATCH) || method.equals((Object)Http.Method.POST) || method.equals((Object)Http.Method.PUT)) {
                requestBuilder = method.equals((Object)Http.Method.PATCH) ? RequestBuilder.patch((String)location) : (method.equals((Object)Http.Method.POST) ? RequestBuilder.post((String)location) : RequestBuilder.put((String)location));
                if (body != null) {
                    StringEntity stringEntity = new StringEntity(body.getContent(), body.getCharset());
                    stringEntity.setContentType(body.getContentType());
                    requestBuilder.setEntity((HttpEntity)stringEntity);
                } else if (method.equals((Object)Http.Method.POST)) {
                    if (!this.hasRequestHeader(requestBuilder, "Content-Type")) {
                        ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom();
                        connectionConfigBuilder.setCharset(Charset.forName("UTF-8"));
                        poolingHttpClientConnectionManager.setConnectionConfig(targetHttpHost, connectionConfigBuilder.build());
                    }
                    this.processPostMethod(requestBuilder, headers, fileParts, inputStreamParts, parts);
                }
            } else {
                requestBuilder = method.equals((Object)Http.Method.DELETE) ? RequestBuilder.delete((String)location) : (method.equals((Object)Http.Method.HEAD) ? RequestBuilder.head((String)location) : RequestBuilder.get((String)location));
            }
            if (headers != null) {
                for (Map.Entry entry : headers.entrySet()) {
                    requestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if ((method.equals((Object)Http.Method.PATCH) || method.equals((Object)Http.Method.POST) || method.equals((Object)Http.Method.PUT)) && (body != null || ListUtil.isNotEmpty(fileParts) || ListUtil.isNotEmpty(inputStreamParts) || MapUtil.isNotEmpty(parts)) && !this.hasRequestHeader(requestBuilder, "Content-Type")) {
                requestBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            }
            if (!this.hasRequestHeader(requestBuilder, "User-Agent")) {
                requestBuilder.addHeader("User-Agent", _DEFAULT_USER_AGENT);
            }
            if (cookieSpec != null) {
                if (cookieSpec.equals((Object)Http.CookieSpec.DEFAULT)) {
                    requestConfigBuilder.setCookieSpec("default");
                } else if (cookieSpec.equals((Object)Http.CookieSpec.IGNORE_COOKIES)) {
                    requestConfigBuilder.setCookieSpec("ignoreCookies");
                } else if (cookieSpec.equals((Object)Http.CookieSpec.NETSCAPE)) {
                    requestConfigBuilder.setCookieSpec("netscape");
                } else if (cookieSpec.equals((Object)Http.CookieSpec.STANDARD)) {
                    requestConfigBuilder.setCookieSpec("standard");
                } else if (cookieSpec.equals((Object)Http.CookieSpec.STANDARD_STRICT)) {
                    requestConfigBuilder.setCookieSpec("standard-strict");
                }
            } else {
                requestConfigBuilder.setCookieSpec("default");
            }
            if (ArrayUtil.isNotEmpty((Object[])cookies)) {
                basicCookieStore = new BasicCookieStore();
                Cookie[] httpCookies = this.toHttpCookies(cookies);
                basicCookieStore.addCookies(httpCookies);
                httpClientContext.setCookieStore((CookieStore)basicCookieStore);
            }
            if (auth != null) {
                requestConfigBuilder.setAuthenticationEnabled(true);
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                httpClientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                credentialsProvider.setCredentials(new AuthScope(auth.getHost(), auth.getPort(), auth.getRealm()), (Credentials)new UsernamePasswordCredentials(auth.getUsername(), auth.getPassword()));
            }
            requestConfigBuilder.setNormalizeUri(normalizeURI);
            this.addProxyCredentials(uri, httpClientContext);
            requestBuilder.setConfig(requestConfigBuilder.build());
            closeableHttpResponse = httpClient.execute(targetHttpHost, (HttpRequest)requestBuilder.build(), (HttpContext)httpClientContext);
            httpEntity = closeableHttpResponse.getEntity();
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            response.setResponseCode(statusLine.getStatusCode());
            Header header = closeableHttpResponse.getFirstHeader("location");
            if (header != null && !(locationHeaderValue = header.getValue()).equals(location)) {
                if (followRedirects) {
                    EntityUtils.consumeQuietly((HttpEntity)httpEntity);
                    closeableHttpResponse.close();
                    InputStream inputStream = this.URLtoInputStream(locationHeaderValue, Http.Method.GET, headers, cookieSpec, cookies, auth, body, fileParts, inputStreamParts, parts, response, followRedirects, normalizeURI, timeout);
                    return inputStream;
                }
                response.setRedirect(locationHeaderValue);
            }
            if ((contentLengthHeader = closeableHttpResponse.getFirstHeader("Content-Length")) != null) {
                long contentLengthLong = GetterUtil.getLong((String)contentLengthHeader.getValue());
                response.setContentLengthLong(contentLengthLong);
                if (contentLengthLong > 0x7FFFFFF7L) {
                    response.setContentLength(-1);
                } else {
                    int contentLength = (int)contentLengthLong;
                    response.setContentLength(contentLength);
                }
            }
            if ((contentTypeHeader = closeableHttpResponse.getFirstHeader("Content-Type")) != null) {
                response.setContentType(contentTypeHeader.getValue());
            }
            for (Header header2 : closeableHttpResponse.getAllHeaders()) {
                response.addHeader(header2.getName(), header2.getValue());
            }
            if (httpEntity == null) {
                Header[] exception = null;
                return exception;
            }
            InputStream inputStream = httpEntity.getContent();
            final CloseableHttpResponse referenceCloseableHttpResponse = closeableHttpResponse;
            final Reference reference = FinalizeManager.register((Object)inputStream, (FinalizeAction)new FinalizeAction(){

                public void doFinalize(Reference<?> reference) {
                    block2: {
                        try {
                            referenceCloseableHttpResponse.close();
                        }
                        catch (IOException ioException) {
                            if (!_log.isDebugEnabled()) break block2;
                            _log.debug((Object)"Unable to close response", (Throwable)ioException);
                        }
                    }
                }
            }, (FinalizeManager.ReferenceFactory)FinalizeManager.WEAK_REFERENCE_FACTORY);
            UnsyncFilterInputStream unsyncFilterInputStream = new UnsyncFilterInputStream(inputStream){

                public void close() throws IOException {
                    super.close();
                    referenceCloseableHttpResponse.close();
                    reference.clear();
                }
            };
            return unsyncFilterInputStream;
        }
        catch (Exception exception) {
            block59: {
                if (httpEntity != null) {
                    EntityUtils.consumeQuietly(httpEntity);
                }
                if (closeableHttpResponse != null) {
                    try {
                        closeableHttpResponse.close();
                    }
                    catch (IOException ioException) {
                        if (!_log.isWarnEnabled()) break block59;
                        _log.warn((Object)"Unable to close response", (Throwable)ioException);
                    }
                }
            }
            throw new IOException(exception);
        }
        finally {
            try {
                if (basicCookieStore != null) {
                    _cookies.set(this.toServletCookies(basicCookieStore.getCookies()));
                }
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }

    private static void _destroyPoolingHttpClientConnectionManager(PoolingHttpClientConnectionManager poolingHttpClientConnectionManager) {
        PoolStats poolStats;
        int availableConnections;
        for (int retry = 0; retry < 10 && (availableConnections = (poolStats = poolingHttpClientConnectionManager.getTotalStats()).getAvailable()) > 0; ++retry) {
            poolingHttpClientConnectionManager.closeIdleConnections(200L, TimeUnit.MILLISECONDS);
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)interruptedException);
            }
        }
        poolingHttpClientConnectionManager.shutdown();
    }

    private CloseableHttpClient _createCloseableHttpClient(PoolingHttpClientConnectionManager poolingHttpClientConnectionManager, HttpHost httpHost, List<String> proxyAuthPrefs) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder = requestConfigBuilder.setConnectTimeout(_TIMEOUT);
        requestConfigBuilder = requestConfigBuilder.setConnectionRequestTimeout(_TIMEOUT);
        if (httpHost != null) {
            requestConfigBuilder.setProxy(httpHost);
        }
        if (proxyAuthPrefs != null) {
            requestConfigBuilder.setProxyPreferredAuthSchemes(proxyAuthPrefs);
        }
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        httpClientBuilder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
                long keepAliveDuration = super.getKeepAliveDuration(httpResponse, httpContext);
                if (keepAliveDuration > 0L) {
                    return keepAliveDuration;
                }
                return (long)HttpImpl.this._httpConfiguration.keepAliveTimeout() * 1000L;
            }
        });
        httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault()));
        return httpClientBuilder.build();
    }

    private PoolingHttpClientConnectionManager _createPoolingHttpClientConnectionManager() {
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSystemSocketFactory()).build());
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(_MAX_CONNECTIONS_PER_HOST);
        poolingHttpClientConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoKeepAlive(this._httpConfiguration.tcpKeepAliveEnabled()).build());
        poolingHttpClientConnectionManager.setMaxTotal(_MAX_TOTAL_CONNECTIONS);
        return poolingHttpClientConnectionManager;
    }

    private RequestConfig.Builder _getRequestConfigBuilder(URI uri, int timeout) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Location is " + uri.toString()));
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (this.isProxyHost(uri.getHost())) {
            HttpHost proxy = new HttpHost(_PROXY_HOST, _PROXY_PORT);
            requestConfigBuilder.setProxy(proxy);
            if (this._proxyCredentials != null) {
                requestConfigBuilder.setProxyPreferredAuthSchemes(this._proxyAuthPrefs);
            }
        }
        if (timeout == 0) {
            timeout = GetterUtil.getInteger((String)PropsUtil.get((String)(Http.class.getName() + ".timeout"), (Filter)new Filter(uri.getHost())));
        }
        if (timeout > 0) {
            requestConfigBuilder = requestConfigBuilder.setConnectTimeout(timeout);
            requestConfigBuilder = requestConfigBuilder.setConnectionRequestTimeout(timeout);
        }
        return requestConfigBuilder;
    }
}

