/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instance.lifecycle;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.servlet.InitialRequestSyncUtil;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class InitialRequestPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(InitialRequestPortalInstanceLifecycleListener.class);
    private BundleContext _bundleContext;
    private final Set<Long> _companyIds = new HashSet<Long>();
    private File _dataFile;
    private volatile UnsafeConsumer<Long, Exception> _portalInstanceRegisteredUnsafeConsumer = this::_registerPortalInstanceRegisteredSyncCallable;

    @Override
    public void portalInstanceRegistered(Company company) throws Exception {
        this._portalInstanceRegisteredUnsafeConsumer.accept((Object)company.getCompanyId());
    }

    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        Class<?> clazz = this.getClass();
        this._dataFile = this._bundleContext.getDataFile(clazz.getName() + ".data");
        this._loadCompanyIds();
        for (long companyId : this._companyIds) {
            this._registerPortalInstanceRegisteredSyncCallable(companyId);
        }
    }

    protected abstract void doPortalInstanceRegistered(long var1) throws Exception;

    private void _loadCompanyIds() {
        block5: {
            if (this._dataFile.exists() && !StartupHelperUtil.isDBNew()) {
                try {
                    Deserializer deserializer = new Deserializer(ByteBuffer.wrap(FileUtil.getBytes((File)this._dataFile)));
                    Bundle bundle = this._bundleContext.getBundle();
                    if (deserializer.readLong() == bundle.getLastModified()) {
                        int size = deserializer.readInt();
                        for (int i = 0; i < size; ++i) {
                            this._companyIds.add(deserializer.readLong());
                        }
                    }
                }
                catch (IOException ioException) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)"Unable to load company ids", (Throwable)ioException);
                }
            }
        }
    }

    private void _registerPortalInstanceRegisteredSyncCallable(long companyId) {
        if (this._companyIds.add(companyId)) {
            this._saveCompanyIds(this._companyIds);
        }
        InitialRequestSyncUtil.registerSyncCallable(() -> {
            try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)companyId);){
                this.doPortalInstanceRegistered(companyId);
            }
            finally {
                if (this._companyIds.remove(companyId)) {
                    this._saveCompanyIds(this._companyIds);
                }
                this._portalInstanceRegisteredUnsafeConsumer = this::doPortalInstanceRegistered;
            }
            return null;
        });
    }

    private void _saveCompanyIds(Set<Long> companyIds) {
        block16: {
            if (companyIds.isEmpty()) {
                this._dataFile.delete();
                return;
            }
            Bundle bundle = this._bundleContext.getBundle();
            Serializer serializer = new Serializer();
            serializer.writeLong(bundle.getLastModified());
            serializer.writeInt(companyIds.size());
            for (long companyId : companyIds) {
                serializer.writeLong(companyId);
            }
            try (FileOutputStream outputStream = new FileOutputStream(this._dataFile);){
                serializer.writeTo((OutputStream)outputStream);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block16;
                _log.warn((Object)"Unable to write company IDs", (Throwable)exception);
            }
        }
    }
}

