/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instances.service.internal.initializer;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.instances.initializer.PortalInstanceInitializer;
import com.liferay.portal.instances.initializer.PortalInstanceInitializerRegistry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={PortalInstanceInitializerRegistry.class})
public class PortalInstanceInitializerRegistryImpl
implements PortalInstanceInitializerRegistry {
    private static final Log _log = LogFactoryUtil.getLog(PortalInstanceInitializerRegistryImpl.class);
    private ServiceTrackerMap<String, PortalInstanceInitializer> _serviceTrackerMap;

    public PortalInstanceInitializer getPortalInstanceInitializer(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        PortalInstanceInitializer portalInstanceInitializer = (PortalInstanceInitializer)this._serviceTrackerMap.getService((Object)key);
        if (portalInstanceInitializer == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No portal instance initializer registered with key " + key));
            }
            return null;
        }
        return portalInstanceInitializer;
    }

    public List<PortalInstanceInitializer> getPortalInstanceInitializers() {
        return this.getPortalInstanceInitializers(false);
    }

    public List<PortalInstanceInitializer> getPortalInstanceInitializers(boolean activeOnly) {
        if (!activeOnly) {
            return new ArrayList<PortalInstanceInitializer>(this._serviceTrackerMap.values());
        }
        ArrayList<PortalInstanceInitializer> portalInstanceInitializers = new ArrayList<PortalInstanceInitializer>();
        for (PortalInstanceInitializer portalInstanceInitializer : this._serviceTrackerMap.values()) {
            if (!portalInstanceInitializer.isActive()) continue;
            portalInstanceInitializers.add(portalInstanceInitializer);
        }
        return portalInstanceInitializers;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, PortalInstanceInitializer.class, (String)"portal.instance.initializer.key");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

