/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instances.service.impl;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.instances.service.base.PortalInstancesLocalServiceBaseImpl;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayRenderRequest;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ColorSchemeFactory;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portlet.RenderRequestFactory;
import com.liferay.portlet.RenderResponseFactory;
import com.liferay.site.initializer.SiteInitializer;
import com.liferay.site.initializer.SiteInitializerRegistry;
import java.util.Collection;
import java.util.List;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.util.PortalInstances"}, service={AopService.class})
public class PortalInstancesLocalServiceImpl
extends PortalInstancesLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortalInstancesLocalServiceImpl.class);
    @Reference
    private ColorSchemeFactory _colorSchemeFactory;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PrefsProps _prefsProps;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SiteInitializerRegistry _siteInitializerRegistry;
    @Reference
    private ThemeLocalService _themeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public long[] getCompanyIds() {
        return PortalInstances.getCompanyIds();
    }

    public long getDefaultCompanyId() {
        return PortalInstances.getDefaultCompanyId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializePortalInstance(long companyId, String siteInitializerKey) throws PortalException {
        Company company = this._companyLocalService.getCompany(companyId);
        PortalInstances.initCompany((Company)company);
        if (Validator.isNull((String)siteInitializerKey)) {
            return;
        }
        SiteInitializer siteInitializer = this._siteInitializerRegistry.getSiteInitializer(siteInitializerKey);
        if (siteInitializer == null) {
            throw new PortalException("Invalid site initializer key " + siteInitializerKey);
        }
        PermissionChecker currentThreadPermissionChecker = PermissionThreadLocal.getPermissionChecker();
        String currentThreadPrincipalName = PrincipalThreadLocal.getName();
        ServiceContext currentThreadServiceContext = ServiceContextThreadLocal.getServiceContext();
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setInitializingPortalInstance((boolean)true);){
            Role role = this._roleLocalService.fetchRole(companyId, "Administrator");
            List users = this._userLocalService.getRoleUsers(role.getRoleId());
            User user = (User)users.get(0);
            PermissionChecker permissionChecker = this._permissionCheckerFactory.create(user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            PrincipalThreadLocal.setName((long)user.getUserId());
            Group group = this._groupLocalService.getGroup(company.getCompanyId(), "Guest");
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)this._populateServiceContext(company, group, currentThreadServiceContext.getRequest(), permissionChecker, (ServiceContext)currentThreadServiceContext.clone(), user));
            this._layoutLocalService.deleteLayouts(group.getGroupId(), false, new ServiceContext());
            siteInitializer.initialize(group.getGroupId());
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)currentThreadPermissionChecker);
            PrincipalThreadLocal.setName((String)currentThreadPrincipalName);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)currentThreadServiceContext);
        }
    }

    @Clusterable
    public void synchronizePortalInstances() {
        try {
            long[] initializedCompanyIds = this._portal.getCompanyIds();
            List removeableCompanyIds = ListUtil.fromArray((long[])initializedCompanyIds);
            this._companyLocalService.forEachCompany(company -> {
                removeableCompanyIds.remove(company.getCompanyId());
                if (ArrayUtil.contains((long[])initializedCompanyIds, (long)company.getCompanyId())) {
                    return;
                }
                PortalInstances.initCompany((Company)company);
            });
            this._companyLocalService.forEachCompanyId(companyId -> PortalInstances.removeCompany((long)companyId), ArrayUtil.toLongArray((Collection)removeableCompanyIds));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private ServiceContext _populateServiceContext(Company company, Group group, HttpServletRequest httpServletRequest, PermissionChecker permissionChecker, ServiceContext serviceContext, User user) throws PortalException {
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setRequest(httpServletRequest);
        serviceContext.setScopeGroupId(group.getGroupId());
        serviceContext.setUserId(user.getUserId());
        if (httpServletRequest == null) {
            return serviceContext;
        }
        long controlPanelPlid = this._portal.getControlPanelPlid(company.getCompanyId());
        Layout controlPanelLayout = this._layoutLocalService.getLayout(controlPanelPlid);
        httpServletRequest.setAttribute("LAYOUT", (Object)controlPanelLayout);
        ThemeDisplay currentThemeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ThemeDisplay themeDisplay = null;
        if (currentThemeDisplay != null) {
            try {
                themeDisplay = (ThemeDisplay)currentThemeDisplay.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                _log.error((Throwable)cloneNotSupportedException);
            }
        } else {
            themeDisplay = new ThemeDisplay();
        }
        themeDisplay.setCompany(company);
        themeDisplay.setLayout(controlPanelLayout);
        themeDisplay.setLayoutSet(controlPanelLayout.getLayoutSet());
        themeDisplay.setLayoutTypePortlet((LayoutTypePortlet)controlPanelLayout.getLayoutType());
        themeDisplay.setLocale(LocaleUtil.getSiteDefault());
        String themeId = this._prefsProps.getString(company.getCompanyId(), "control.panel.layout.regular.theme.id");
        themeDisplay.setLookAndFeel(this._themeLocalService.getTheme(company.getCompanyId(), themeId), this._colorSchemeFactory.getDefaultRegularColorScheme());
        themeDisplay.setPermissionChecker(permissionChecker);
        themeDisplay.setPlid(controlPanelPlid);
        themeDisplay.setRealUser(user);
        themeDisplay.setRequest(httpServletRequest);
        themeDisplay.setScopeGroupId(controlPanelLayout.getGroupId());
        themeDisplay.setSiteGroupId(controlPanelLayout.getGroupId());
        themeDisplay.setUser(user);
        httpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        if (portletRequest != null) {
            return serviceContext;
        }
        Portlet portlet = this._portletLocalService.getPortletById(0L, "90");
        try {
            InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)httpServletRequest.getServletContext());
            PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)httpServletRequest.getServletContext());
            LiferayRenderRequest liferayRenderRequest = RenderRequestFactory.create((HttpServletRequest)httpServletRequest, (Portlet)portlet, (InvokerPortlet)invokerPortlet, (PortletContext)portletConfig.getPortletContext(), (WindowState)WindowState.NORMAL, (PortletMode)PortletMode.VIEW, (PortletPreferences)PortletPreferencesFactoryUtil.fromDefaultXML((String)portlet.getDefaultPreferences()), (long)themeDisplay.getPlid());
            httpServletRequest.setAttribute("javax.portlet.request", (Object)liferayRenderRequest);
            httpServletRequest.setAttribute("javax.portlet.response", (Object)RenderResponseFactory.create((HttpServletResponse)new DummyHttpServletResponse(), (RenderRequest)liferayRenderRequest));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return serviceContext;
    }
}

