/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jmx.internal;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.jmx.MBeanRegistry;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={MBeanRegistry.class})
public class MBeanRegistryImpl
implements MBeanRegistry {
    private static final Log _log = LogFactoryUtil.getLog(MBeanRegistryImpl.class);
    private BundleContext _bundleContext;
    private MBeanServer _mBeanServer;
    private final Map<String, ObjectName> _objectNameCache = new ConcurrentHashMap<String, ObjectName>();
    private ServiceTracker<Object, Object> _serviceTracker;

    public MBeanServer getMBeanServer() {
        return this._mBeanServer;
    }

    public ObjectName getObjectName(String objectNameCacheKey) {
        return this._objectNameCache.get(objectNameCacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance register(String objectNameCacheKey, Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance objectInstance = this._mBeanServer.registerMBean(object, objectName);
        Map<String, ObjectName> map = this._objectNameCache;
        synchronized (map) {
            this._objectNameCache.put(objectNameCacheKey, objectInstance.getObjectName());
        }
        return objectInstance;
    }

    public void replace(String objectCacheKey, Object object, ObjectName objectName) throws Exception {
        try {
            this.register(objectCacheKey, object, objectName);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)instanceAlreadyExistsException);
            }
            this.unregister(objectCacheKey, objectName);
            this.register(objectCacheKey, object, objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String objectNameCacheKey, ObjectName defaultObjectName) throws MBeanRegistrationException {
        Map<String, ObjectName> map = this._objectNameCache;
        synchronized (map) {
            block7: {
                ObjectName objectName = this._objectNameCache.remove(objectNameCacheKey);
                try {
                    if (objectName == null) {
                        this._mBeanServer.unregisterMBean(defaultObjectName);
                    } else {
                        this._mBeanServer.unregisterMBean(objectName);
                    }
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (!_log.isInfoEnabled()) break block7;
                    _log.info((Object)("Unable to unregister " + defaultObjectName), (Throwable)instanceNotFoundException);
                }
            }
        }
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        this._bundleContext = componentContext.getBundleContext();
        this._mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, (String)"(&(jmx.objectname=*)(objectClass=*MBean))", (ServiceTrackerCustomizer)new MBeanServiceTrackerCustomizer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() throws Exception {
        this._serviceTracker.close();
        Map<String, ObjectName> map = this._objectNameCache;
        synchronized (map) {
            for (ObjectName objectName : this._objectNameCache.values()) {
                try {
                    this._mBeanServer.unregisterMBean(objectName);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to unregister mbean" + objectName.getCanonicalName()), (Throwable)exception);
                }
            }
            this._objectNameCache.clear();
        }
    }

    private class MBeanServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private MBeanServiceTrackerCustomizer() {
        }

        public Object addingService(ServiceReference<Object> serviceReference) {
            String objectName = GetterUtil.getString((Object)serviceReference.getProperty("jmx.objectname"));
            String objectNameCacheKey = GetterUtil.getString((Object)serviceReference.getProperty("jmx.objectname.cache.key"));
            if (Validator.isNull((String)objectNameCacheKey)) {
                objectNameCacheKey = objectName;
            }
            Object service = MBeanRegistryImpl.this._bundleContext.getService(serviceReference);
            try {
                return MBeanRegistryImpl.this.register(objectNameCacheKey, service, new ObjectName(objectName));
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to register mbean", (Throwable)exception);
                }
                return null;
            }
        }

        public void modifiedService(ServiceReference<Object> serviceReference, Object service) {
        }

        public void removedService(ServiceReference<Object> serviceReference, Object service) {
            block3: {
                String objectName = GetterUtil.getString((Object)serviceReference.getProperty("jmx.objectname"));
                String objectNameCacheKey = GetterUtil.getString((Object)serviceReference.getProperty("jmx.objectname.cache.key"));
                if (Validator.isNull((String)objectNameCacheKey)) {
                    objectNameCacheKey = objectName;
                }
                MBeanRegistryImpl.this._bundleContext.ungetService(serviceReference);
                try {
                    MBeanRegistryImpl.this.unregister(objectNameCacheKey, new ObjectName(objectName));
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)"Unable to register mbean", (Throwable)exception);
                }
            }
        }
    }
}

