/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.web.service.client.internal;

import com.liferay.portal.json.web.service.client.BaseJSONWebServiceClientImpl;
import com.liferay.portal.json.web.service.client.JSONWebServiceTransportException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.nio.reactor.IOReactorException;

public class JSONWebServiceClientImpl
extends BaseJSONWebServiceClientImpl {
    private static final Log _log = LogFactoryUtil.getLog(JSONWebServiceClientImpl.class);

    @Override
    public void afterPropertiesSet() throws IOReactorException {
        super.afterPropertiesSet();
    }

    protected void activate(Map<String, Object> properties) throws IOReactorException {
        this._setHeaders(this.getString("headers", properties));
        this.setClassLoader((ClassLoader)properties.get("classLoader"));
        this.setHostName(this.getString("hostName", properties));
        this.setHostPort(GetterUtil.getInteger((String)this.getString("hostPort", properties)));
        this.setKeyStore((KeyStore)properties.get("keyStore"));
        this.setLogin(this.getString("login", properties));
        if (properties.containsKey("maxAttempts")) {
            this.setMaxAttempts(GetterUtil.getInteger((String)this.getString("maxAttempts", properties)));
        }
        this.setPassword(this.getString("password", properties));
        this.setProtocol(this.getString("protocol", properties));
        if (properties.containsKey("proxyAuthType")) {
            this.setProxyAuthType(this.getString("proxyAuthType", properties));
            this.setProxyDomain(this.getString("proxyDomain", properties));
            this.setProxyWorkstation(this.getString("proxyWorkstation", properties));
        }
        if (properties.containsKey("proxyHostName")) {
            this.setProxyHostName(this.getString("proxyHostName", properties));
            this.setProxyHostPort(GetterUtil.getInteger((String)this.getString("proxyHostPort", properties)));
            this.setProxyLogin(this.getString("proxyLogin", properties));
            this.setProxyPassword(this.getString("proxyPassword", properties));
        }
        if (properties.containsKey("trustSelfSignedCertificates")) {
            this.setTrustSelfSignedCertificates((Boolean)properties.get("trustSelfSignedCertificates"));
        }
        this.afterPropertiesSet();
    }

    protected String getString(String key, Map<String, Object> properties) {
        if (!properties.containsKey(key)) {
            return null;
        }
        return String.valueOf(properties.get(key));
    }

    @Override
    protected void signRequest(HttpRequestBase httpRequestBase) throws JSONWebServiceTransportException.SigningFailure {
    }

    private void _setHeaders(String headersString) {
        if (headersString == null) {
            return;
        }
        if ((headersString = headersString.trim()).length() < 3) {
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String header : headersString.split(";")) {
            String[] headerParts = header.split("=");
            if (headerParts.length != 2) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Ignoring invalid header " + header));
                continue;
            }
            headers.put(headerParts[0], headerParts[1]);
        }
        this.setHeaders(headers);
    }
}

